/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.PolicyTypeClassLoader;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class GetPolicyType
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(GetPolicyType.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public GetPolicyType(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public GetPolicyType(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        Session session = this.getConfigSession();
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string = (String)this.getParameter("policySet");
            String string2 = (String)this.getParameter("policyType");
            String[] stringArray = (String[])this.getParameter("attributes");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, string2, stringArray});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GetPolicyType, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            Properties properties = this.convertAttributeList(stringArray);
            String string3 = PolicySetWorkSpaceHelper.getPolicySetFile(session, string);
            PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(string3);
            policySetHelper.setLocale(this.getLocale());
            Properties properties2 = policySetHelper.getPolicyType(string2, stringArray);
            boolean bl = true;
            if (!properties.isEmpty()) {
                if (properties.containsKey("provides")) {
                    properties.remove("provides");
                }
                if (properties.containsKey("enabled")) {
                    properties.remove("enabled");
                }
                if (properties.containsKey("description")) {
                    properties.remove("description");
                }
                if (properties.isEmpty()) {
                    bl = false;
                }
            }
            if (bl) {
                String string4 = PolicySetWorkSpaceHelper.getPolicyTypeFile(session, string, string2);
                Properties properties3 = null;
                PolicyTypeProvider policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(string2);
                if (policyTypeProvider == null) {
                    throw new ClassNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0042E", new Object[]{string2}, "PolicyTypeProvider class not found for Policy type: {0}"));
                }
                properties3 = policyTypeProvider.getAttributes(string4, properties);
                if (properties3 != null && !properties3.isEmpty()) {
                    properties2.putAll((Map<?, ?>)properties3);
                }
            }
            commandResultImpl.setResult(properties2);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_1);
            commandResultImpl.setException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    private Properties convertAttributeList(String[] stringArray) {
        Properties properties = new Properties();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                properties.setProperty(stringArray[i], "");
            }
        }
        return properties;
    }
}

