/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.PolicyTypeClassLoader;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;

public class GetBinding
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(GetBinding.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();
    public static final String POLICY_ATTACHMENT_NOT_FOUND_MSG = "Policy attachment file is not found: ";
    public static final String CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "Client policy attachment file is not found: ";
    public static final String TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG = "System/trust policy attachment file is not found";
    private boolean getBindingList = false;

    public GetBinding(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public GetBinding(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        Session session = this.getConfigSession();
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string = (String)this.getParameter("policyType");
            Properties properties = (Properties)this.getParameter("bindingLocation");
            String[] stringArray = (String[])this.getParameter("attributes");
            String string2 = (String)this.getParameter("attachmentType");
            if (string2 == null) {
                string2 = "application";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, properties, stringArray, string2});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "GetBinding, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            Properties properties2 = this.convertAttributeList(stringArray);
            if (string == null && (properties.isEmpty() || !"*".equals(properties.getProperty("attachmentId")))) {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{"policyType"}, "The {0} input parameter is not valid"));
            }
            Properties properties3 = new Properties();
            String string3 = this.getBindingFile(session, string, properties, string2);
            if (string3 != null) {
                PolicyTypeProvider policyTypeProvider = PolicyTypeClassLoader.getPolicyTypeProvider(string);
                if (policyTypeProvider == null) throw new ClassNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0042E", new Object[]{string}, "PolicyTypeProvider class not found for Policy type: {0}"));
                properties3 = policyTypeProvider.getBinding(string3, properties2);
            } else if (this.getBindingList) {
                List list = null;
                if (string2.equals("system/trust")) {
                    list = PolicySetWorkSpaceHelper.listBindingsForTrust(session);
                } else {
                    String string4 = properties.getProperty("application");
                    list = PolicySetWorkSpaceHelper.listBindingsForApplication(session, string4, string2);
                }
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        properties3.setProperty("bindingName." + i, (String)list.get(i));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "binding list size = " + list.size());
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "bindingList is null");
                }
            }
            commandResultImpl.setResult(properties3);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_1);
            commandResultImpl.setException(throwable);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "execute");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getBindingFile(Session session, String string, Properties properties, String string2) throws WorkSpaceException, NoItemFoundException, InstantiationException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JAXBException, FileNotFoundException, DuplicateItemFoundException, IOException {
        String string3 = null;
        if (properties.isEmpty()) {
            return PolicySetWorkSpaceHelper.getCellDefaultBindingFile(session, string);
        }
        if (properties.containsKey("node")) {
            String string4 = properties.getProperty("node");
            String string5 = properties.getProperty("server");
            return PolicySetWorkSpaceHelper.getServerDefaultBindingFile(session, string, string4, string5);
        }
        String string6 = properties.getProperty("application");
        String string7 = properties.getProperty("attachmentId");
        if (string7 == null) throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0069E", new Object[]{"attachmentId"}, "Input parameter is invalid: {0}"));
        if (string6 == null && !string2.equals("system/trust")) {
            throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0034E", new Object[]{string2}, "The application name is required when attachment type is {0}"));
        }
        if (!string7.equals("*")) {
            String string8 = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            if (string2.equals("application")) {
                string8 = PolicySetWorkSpaceHelper.getPolicySetAttachmentFile(session, string6);
                string9 = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                string10 = "CWPST0031E";
            } else if (string2.equals("system/trust")) {
                string8 = PolicySetWorkSpaceHelper.getTrustAttachmentFile(session);
                string9 = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                string10 = "CWPST0033E";
            } else {
                if (!string2.equals("client")) throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0035E", new Object[]{string2}, "Invalid attachment type: {0}"));
                string8 = PolicySetWorkSpaceHelper.getClientAttachmentFile(session, string6);
                string9 = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                string10 = "CWPST0032E";
            }
            if (string8 == null) throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, string10, new Object[]{string6}, string9));
            PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string8);
            policySetAttachmentHelper.setLocale(this.getLocale());
            string11 = policySetAttachmentHelper.getBindingReference(string7);
            if (string11.equals("")) throw new NoItemFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0037E", new Object[]{string7}, "Binding reference not found for attachment: {0}"));
            if (!string2.equals("system/trust")) return PolicySetWorkSpaceHelper.getApplicationBindingFile(session, string6, string11, string);
            return PolicySetWorkSpaceHelper.getTrustBindingFile(session, string11, string);
        }
        this.getBindingList = true;
        return string3;
    }

    private Properties convertAttributeList(String[] stringArray) {
        Properties properties = new Properties();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                properties.setProperty(stringArray[i], "");
            }
        }
        return properties;
    }
}

