/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ExportPolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(ExportPolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private String className = this.getClass().getName();

    public ExportPolicySet(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public ExportPolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List validate(Session session, String string, String string2) throws CommandValidationException, WorkSpaceException, NoItemFoundException, Exception {
        Object object;
        File file;
        int n;
        int n2;
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        if ((list = PolicySetWorkSpaceHelper.getPolicySetDirectoryFiles(session, string)).size() < 1) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0021E", new Object[]{string}, "The following policySet does not contain any files: {0}"));
        }
        String string3 = System.getProperty("os.name");
        int n3 = 0;
        n3 = string3.startsWith("Window") ? ((n2 = string2.lastIndexOf("\\")) > (n = string2.lastIndexOf("/")) ? n2 : n) : string2.lastIndexOf("/");
        if (n3 == -1) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0024E", new Object[]{string2}, "The following output file name does not contain any file separator slashes: {0}"));
        }
        String string4 = string2.substring(0, n3);
        if (string4 == null || string4.equals("")) {
            string4 = "/";
        }
        if ((file = new File(string4)).exists()) {
            if (!file.isDirectory()) throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0019E", new Object[]{string4}, "The following directory path is not a directory: {0}"));
            if (!file.canWrite()) {
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0016E", new Object[]{string4}, "The following directory path is not writeable: {0}"));
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Export baseDirPath is: " + string4);
            }
            if (file != null) {
                file.mkdirs();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Export directories being created");
                }
            }
            object = file.getAbsolutePath();
            File file2 = new File((String)object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Export absolutePath is: " + (String)object);
            }
            if (!file2.getParentFile().canWrite()) {
                String string5 = file2.getParent();
                if (!tc.isDebugEnabled()) throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0016E", new Object[]{string5}, "The following directory path is not writeable: {0}"));
                Tr.debug(tc, "Export directory is readonly: " + string5);
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0016E", new Object[]{string5}, "The following directory path is not writeable: {0}"));
            }
        }
        object = new File(string2);
        if (((File)object).exists()) {
            if (((File)object).isFile()) {
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0022E", new Object[]{string2}, "The following output file name already exists: {0}"));
            }
            if (((File)object).isDirectory()) {
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0023E", new Object[]{string2}, "The following output file name is a directory: {0}"));
            }
        }
        if (!tc.isEntryEnabled()) return list;
        Tr.exit(tc, "validate");
        return list;
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        Session session = this.getConfigSession();
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string = (String)this.getParameter("policySet");
            String string2 = (String)this.getParameter("pathName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, string2});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ExportPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            List list = this.validate(session, string, string2);
            String string3 = PolicySetWorkSpaceHelper.getCellRepositoryPath(session);
            boolean bl = this.exportFiles(list, string3, string2);
            commandResultImpl.setResult(bl);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_1);
            commandResultImpl.setException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    private boolean exportFiles(List list, String string, String string2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportFiles");
        }
        boolean bl = false;
        byte[] byArray = new byte[1024];
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
            for (String string3 : list) {
                int n;
                FileInputStream fileInputStream = new FileInputStream(string + File.separatorChar + string3);
                zipOutputStream.putNextEntry(new ZipEntry(string3));
                while ((n = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
                fileInputStream.close();
            }
            zipOutputStream.close();
            bl = true;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, this.className, FFDC_ID_2);
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportFiles");
        }
        return bl;
    }
}

