/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.ValidationManager;
import java.util.ResourceBundle;

public class DeletePolicyType
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(DeletePolicyType.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String SOURCE_FILE = this.getClass().getName();
    private Session session = null;

    public DeletePolicyType(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + commandMetadata);
        }
    }

    public DeletePolicyType(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = null;
        boolean bl = false;
        try {
            commandResultImpl = new CommandResultImpl();
            this.setCommandResult(commandResultImpl);
            commandResultImpl.reset();
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string = (String)this.getParameter("policySet");
            String string2 = (String)this.getParameter("policyType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, string2});
            }
            this.session = this.getConfigSession();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DeletePolicyType, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            String string3 = PolicySetWorkSpaceHelper.getPolicySetFile(this.session, string);
            PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(string3);
            policySetHelper.setLocale(this.getLocale());
            if (policySetHelper.isDefaultPolicySet()) {
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0004E", new Object[]{string}, "A default policy set cannot be edited or deleted: {0}"));
            }
            bl = PolicySetWorkSpaceHelper.deletePolicyType(this.session, string, string2);
            int n = policySetHelper.deletePolicyType(string2);
            boolean bl2 = PolicySetWorkSpaceHelper.updatePolicySetFile(this.session, string);
            ValidationManager validationManager = ValidationManager.getManager(this.session);
            if (validationManager != null) {
                validationManager.markForValidation(string);
            }
            if (n == 0 && bl2) {
                commandResultImpl.setResult(Boolean.TRUE);
            } else {
                commandResultImpl.setResult(Boolean.FALSE);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.SOURCE_FILE + ".execute", FFDC_ID_1);
            Tr.error(tc, "WSPST0007E", new Object[]{exception.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + exception);
            }
            commandResultImpl.setException(exception);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "finally");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }
}

