/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import java.io.FileNotFoundException;
import java.util.ResourceBundle;

public class DeletePolicySetAttachment
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(DeletePolicySetAttachment.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    public static final String POLICY_ATTACHMENT_NOT_FOUND_MSG = "Policy attachment file is not found: ";
    public static final String CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG = "Client policy attachment file is not found: ";
    public static final String TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG = "System/trust policy attachment file is not found";
    private String className = this.getClass().getName();

    public DeletePolicySetAttachment(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public DeletePolicySetAttachment(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        Session session = this.getConfigSession();
        try {
            int n;
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string = (String)this.getParameter("applicationName");
            String string2 = (String)this.getParameter("attachmentId");
            String string3 = (String)this.getParameter("attachmentType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, string2, string3});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DeletePolicySetAttachment, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            if (string3 == null) {
                string3 = "application";
            }
            if (string == null && (string3.equals("application") || string3.equals("client"))) {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0034E", new Object[]{string3}, "Application name required when attachment type is: {0}"));
            }
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (string3.equals("application")) {
                string4 = PolicySetWorkSpaceHelper.getPolicySetAttachmentFile(session, string);
                string5 = POLICY_ATTACHMENT_NOT_FOUND_MSG;
                string6 = "CWPST0031E";
            } else if (string3.equals("system/trust")) {
                string4 = PolicySetWorkSpaceHelper.getTrustAttachmentFile(session);
                string5 = TRUST_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                string6 = "CWPST0033E";
            } else if (string3.equals("client")) {
                string4 = PolicySetWorkSpaceHelper.getClientAttachmentFile(session, string);
                string5 = CLIENT_POLICY_ATTACHMENT_NOT_FOUND_MSG;
                string6 = "CWPST0032E";
            } else {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0035E", new Object[]{string3}, "Invalid attachment type: {0}"));
            }
            if (string4 != null) {
                PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string4);
                policySetAttachmentHelper.setLocale(this.getLocale());
                n = policySetAttachmentHelper.detachPolicyId(string2);
                boolean bl = policySetAttachmentHelper.isAttachmentListEmpty();
                if (string3.equals("application")) {
                    if (bl) {
                        PolicySetWorkSpaceHelper.deletePolicySetAttachmentFile(session, string);
                    } else {
                        PolicySetWorkSpaceHelper.updatePolicySetAttachmentFile(session, string);
                    }
                } else if (string3.equals("system/trust")) {
                    if (bl) {
                        PolicySetWorkSpaceHelper.deleteTrustAttachmentFile(session);
                    } else {
                        PolicySetWorkSpaceHelper.updateTrustAttachmentFile(session);
                    }
                } else if (string3.equals("client")) {
                    if (bl) {
                        PolicySetWorkSpaceHelper.deleteClientAttachmentFile(session, string);
                    } else {
                        PolicySetWorkSpaceHelper.updateClientAttachmentFile(session, string);
                    }
                }
            } else {
                throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, string6, new Object[]{string}, string5));
            }
            if (n == 0) {
                commandResultImpl.setResult(Boolean.TRUE);
            } else {
                commandResultImpl.setResult(Boolean.FALSE);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className + ".execute()", FFDC_ID_1);
            commandResultImpl.setException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

