/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import java.util.ResourceBundle;

public class DeletePolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(DeletePolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private String className = this.getClass().getName();

    public DeletePolicySet(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public DeletePolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate(Session session, String string) throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            String string2 = PolicySetWorkSpaceHelper.getPolicySetFile(session, string);
            PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(string2);
            policySetHelper.setLocale(this.getLocale());
            boolean bl = policySetHelper.isDefaultPolicySet();
            if (bl) {
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0004E", new Object[]{string}, "Default policy sets cannot be deleted: {0}"));
            }
            String string3 = policySetHelper.getPolicySetType();
            if (string3.equals("system/trust")) {
                String string4 = PolicySetWorkSpaceHelper.getTrustAttachmentFile(session);
                if (string4 != null) {
                    PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string4);
                    policySetAttachmentHelper.setLocale(this.getLocale());
                    boolean bl2 = policySetAttachmentHelper.isAttachedToPolicySet(string);
                    if (bl2) {
                        throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0018E", new Object[]{string}, "Policy set {0} cannot be deleted because it is still attached"));
                    }
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer("");
                stringBuffer = PolicySetCommandUtil.getApplicationsAttachedToPolicySet(session, string);
                if (stringBuffer.length() > 0) {
                    throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0005E", new Object[]{string, stringBuffer.toString()}, "Policy set {0} cannot be deleted. It is still attached to the following applications: {1}"));
                }
            }
        }
        catch (CommandValidationException commandValidationException) {
            FFDCFilter.processException(commandValidationException, this.className, FFDC_ID_1);
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_2);
            throw new CommandValidationException(throwable, PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0006E", null, "Unexpected exception during command validation."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        Session session = this.getConfigSession();
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string = (String)this.getParameter("policySet");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DeletePolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            this.validate(session, string);
            PolicySetWorkSpaceHelper.deletePolicySet(session, string);
            commandResultImpl.setResult(Boolean.TRUE);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_3);
            commandResultImpl.setException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

