/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class DeleteAttachmentsForPolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(DeleteAttachmentsForPolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private static ResourceBundle resourceBundle = null;
    private String className = this.getClass().getName();

    public DeleteAttachmentsForPolicySet(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public DeleteAttachmentsForPolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        Session session = this.getConfigSession();
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            String string = (String)this.getParameter("policySet");
            String string2 = (String)this.getParameter("applicationName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, string2});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DeleteAttachmentsForPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            String string3 = PolicySetWorkSpaceHelper.getPolicySetFile(session, string);
            PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(string3);
            policySetHelper.setLocale(this.getLocale());
            String string4 = policySetHelper.getPolicySetType();
            int n = 0;
            int n2 = 0;
            String string52 = null;
            if (string4.equals("system/trust")) {
                string52 = PolicySetWorkSpaceHelper.getTrustAttachmentFile(session);
                n2 = this.deleteAttachmentsFromFile(session, string52, string, string4);
            } else {
                List list = new ArrayList();
                List list2 = new ArrayList();
                if (string4.equals("application")) {
                    if (string2 != null) {
                        list = PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application", string2);
                        list2 = PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client", string2);
                        list.addAll(list2);
                        if (list.isEmpty()) {
                            throw new FileNotFoundException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0041E", new Object[]{string2}, "Policy attachment file is not found for application: {0}"));
                        }
                    } else {
                        list = PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(session, "application");
                        list2 = PolicySetWorkSpaceHelper.listPolicySetAttachmentFiles(session, "client");
                        list.addAll(list2);
                    }
                }
                for (String string52 : list) {
                    n = this.deleteAttachmentsFromFile(session, string52, string, string4);
                    n2 += n;
                }
            }
            if (n2 == 0) {
                commandResultImpl.setResult(Boolean.TRUE);
            } else {
                commandResultImpl.setResult(Boolean.FALSE);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className + ".execute()", FFDC_ID_1);
            commandResultImpl.setException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    private int deleteAttachmentsFromFile(Session session, String string, String string2, String string3) throws Exception {
        int n = 0;
        PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string);
        policySetAttachmentHelper.setLocale(this.getLocale());
        boolean bl = policySetAttachmentHelper.isAttachedToPolicySet(string2);
        if (bl) {
            String string4 = null;
            String string5 = null;
            if (!string3.equals("system/trust")) {
                string4 = this.getApplicationName(string, string3);
                if (string4 == null) {
                    throw new Exception(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0040E", new Object[0], "Error in finding application name in file path"));
                }
                string5 = string.endsWith("policyAttachments.xml") ? "application" : "client";
            } else {
                string5 = "system/trust";
            }
            n = policySetAttachmentHelper.detachPolicySet(string2);
            boolean bl2 = policySetAttachmentHelper.isAttachmentListEmpty();
            if (string3.equals("system/trust")) {
                if (bl2) {
                    PolicySetWorkSpaceHelper.deleteTrustAttachmentFile(session);
                } else {
                    PolicySetWorkSpaceHelper.updateTrustAttachmentFile(session);
                }
            } else if (string.contains("policyAttachments.xml")) {
                if (bl2) {
                    PolicySetWorkSpaceHelper.deletePolicySetAttachmentFile(session, string4);
                } else {
                    PolicySetWorkSpaceHelper.updatePolicySetAttachmentFile(session, string4);
                }
            } else if (string.contains("clientPolicyAttachments.xml")) {
                if (bl2) {
                    PolicySetWorkSpaceHelper.deleteClientAttachmentFile(session, string4);
                } else {
                    PolicySetWorkSpaceHelper.updateClientAttachmentFile(session, string4);
                }
            }
        }
        return n;
    }

    private String getApplicationName(String string, String string2) {
        String string3 = null;
        String string4 = null;
        if (string.contains("policyAttachments.xml")) {
            string4 = string.substring(0, string.indexOf("policyAttachments.xml") - 1);
        } else if (string.contains("clientPolicyAttachments.xml")) {
            string4 = string.substring(0, string.indexOf("clientPolicyAttachments.xml") - 1);
        }
        if (string4 != null) {
            string4 = string4.substring(0, string4.lastIndexOf(File.separator));
            string3 = string4.substring(string4.lastIndexOf(File.separator) + 1);
        }
        return string3;
    }
}

