/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import java.util.ResourceBundle;

public class CreatePolicySetAttachment
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(CreatePolicySetAttachment.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private String className = this.getClass().getName();

    public CreatePolicySetAttachment(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public CreatePolicySetAttachment(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate(Session session, String string, String string2, String[] stringArray, String string3, String string4, boolean bl) throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            String string5 = PolicySetWorkSpaceHelper.getPolicySetFile(session, string2);
            if (!bl) {
                StringBuffer stringBuffer;
                if (string3.equals("system/trust")) {
                    stringBuffer = new StringBuffer("");
                    stringBuffer = PolicySetCommandUtil.validateTrustResources(session, stringArray);
                    if (stringBuffer.length() > 0) {
                        throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0011E", new Object[]{stringBuffer.toString()}, "The following list of resources are invalid: {0}"));
                    }
                } else {
                    stringBuffer = new StringBuffer("");
                    stringBuffer = PolicySetCommandUtil.validateResourcesForApplication(session, string, stringArray, string3, string2);
                    if (stringBuffer.length() > 0) {
                        throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0011E", new Object[]{stringBuffer.toString()}, "The following list of resources are invalid: {0}"));
                    }
                }
                stringBuffer = new StringBuffer("");
                stringBuffer = PolicySetCommandUtil.validateResourcesNotAttached(session, string3, string4, string, stringArray, null, false);
                if (stringBuffer.length() > 0) {
                    throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0013E", new Object[]{stringBuffer.toString()}, "The following list of resources are already attached: {0}"));
                }
            }
        }
        catch (CommandValidationException commandValidationException) {
            FFDCFilter.processException(commandValidationException, this.className, FFDC_ID_1);
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_2);
            throw new CommandValidationException(throwable, PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0006E", null, "Unexpected exception during command validation."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        Session session = this.getConfigSession();
        String string = null;
        String string2 = null;
        boolean bl = false;
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            string = (String)this.getParameter("applicationName");
            String string3 = (String)this.getParameter("policySet");
            String[] stringArray = (String[])this.getParameter("resources");
            string2 = (String)this.getParameter("attachmentType");
            Boolean bl2 = (Boolean)this.getParameter("dynamicClient");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, string3, stringArray, string2, bl2});
            }
            if (string2 == null) {
                string2 = "application";
            }
            if (string == null && (string2.equals("application") || string2.equals("client"))) {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0034E", new Object[]{string2}, "Application name required when attachment type is: {0}"));
            }
            boolean bl3 = false;
            if (bl2 != null && (bl3 = bl2.booleanValue()) && !string2.equals("client")) {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0036E", new Object[0], "Dynamic client only allowed when attachment type is client"));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CreatePolicySetAttachment, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            String string4 = null;
            if (string2.equals("application")) {
                string4 = PolicySetWorkSpaceHelper.getPolicySetAttachmentFile(session, string);
                if (string4 == null) {
                    string4 = PolicySetWorkSpaceHelper.createPolicySetAttachmentFile(session, string);
                    bl = true;
                }
            } else if (string2.equals("system/trust")) {
                string4 = PolicySetWorkSpaceHelper.getTrustAttachmentFile(session);
                if (string4 == null) {
                    string4 = PolicySetWorkSpaceHelper.createTrustAttachmentFile(session);
                    bl = true;
                }
            } else if (string2.equals("client")) {
                string4 = PolicySetWorkSpaceHelper.getClientAttachmentFile(session, string);
                if (string4 == null) {
                    string4 = PolicySetWorkSpaceHelper.createClientAttachmentFile(session, string);
                    bl = true;
                }
            } else {
                throw new IllegalArgumentException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0035E", new Object[]{string2}, "Invalid attachment type: {0}"));
            }
            PolicySetAttachmentHelper policySetAttachmentHelper = PolicySetAttachmentHelperFactory.createHelper(string4);
            policySetAttachmentHelper.setLocale(this.getLocale());
            if (bl) {
                policySetAttachmentHelper.createPolicySetAttachment();
            }
            String string5 = null;
            if (string4 != null) {
                this.validate(session, string, string3, stringArray, string2, string4, bl3);
                string5 = policySetAttachmentHelper.attachPolicySet(string3, string2, stringArray);
                if (!bl) {
                    if (string2.equals("application")) {
                        PolicySetWorkSpaceHelper.updatePolicySetAttachmentFile(session, string);
                    } else if (string2.equals("system/trust")) {
                        PolicySetWorkSpaceHelper.updateTrustAttachmentFile(session);
                    } else if (string2.equals("client")) {
                        PolicySetWorkSpaceHelper.updateClientAttachmentFile(session, string);
                    }
                }
            } else {
                throw new Exception(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0038E", new Object[0], "Error in creating Policy Set Attachment file"));
            }
            if (string5 == null) {
                throw new Exception(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0039E", new Object[0], "Error in retrieving Policy Set ID, value is null"));
            }
            commandResultImpl.setResult(string5);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className + ".execute()", FFDC_ID_3);
            try {
                if (bl) {
                    if (string2.equals("application")) {
                        PolicySetWorkSpaceHelper.deletePolicySetAttachmentFile(session, string);
                    } else if (string2.equals("system/trust")) {
                        PolicySetWorkSpaceHelper.deleteTrustAttachmentFile(session);
                    } else if (string2.equals("client")) {
                        PolicySetWorkSpaceHelper.deleteClientAttachmentFile(session, string);
                    }
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            commandResultImpl.setException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

