/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.DuplicateItemFoundException;

public class CreatePolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(CreatePolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private String className = this.getClass().getName();

    public CreatePolicySet(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public CreatePolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        Session session = this.getConfigSession();
        String string = null;
        try {
            string = (String)this.getParameter("policySet");
            String string2 = (String)this.getParameter("description");
            String string3 = (String)this.getParameter("policySetType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, string2, string3});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            PolicySetCommandUtil.validatePolicySetName(string);
            String string4 = PolicySetWorkSpaceHelper.createPolicySet(session, string);
            PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(string4);
            policySetHelper.createPolicySet(string2, string3);
            commandResultImpl.setResult(Boolean.TRUE);
        }
        catch (DuplicateItemFoundException duplicateItemFoundException) {
            FFDCFilter.processException(duplicateItemFoundException, this.className, FFDC_ID_1);
            commandResultImpl.setException(duplicateItemFoundException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_2);
            try {
                PolicySetWorkSpaceHelper.deletePolicySet(session, string);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            commandResultImpl.setException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

