/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.exceptions.NoItemFoundException;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class CopyPolicySet
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(CopyPolicySet.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    private String className = this.getClass().getName();

    public CopyPolicySet(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public CopyPolicySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private List validate(Session session, String string, String string2) throws CommandValidationException, WorkSpaceException, NoItemFoundException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        PolicySetCommandUtil.validatePolicySetName(string2);
        List list = PolicySetWorkSpaceHelper.getPolicySetDirectoryFiles(session, string);
        if (list.size() < 1) {
            throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0021E", new Object[]{string}, "The following policySet does not contain any files: {0}"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return list;
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        this.setCommandResult(commandResultImpl);
        commandResultImpl.reset();
        Session session = this.getConfigSession();
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            boolean bl = false;
            String string = (String)this.getParameter("sourcePolicySet");
            String string2 = (String)this.getParameter("newPolicySet");
            String string3 = (String)this.getParameter("newDescription");
            Boolean bl2 = (Boolean)this.getParameter("transferAttachments");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, string2, string3, bl2});
            }
            if (bl2 != null) {
                bl = bl2;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CopyPolicySet, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            List list = this.validate(session, string, string2);
            String string4 = PolicySetWorkSpaceHelper.getCellRepositoryPath(session);
            String string5 = PolicySetWorkSpaceHelper.createPolicySet(session, string2);
            boolean bl3 = PolicySetWorkSpaceHelper.copyPolicySetFiles(session, list, string4, string, string2);
            Properties properties = new Properties();
            properties.setProperty("name", string2);
            if (string3 != null) {
                properties.setProperty("description", string3);
            }
            properties.setProperty("default", "false");
            int n = 0;
            PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(string5);
            policySetHelper.setLocale(this.getLocale());
            n = policySetHelper.updatePolicySet(properties, true);
            PolicySetWorkSpaceHelper.updatePolicySetFile(session, string2);
            int n2 = 0;
            if (bl) {
                String string6 = policySetHelper.getPolicySetType();
                n2 = PolicySetCommandUtil.transferAttachments(session, string, string2, null, string6);
            }
            if (bl3 && n == 0 && n2 == 0) {
                commandResultImpl.setResult(Boolean.TRUE);
            } else {
                commandResultImpl.setResult(Boolean.FALSE);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.className, FFDC_ID_1);
            commandResultImpl.setException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }
}

