/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.policyset.admin.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetHelper;
import com.ibm.ws.policyset.admin.PolicySetHelperFactory;
import com.ibm.ws.policyset.admin.commands.PolicySetCommandUtil;
import com.ibm.ws.policyset.admin.commands.PolicySetWorkSpaceHelper;
import com.ibm.ws.policyset.admin.commands.ValidationManager;
import java.util.ResourceBundle;

public class AddPolicyType
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(AddPolicyType.class, "policyset.admin", "com.ibm.ws.policyset.admin.resources.policySetAdmin");
    private static ResourceBundle resourceBundle = null;
    private static final String FFDC_ID_1 = "FFDC-1";
    protected String SOURCE_FILE = this.getClass().getName();
    private Session session = null;

    public AddPolicyType(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor inMetadata=" + commandMetadata);
        }
    }

    public AddPolicyType(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructor commandData=" + commandData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = null;
        boolean bl = false;
        try {
            resourceBundle = ResourceBundle.getBundle("com.ibm.ws.policyset.admin.resources.policySetAdmin", this.getLocale());
            commandResultImpl = new CommandResultImpl();
            this.setCommandResult(commandResultImpl);
            commandResultImpl.reset();
            String string = (String)this.getParameter("policySet");
            String string2 = (String)this.getParameter("policyType");
            Boolean bl2 = (Boolean)this.getParameter("enabled");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parameters: ", new Object[]{string, string2, bl2});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddPolicyType, Locale is " + this.getLocale().getDisplayName());
            }
            PolicySetWorkSpaceHelper.setLocale(this.getLocale());
            PolicySetCommandUtil.setLocale(this.getLocale());
            boolean bl3 = true;
            if (bl2 != null) {
                bl3 = bl2;
            }
            this.session = this.getConfigSession();
            String string3 = PolicySetWorkSpaceHelper.getPolicySetFile(this.session, string);
            PolicySetHelper policySetHelper = PolicySetHelperFactory.createHelper(string3);
            policySetHelper.setLocale(this.getLocale());
            if (policySetHelper.isDefaultPolicySet()) {
                throw new CommandValidationException(PolicySetCommandUtil.getFormattedMessage(resourceBundle, "CWPST0004E", new Object[]{string}, "A default policy set cannot be edited or deleted: {0}"));
            }
            bl = PolicySetWorkSpaceHelper.addPolicyType(this.session, string, string2);
            int n = policySetHelper.addPolicyType(string2, bl3);
            boolean bl4 = PolicySetWorkSpaceHelper.updatePolicySetFile(this.session, string);
            ValidationManager validationManager = ValidationManager.getManager(this.session);
            if (validationManager != null) {
                validationManager.markForValidation(string);
            }
            if (n == 0 && bl4) {
                commandResultImpl.setResult(Boolean.TRUE);
            } else {
                commandResultImpl.setResult(Boolean.FALSE);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, this.SOURCE_FILE + ".execute", FFDC_ID_1);
            Tr.error(tc, "CWPST0007E", new Object[]{exception.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught - " + exception);
            }
            commandResultImpl.setException(exception);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "finally");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute end");
        }
    }
}

