/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.ReaderPool;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionInformation;
import com.ibm.ws.orb.transport.ConnectionInterceptor;
import com.ibm.ws.orb.transport.WSSSLClientSocketFactory;
import com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.orbimpl.transport.ConnectionKey;
import com.ibm.ws.orbimpl.transport.WSTCPTransportConnection;
import com.ibm.ws.orbimpl.transport.WSTransport;
import com.ibm.ws.security.orbssl.SSLConnectionData;
import com.ibm.ws.security.util.AccessController;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.PrivilegedAction;
import javax.net.ssl.SSLSocket;

public class WSSSLTransportConnection
extends WSTCPTransportConnection {
    ConnectionInformation connectionInformation = null;

    public WSSSLTransportConnection(ConnectionTable connectionTable, Socket socket, ReaderPool readerPool, ORBForTransports oRBForTransports, ConnectionData connectionData, ConnectionInterceptor connectionInterceptor) {
        super(connectionTable, socket, readerPool, oRBForTransports, connectionData, connectionInterceptor, true);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(ConnectionTable, Socket, Readerpool, ORBFortransports, Connectiondata, ConnectionInterceptor)", "the socket for this connection is: " + socket);
        }
        SSLSocket sSLSocket = (SSLSocket)socket;
        final ConnectionData connectionData2 = connectionData;
        final SSLSocket sSLSocket2 = sSLSocket;
        final Socket socket2 = socket;
        this.connectionInformation = (ConnectionInformationImpl)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ConnectionInformationImpl(connectionData2, WSTransport.getWSSSLServerSocketFactory(WSSSLTransportConnection.this.getORBForTransports()).getPeerCertificateChain(sSLSocket2), System.currentTimeMillis(), socket2.getInetAddress().getHostName(), socket2.getPort());
            }
        });
        this.activateServer();
    }

    public WSSSLTransportConnection(ORBForTransports oRBForTransports, ConnectionTable connectionTable, ConnectionKey connectionKey, ORBConnection oRBConnection, ReaderPool readerPool, Profile profile, ConnectionData connectionData, ConnectionInterceptor connectionInterceptor) {
        super(oRBForTransports, connectionTable, connectionKey, oRBConnection, readerPool, profile, connectionData, connectionInterceptor);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "<init>(ORBForTransports, ConnectionTable, ConnectionKey, ORBConnection, ReaderPool, Profile, ConnectionData, ConnectionInterceptor", "the connection key for this connection is: " + connectionKey);
        }
        this.connectionInformation = new ConnectionInformationImpl(connectionData, null, System.currentTimeMillis(), null, -1);
    }

    public Socket createSocket(String string, int n) throws Exception {
        Socket socket = null;
        try {
            String string2 = this.getORBForTransports().getProperty("com.ibm.CORBA.LocalHost");
            boolean bl = string2 != null;
            String string3 = this.getORBForTransports().getProperty("com.ibm.ws.orb.transport.useMultiHome");
            boolean bl2 = string3 != null && string3.equalsIgnoreCase("false");
            SSLConnectionData sSLConnectionData = (SSLConnectionData)this.connectionData;
            this.connectionData.setLocalHost(string2);
            sSLConnectionData.setUseSingleNIC(bl && bl2);
            if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket()", "Connection Type=SSL Client Side Socket, LocalHost=" + string2 + ", Bind Client Socket To Multiple NIC cards=" + (!bl || !bl2));
            }
            WSSSLClientSocketFactory wSSSLClientSocketFactory = WSTransport.getWSSSLClientSocketFactory(this.getORBForTransports());
            socket = wSSSLClientSocketFactory.createSSLSocket(this.connectionData);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(host, port)", "The socket being returned is " + socket);
            }
            return socket;
        }
        catch (Exception exception) {
            if (LocationServiceImpl.threadLocalAvoidLogs.get() == null) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.orbimpl.transport.WSSSLTransportConnection.createSocket", "270", (Object)this);
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(4112L, (Object)this, "createSocket(host, port)", exception);
            }
            throw exception;
        }
    }

    public Socket createSocket(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) throws Exception {
        int n = this.getConnectTimeout();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSocket(server,client)", "connecting client=" + inetSocketAddress2 + " to server=" + inetSocketAddress + ", timeout=" + n + "ms is ignored");
        }
        return this.createSocket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
    }

    public Object getConnectionData() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getConnectionData()", "About to return connectionInformation=" + this.connectionInformation);
        }
        return this.connectionInformation;
    }
}

