/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.bindings;

import com.ibm.ejs.models.base.bindings.commonbnd.AbstractAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.MessageDestinationRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.Property;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.ResourceRefBindingImpl;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.MetaDataException;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.web.bnd.AuthenticationAliasType;
import com.ibm.ws.web.bnd.CustomLoginConfigurationType;
import com.ibm.ws.web.bnd.EjbRefType;
import com.ibm.ws.web.bnd.MessageDestinationRefType;
import com.ibm.ws.web.bnd.ObjectFactory;
import com.ibm.ws.web.bnd.PropertyType;
import com.ibm.ws.web.bnd.ResourceEnvRefType;
import com.ibm.ws.web.bnd.ResourceRefType;
import com.ibm.ws.web.bnd.VirtualHostType;
import com.ibm.ws.web.bnd.WebBndType;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebModuleHelper {
    private static final String CLASS_NAME = WebModuleHelper.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String BINDINGS_FILE = "ibm-web-bnd.xmi or ibm-web-bnd.xml";
    private static final String OLD_BINDINGS_FILE = "ibm-web-bnd.xmi";
    private static final String NEW_BINDINGS_FILE = "ibm-web-bnd.xml";
    private HashMap<String, String> ivEjbRefMap = new HashMap();
    private HashMap<String, String> ivResourceRefMap = new HashMap();
    private HashMap<String, String> ivResourceEnvRefMap = new HashMap();
    private HashMap<String, String> ivMdRefMap = new HashMap();
    private String ivVirtualHost;
    private List<ResourceRefType> ivResourceRefList = new LinkedList<ResourceRefType>();
    private final ObjectFactory ivJaxbFactory = new ObjectFactory();
    private String ivDisplayName;

    public final String getVirtualHost() {
        return this.ivVirtualHost;
    }

    public final Map<String, String> getEjbRefBindings() {
        return this.ivEjbRefMap;
    }

    public final Map<String, String> getResourceRefBindings() {
        return this.ivResourceRefMap;
    }

    public final List<ResourceRefBinding> getResourceRefBindingList() {
        ArrayList<ResourceRefBinding> arrayList = new ArrayList<ResourceRefBinding>(this.ivResourceRefList.size());
        for (ResourceRefType resourceRefType : this.ivResourceRefList) {
            arrayList.add(this.createResourceRefBinding(resourceRefType));
        }
        return arrayList;
    }

    public final Map<String, String> getResourceEnvRefBindings() {
        return this.ivResourceEnvRefMap;
    }

    public final Map<String, String> getMessageDestinationRefBindings() {
        return this.ivMdRefMap;
    }

    public void processBindingsFile(WebModuleRef webModuleRef, WebApp webApp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processBindingsFile(WARFile)");
        }
        InputStream inputStream = null;
        String string = "";
        WARFile wARFile = (WARFile)webModuleRef.getModuleFile();
        String string2 = wARFile.getName();
        try {
            Object object;
            String string3 = webModuleRef.getModule().getAltDD();
            boolean bl = string3 != null && string3.trim().length() > 0;
            WebAppBinding webAppBinding = webModuleRef.getWebAppBinding();
            if (webAppBinding != null) {
                this.ivDisplayName = this.getWebAppDisplayName(webApp);
                string = bl ? "ALT-INF/" + string2 + "/" + BINDINGS_FILE : "WEB-INF/ibm-web-bnd.xmi or ibm-web-bnd.xml";
                this.populateMaps(webAppBinding);
            }
            if (!bl) {
                string = "WEB-INF/ibm-web-bnd.xml";
                if (wARFile.containsFile(string)) {
                    inputStream = wARFile.getInputStream(string);
                }
            } else {
                object = (EARFile)webModuleRef.getEarFile();
                if (object.containsFile(string = "IBM-ALT-INF/" + string2 + "/" + NEW_BINDINGS_FILE)) {
                    inputStream = object.getInputStream(string);
                } else {
                    string = "ALT-INF/" + string2 + "/" + NEW_BINDINGS_FILE;
                    if (object.containsFile(string)) {
                        inputStream = object.getInputStream(string);
                    }
                }
            }
            if (inputStream != null) {
                this.populateMaps(inputStream);
                object = inputStream;
                inputStream = null;
                ((InputStream)object).close();
            }
        }
        catch (MetaDataException metaDataException) {
            throw metaDataException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, CLASS_NAME + ".processBindingsFile", "222", this, new Object[]{wARFile, inputStream});
            Tr.error(tc, "UNKNOWN_BINDINGS_FILE_CONFIG_ERROR_CNTR0147E", new Object[]{string, string2});
            MetaDataException metaDataException = new MetaDataException("CNTR0147E: The " + string + " bindings file contained in the " + string2 + " module has a configuration error.", throwable);
            throw metaDataException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processBindingsFile(WARFile)");
        }
    }

    private void populateMaps(InputStream inputStream) throws JAXBException, SAXException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateMaps(InputStream) using JAXB");
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        JAXBContext jAXBContext = JAXBContext.newInstance("com.ibm.ws.web.bnd", classLoader);
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String string = (String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("file.separator", "\n"));
        String string2 = (String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("was.install.root", "\n"));
        string2 = string2 + string + "properties" + string + "schemas";
        Schema schema = schemaFactory.newSchema(new File(string2 + string + "ibm-web-bnd_1_0.xsd"));
        unmarshaller.setSchema(schema);
        JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal(inputStream);
        WebBndType webBndType = (WebBndType)jAXBElement.getValue();
        VirtualHostType virtualHostType = webBndType.getVirtualHost();
        this.ivVirtualHost = virtualHostType.getName();
        List<Object> list = webBndType.getEjbRefOrResourceRefOrResourceEnvRef();
        for (Object object : list) {
            String string3;
            Object object2;
            if (object instanceof EjbRefType) {
                object2 = (EjbRefType)object;
                string3 = this.ivEjbRefMap.put(((EjbRefType)object2).getName(), ((EjbRefType)object2).getBindingName());
                if (string3 != null) {
                    throw new MetaDataException("duplicate binding for EJBRef name = " + ((EjbRefType)object2).getName());
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added EJBRef binding for (" + ((EjbRefType)object2).getName() + "," + ((EjbRefType)object2).getBindingName() + ")");
                continue;
            }
            if (object instanceof ResourceRefType) {
                object2 = (ResourceRefType)object;
                this.ivResourceRefList.add((ResourceRefType)object2);
                string3 = this.ivResourceRefMap.put(((ResourceRefType)object2).getName(), ((ResourceRefType)object2).getBindingName());
                if (string3 != null) {
                    throw new MetaDataException("duplicate binding for ResourceRef name = " + ((ResourceRefType)object2).getName());
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added ResourceRef binding for (" + ((ResourceRefType)object2).getName() + "," + ((ResourceRefType)object2).getBindingName() + ")");
                continue;
            }
            if (object instanceof ResourceEnvRefType) {
                object2 = (ResourceEnvRefType)object;
                string3 = this.ivResourceEnvRefMap.put(((ResourceEnvRefType)object2).getName(), ((ResourceEnvRefType)object2).getBindingName());
                if (string3 != null) {
                    throw new MetaDataException("duplicate binding for ResourceEnvRef name = " + ((ResourceEnvRefType)object2).getName());
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added ResourceEnvRef binding for (" + ((ResourceEnvRefType)object2).getName() + "," + ((ResourceEnvRefType)object2).getBindingName() + ")");
                continue;
            }
            if (!(object instanceof MessageDestinationRefType)) continue;
            object2 = (MessageDestinationRefType)object;
            string3 = this.ivMdRefMap.put(((MessageDestinationRefType)object2).getName(), ((MessageDestinationRefType)object2).getBindingName());
            if (string3 != null) {
                throw new MetaDataException("duplicate binding for MessageDestinationRef name = " + ((MessageDestinationRefType)object2).getName());
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "added MessageDestinationRef binding for (" + ((MessageDestinationRefType)object2).getName() + "," + ((MessageDestinationRefType)object2).getBindingName() + ")");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateMaps(InputStream)");
        }
    }

    private void populateMaps(WebAppBinding webAppBinding) {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateMaps(WebAppBinding) using WCCM");
        }
        this.ivVirtualHost = webAppBinding.getVirtualHostName();
        EList eList = webAppBinding.getEjbRefBindings();
        if (eList != null) {
            object7 = eList.iterator();
            while (object7.hasNext()) {
                object6 = (EjbRefBinding)object7.next();
                object5 = object6.getJndiName();
                object4 = object6.getBindingEjbRef();
                Object object8 = object3 = object4 != null ? object4.getName() : null;
                if (object3 == null) {
                    Tr.warning(tc, "MISSING_EJBREF_BINDING_CNTR0063W", this.ivDisplayName + " : ejbRefBindings jndiName=\"" + (String)object5 + "\"");
                    continue;
                }
                object2 = this.ivEjbRefMap.put((String)object3, (String)object5);
                if (object2 != null) {
                    throw new MetaDataException("duplicate binding for EJBRef name = " + (String)object3);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added EJBRef binding for (" + (String)object3 + "," + (String)object5 + ")");
            }
        }
        if ((object7 = webAppBinding.getResRefBindings()) != null) {
            object6 = object7.iterator();
            while (object6.hasNext()) {
                object5 = (ResourceRefBinding)object6.next();
                object4 = object5.getJndiName();
                object3 = object5.getBindingResourceRef();
                Object object9 = object2 = object3 != null ? object3.getName() : null;
                if (object2 == null) {
                    Tr.warning(tc, "MISSING_RESREF_BINDING_CNTR0076W", this.ivDisplayName + " : resRefBindings jndiName=\"" + (String)object4 + "\"");
                    continue;
                }
                string = this.ivResourceRefMap.put((String)object2, (String)object4);
                if (string != null) {
                    throw new MetaDataException("duplicate binding for ResourceRef name = " + (String)object2);
                }
                object = this.createResourceRefType((ResourceRefBinding)object5);
                this.ivResourceRefList.add((ResourceRefType)object);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added ResourceRef binding for (" + (String)object2 + "," + (String)object4 + ")");
            }
        }
        if ((object6 = webAppBinding.getResourceEnvRefBindings()) != null) {
            object5 = object6.iterator();
            while (object5.hasNext()) {
                object4 = (ResourceEnvRefBinding)object5.next();
                object3 = object4.getJndiName();
                object2 = object4.getBindingResourceEnvRef();
                String string2 = string = object2 != null ? object2.getName() : null;
                if (string == null) {
                    Tr.warning(tc, "MISSING_RESENVREF_BINDING_CNTR0077W", this.ivDisplayName + " : resourceEnvRefBindings jndiName=\"" + (String)object3 + "\"");
                    continue;
                }
                object = this.ivResourceEnvRefMap.put(string, (String)object3);
                if (object != null) {
                    throw new MetaDataException("duplicate binding for ResourceEnvRef name = " + string);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added ResourceEnvRef binding for (" + string + "," + (String)object3 + ")");
            }
        }
        if ((object5 = webAppBinding.getMessageDestinationRefBindings()) != null) {
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = (MessageDestinationRefBinding)object4.next();
                object2 = object3.getBindingMessageDestinationRef();
                string = object2 != null ? object2.getName() : null;
                object = object3.getJndiName();
                if (string == null) {
                    Tr.warning(tc, "MISSING_MSGDESTREF_BINDING_CNTR0091W", this.ivDisplayName + " : messageDestinationRefBindings jndiName=\"" + (String)object + "\"");
                    continue;
                }
                String string3 = this.ivMdRefMap.put(string, (String)object);
                if (string3 != null) {
                    throw new MetaDataException("duplicate binding for MessageDestinationRef() name = " + string);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added MessageDestinationRef binding for (" + string + "," + (String)object + ")");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateMaps(WebAppBinding)");
        }
    }

    private ResourceRefType createResourceRefType(ResourceRefBinding resourceRefBinding) {
        Object object;
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceRefType for JNDI name = " + resourceRefBinding.getJndiName());
        }
        ResourceRefType resourceRefType = this.ivJaxbFactory.createResourceRefType();
        ResourceRef resourceRef = resourceRefBinding.getBindingResourceRef();
        if (resourceRef != null) {
            resourceRefType.setName(resourceRef.getName());
        }
        resourceRefType.setBindingName(resourceRefBinding.getJndiName());
        AbstractAuthData abstractAuthData = resourceRefBinding.getDefaultAuth();
        if (abstractAuthData != null) {
            object2 = new ResourceRefType.DefaultAuth();
            object = (BasicAuthData)abstractAuthData;
            ((ResourceRefType.DefaultAuth)object2).setUserid(object.getUserId());
            ((ResourceRefType.DefaultAuth)object2).setPassword(object.getPassword());
            resourceRefType.setDefaultAuth((ResourceRefType.DefaultAuth)object2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.debug(tc, "ResourceRefType default authenication type = " + resourceRefType.getDefaultAuth());
            }
        }
        if ((object2 = resourceRefBinding.getLoginConfigurationName()) != null) {
            object = null;
            CustomLoginConfigurationType customLoginConfigurationType = this.ivJaxbFactory.createCustomLoginConfigurationType();
            customLoginConfigurationType.setName((String)object2);
            List<PropertyType> list = customLoginConfigurationType.getProperty();
            EList eList = resourceRefBinding.getProperties();
            for (Property property : eList) {
                PropertyType propertyType = this.ivJaxbFactory.createPropertyType();
                String string = property.getName();
                String string2 = property.getValue();
                propertyType.setName(string);
                propertyType.setValue(string2);
                list.add(propertyType);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "ResourceRefType CustomLoginConfiguration property name = " + string + ", property value = " + string2);
                }
                if (!string.equals("com.ibm.mapping.authDataAlias")) continue;
                object = string2;
            }
            resourceRefType.setCustomLoginConfiguration(customLoginConfigurationType);
            if (object != null) {
                AuthenticationAliasType authenticationAliasType = this.ivJaxbFactory.createAuthenticationAliasType();
                authenticationAliasType.setName((String)object);
                resourceRefType.setAuthenticationAlias(authenticationAliasType);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "ResourceRefType authenication alias = " + (String)object);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceRefType");
        }
        return resourceRefType;
    }

    private ResourceRefBinding createResourceRefBinding(ResourceRefType resourceRefType) {
        Object object;
        CommonFactory commonFactory = CommonFactory.eINSTANCE;
        CommonbndFactory commonbndFactory = CommonbndFactory.eINSTANCE;
        ResourceRefBindingImpl resourceRefBindingImpl = (ResourceRefBindingImpl)commonbndFactory.createResourceRefBinding();
        ResourceRef resourceRef = commonFactory.createResourceRef();
        resourceRef.setName(resourceRefType.getName());
        resourceRefBindingImpl.setBindingResourceRef(resourceRef);
        resourceRefBindingImpl.setJndiName(resourceRefType.getBindingName());
        ResourceRefType.DefaultAuth defaultAuth = resourceRefType.getDefaultAuth();
        if (defaultAuth != null) {
            object = commonbndFactory.createBasicAuthData();
            object.setUserId(defaultAuth.getUserid());
            object.setPassword(defaultAuth.getPassword());
            resourceRefBindingImpl.setDefaultAuth((AbstractAuthData)object);
        }
        if ((object = resourceRefType.getCustomLoginConfiguration()) != null) {
            resourceRefBindingImpl.setLoginConfigurationName(((CustomLoginConfigurationType)object).getName());
            EList eList = resourceRefBindingImpl.getProperties();
            List<PropertyType> list = ((CustomLoginConfigurationType)object).getProperty();
            for (PropertyType propertyType : list) {
                Property property = commonbndFactory.createProperty();
                String string = propertyType.getName();
                String string2 = propertyType.getValue();
                property.setName(string);
                property.setValue(string2);
                eList.add(property);
            }
        }
        return resourceRefBindingImpl;
    }

    private String getWebAppDisplayName(WebApp webApp) {
        String string;
        if (webApp == null) {
            string = "Unknown";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "WCCM WebApp is null, using \"Unknown\" as the display name");
            }
        } else if (webApp.eIsProxy()) {
            string = ((EObjectImpl)webApp).eProxyURI().toString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "WCCM WebAppBinding did not resolve to a WCCM WebApp, using WCCM eProxyURI for the WebApp as the display name");
            }
        } else {
            string = webApp.getDisplayName();
            if (string == null || string.equals("")) {
                string = "Unknown";
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WCCM WebApp display name is null, using \"Unknown\" as the display name");
                }
            }
        }
        return string;
    }
}

