/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.annotations;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.ArrayList;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSignatureParser {
    private static final TraceComponent tc = Tr.register(WSSignatureParser.class, "MetaData", "com.ibm.ws.metadata.metadata");
    private String fullSignature;
    private ArrayList<String> parsedSignature;

    public WSSignatureParser(String string) {
        this.fullSignature = string;
        this.parsedSignature = new ArrayList();
    }

    public String[] parseSignature() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSignature");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing signature: " + this.fullSignature);
        }
        this.removeParentheses();
        Stack<String> stack = this.buildStack();
        this.popStack(stack);
        if (tc.isDebugEnabled()) {
            String[] stringArray = this.formatSignatureList();
            if (stringArray != null) {
                for (String string : stringArray) {
                    Tr.debug(tc, "Parsed method signature member: " + string);
                }
            } else {
                Tr.debug(tc, "The parsed method signature list was null");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSignature");
        }
        return this.formatSignatureList();
    }

    private Stack<String> buildStack() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildStack");
        }
        Stack<String> stack = new Stack<String>();
        char[] cArray = this.fullSignature.toCharArray();
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = cArray.length - 1; i >= 0; --i) {
            String string = String.valueOf(cArray[i]);
            if (this.isSpecialChar(string) || this.isPrimitiveType(string, cArray, i - 1)) {
                if (stringBuffer != null && !stringBuffer.toString().equals("")) {
                    stringBuffer = stringBuffer.reverse();
                    stack.push(stringBuffer.toString());
                    stringBuffer = new StringBuffer("");
                }
                stack.push(string);
            } else if (this.isClosedBracket(string)) {
                int n = 1;
                int n2 = 0;
                stringBuffer.append(string);
                while (n != n2 && i > 0) {
                    String string2;
                    if (this.isOpenBracket(string2 = String.valueOf(cArray[--i]))) {
                        ++n2;
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(string2);
                }
            } else {
                stringBuffer = stringBuffer.append(cArray[i]);
            }
            if (i != 0 || stringBuffer == null || stringBuffer.toString().equals("")) continue;
            stringBuffer = stringBuffer.reverse();
            stack.push(stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildStack");
        }
        return stack;
    }

    private boolean isClosedBracket(String string) {
        return string.equals(">");
    }

    private boolean isOpenBracket(String string) {
        return string.equals("<");
    }

    private boolean isSpecialChar(String string) {
        return string.equals(";") || string.equals("[");
    }

    private boolean isPrimitiveType(String string, char[] cArray, int n) {
        if (this.matchesPrimitive(string)) {
            if (n == 0) {
                return true;
            }
            String string2 = String.valueOf(cArray[n]);
            if (this.matchesPrimitive(string2)) {
                return this.isPrimitiveType(string2, cArray, n - 1);
            }
            return string2.equals(";") || string2.equals("(") || string2.equals("[");
        }
        return false;
    }

    private boolean matchesPrimitive(String string) {
        return string.equals("Z") || string.equals("B") || string.equals("C") || string.equals("S") || string.equals("I") || string.equals("J") || string.equals("F") || string.equals("D");
    }

    private void popStack(Stack<String> stack) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "popStack");
        }
        int n = 0;
        while (!stack.isEmpty()) {
            String string = stack.pop();
            if (!(string.equals(";") || string.equals("<") || string.equals(")") || string.equals("[") || string.equals("("))) {
                this.parsedSignature.add(string);
            } else if (string.equals("<")) {
                this.handleGenericGrouping(stack, string);
            } else if (string.equals("[")) {
                this.handleArray(stack, string);
            }
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "popStack");
        }
    }

    private void handleGenericGrouping(Stack<String> stack, String string) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleGenericGrouping");
        }
        if ((n = this.parsedSignature.size() - 1) > -1) {
            String string2 = this.parsedSignature.get(this.parsedSignature.size() - 1);
            this.parsedSignature.remove(this.parsedSignature.size() - 1);
            string2 = string2 + string;
            int n2 = 1;
            int n3 = 0;
            while (n2 != n3 && !stack.isEmpty()) {
                String string3 = stack.pop();
                if (string3.equals("<")) {
                    ++n2;
                } else if (string3.equals(">")) {
                    ++n3;
                }
                string2 = string2 + string3;
            }
            this.parsedSignature.add(string2);
        } else {
            int n4 = 1;
            int n5 = 0;
            while (n4 != n5 && !stack.isEmpty()) {
                String string4 = stack.pop();
                if (string4.equals("<")) {
                    ++n4;
                } else if (string4.equals(">")) {
                    ++n5;
                }
                string = string + string4;
            }
            this.parsedSignature.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleGenericGrouping");
        }
    }

    private void handleArray(Stack<String> stack, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleArray");
        }
        if (!stack.isEmpty()) {
            String string2 = "";
            while (!stack.isEmpty() && string.equals("[")) {
                string2 = string2 + string;
                string = stack.pop();
            }
            string2 = string2 + string;
            this.parsedSignature.add(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleArray");
        }
    }

    private String[] formatSignatureList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatSignatureList");
        }
        String[] stringArray = new String[this.parsedSignature.size()];
        for (int i = 0; i < this.parsedSignature.size(); ++i) {
            String string = this.parsedSignature.get(i);
            stringArray[i] = string = this.javifyParameterPart(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatSignatureList");
        }
        return stringArray;
    }

    private String javifyParameterPart(String string) {
        if (string.indexOf("/") != -1) {
            string = string.replaceAll("/", ".");
        }
        if (string.startsWith("L")) {
            string = string.replaceFirst("L", "");
        }
        if (string.indexOf(40) == 0 && string.length() > 0) {
            string = this.javifyParameterPart(string.substring(1, string.length()));
        }
        if (string.indexOf(";L") != -1) {
            string = string.replaceAll(";L", ";");
        }
        if (string.indexOf("<L") != -1) {
            string = string.replaceAll("<L", "<");
        }
        if (string.indexOf("[L") != -1) {
            string = string.replaceAll("\\[L", "\\[");
        }
        if (string.indexOf(";") != -1) {
            string = string.replaceAll(";", "");
        }
        return string.trim();
    }

    private void removeParentheses() {
        int n = this.fullSignature.indexOf(40);
        if (n > 0) {
            this.fullSignature = this.fullSignature.substring(n + 1, this.fullSignature.length());
        }
        if (this.fullSignature.indexOf(")") != -1) {
            this.fullSignature = this.fullSignature.substring(0, this.fullSignature.lastIndexOf(")") - 1).trim();
        }
    }
}

