/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.annotations;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ArchiveMemberFileLocator;
import com.ibm.ws.metadata.ConfigReader;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.metadata.MetaDataSources;
import com.ibm.ws.metadata.ModuleDataObject;
import com.ibm.ws.metadata.annotations.ASMClassAdapter;
import com.ibm.ws.metadata.annotations.AdapterAndInstance;
import com.ibm.ws.metadata.annotations.AnnotationException;
import com.ibm.ws.metadata.annotations.WSAnnotationAdapter;
import com.ibm.ws.metadata.annotations.WSClassAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfigReader
implements ConfigReader {
    private static final String CLASS_NAME = AnnotationConfigReader.class.getName();
    private static TraceComponent tc = Tr.register(CLASS_NAME, "MetaData", "com.ibm.ws.metadata.metadata");
    protected static final String[] sv_Annotations = new String[]{"Ljavax/ejb/ActivationConfigProperty;", "Ljavax/ejb/Local;", "Ljavax/ejb/LocalHome;", "Ljavax/ejb/MessageDriven;", "Ljavax/ejb/Remote;", "Ljavax/ejb/RemoteHome;", "Ljavax/ejb/Stateless;", "Ljavax/ejb/Stateful;", "Ljavax/jws/HandlerChain;", "Ljavax/jws/Oneway;", "Ljavax/jws/soap/SOAPBinding;", "Ljavax/jws/soap/SOAPMessageHandler;", "Ljavax/jws/WebMethod;", "Ljavax/jws/WebParam;", "Ljavax/jws/WebResult;", "Ljavax/jws/WebService;", "Ljavax/xml/ws/WebServiceProvider;", "Ljavax/xml/ws/WebServiceClient;", "Ljavax/xml/ws/WebEndpoint;", "Ljavax/xml/ws/ServiceMode;", "Ljavax/xml/ws/BindingType;", "Ljavax/xml/ws/ResponseWrapper;", "Ljavax/xml/ws/RequestWrapper;", "Ljavax/xml/ws/WebFault;", "Ljavax/xml/ws/WebServiceRef;", "Ljavax/xml/ws/WebServiceRefs;", "Ljavax/annotation/Resource;", "Ljavax/annotation/Resources;", "Ljavax/xml/bind/annotation/XmlList;"};
    protected static final String[] sv_AdapterClassName = new String[]{"com.ibm.ws.metadata.annotations.ActivationConfigPropertyAdapter", "com.ibm.ws.metadata.annotations.LocalAdapter", "com.ibm.ws.metadata.annotations.LocalHomeAdapter", "com.ibm.ws.metadata.annotations.MessageDrivenAdapter", "com.ibm.ws.metadata.annotations.RemoteAdapter", "com.ibm.ws.metadata.annotations.RemoteHomeAdapter", "com.ibm.ws.metadata.annotations.StatelessAdapter", "com.ibm.ws.metadata.annotations.StatefulAdapter", "com.ibm.ws.metadata.annotations.HandlerChainAdapter", "com.ibm.ws.metadata.annotations.OneWayAdapter", "com.ibm.ws.metadata.annotations.SOAPBindingAdapter", "com.ibm.ws.metadata.annotations.SOAPMessageHandlerAdapter", "com.ibm.ws.metadata.annotations.WebMethodAdapter", "com.ibm.ws.metadata.annotations.WebParamAdapter", "com.ibm.ws.metadata.annotations.WebResultAdapter", "com.ibm.ws.metadata.annotations.WebServiceAdapter", "com.ibm.ws.metadata.annotations.WebServiceProviderAdapter", "com.ibm.ws.metadata.annotations.WebServiceClientAdapter", "com.ibm.ws.metadata.annotations.WebEndpointAdapter", "com.ibm.ws.metadata.annotations.ServiceModeAdapter", "com.ibm.ws.metadata.annotations.BindingTypeAdapter", "com.ibm.ws.metadata.annotations.ResponseWrapperAdapter", "com.ibm.ws.metadata.annotations.RequestWrapperAdapter", "com.ibm.ws.metadata.annotations.WebFaultAdapter", "com.ibm.ws.metadata.annotations.WebServiceRefAdapter", "com.ibm.ws.metadata.annotations.WebServiceRefsAdapter", "com.ibm.ws.metadata.annotations.ResourceAdapter", "com.ibm.ws.metadata.annotations.ResourcesAdapter", "com.ibm.ws.metadata.annotations.XmlListAdapter"};
    private HashMap<String, AdapterAndInstance> sv_AnnotationMap;
    private String classAdapterName;

    public AnnotationConfigReader() {
        this.classAdapterName = "ASMClassAdapter";
        this.sv_AnnotationMap = new HashMap();
        for (int i = 0; i < sv_Annotations.length; ++i) {
            this.sv_AnnotationMap.put(sv_Annotations[i], new AdapterAndInstance(sv_AdapterClassName[i]));
        }
    }

    public AnnotationConfigReader(String string) {
        this.classAdapterName = string;
        this.sv_AnnotationMap = new HashMap();
        for (int i = 0; i < sv_Annotations.length; ++i) {
            this.sv_AnnotationMap.put(sv_Annotations[i], new AdapterAndInstance(sv_AdapterClassName[i]));
        }
    }

    @Override
    public void populateModuleData(ModuleDataObject moduleDataObject, MetaDataSources metaDataSources) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateModuleData(" + moduleDataObject.iv_Key + "," + metaDataSources + ")");
        }
        JarFile jarFile = (JarFile)metaDataSources.iv_Sources[MetaDataSources.sv_JarFileIndex];
        File file = (File)metaDataSources.iv_Sources[MetaDataSources.sv_DirectoryIndex];
        if (jarFile != null) {
            this.getAnnotationData(moduleDataObject, jarFile);
        } else if (file != null) {
            this.getAnnotationData(moduleDataObject, file);
        } else {
            Iterator iterator = (Iterator)metaDataSources.iv_Sources[MetaDataSources.sv_FileLocatorIndex];
            this.getAnnotationData(moduleDataObject, iterator);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateModuleData", moduleDataObject);
        }
    }

    private void getAnnotationData(ModuleDataObject moduleDataObject, JarFile jarFile) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationData(" + moduleDataObject.iv_Key + "," + jarFile + ")");
        }
        String string = null;
        try {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                string = jarEntry.getName();
                int n = string.length();
                if (n < 6 || !string.substring(n - 6).equals(".class")) continue;
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                ClassReader classReader = new ClassReader(inputStream);
                ClassWriter classWriter = new ClassWriter(true);
                ASMClassAdapter aSMClassAdapter = this.getClassAdapter(classWriter, this, moduleDataObject);
                classReader.accept((ClassVisitor)aSMClassAdapter, false);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, CLASS_NAME + "getAnnotationData", "309", this);
            AnnotationException annotationException = new AnnotationException("Unable to communicate with file " + string + ":  ", iOException);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", annotationException);
            throw annotationException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, CLASS_NAME + "getAnnotationData", "317", this);
            AnnotationException annotationException = new AnnotationException("Annotation processing failed: " + string + ":  ", exception);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", annotationException);
            throw annotationException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnnotationData");
        }
    }

    private void getAnnotationData(ModuleDataObject moduleDataObject, File file) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationData(" + moduleDataObject.iv_Key + "," + file.getName());
        }
        try {
            ArrayList<FileInputStream> arrayList = new ArrayList<FileInputStream>();
            this.getStreamsFromDirectory(file, arrayList);
            if (!arrayList.isEmpty()) {
                FileInputStream[] fileInputStreamArray = arrayList.toArray(new FileInputStream[0]);
                for (int i = 0; i < fileInputStreamArray.length; ++i) {
                    ClassReader classReader = new ClassReader((InputStream)fileInputStreamArray[i]);
                    ClassWriter classWriter = new ClassWriter(true);
                    ASMClassAdapter aSMClassAdapter = this.getClassAdapter(classWriter, this, moduleDataObject);
                    classReader.accept((ClassVisitor)aSMClassAdapter, false);
                }
            } else {
                Tr.debug(tc, file.getName() + " contains no class files.");
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, CLASS_NAME + "getAnnotationData", "368", this);
            AnnotationException annotationException = new AnnotationException("Annotation processing failed:  ", iOException);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", annotationException);
            throw annotationException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, CLASS_NAME + "getAnnotationData", "376", this);
            AnnotationException annotationException = new AnnotationException("Annotation processing failed:  ", exception);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", annotationException);
            throw annotationException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnnotationData");
        }
    }

    private void getAnnotationData(ModuleDataObject moduleDataObject, Iterator<FileLocator> iterator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationData(" + moduleDataObject.iv_Key + "," + iterator + ")");
        }
        HashMap<Object, ArrayList<ArchiveMemberFileLocator>> hashMap = new HashMap<Object, ArrayList<ArchiveMemberFileLocator>>();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            Object object;
            FileLocator fileLocator = iterator.next();
            String string = fileLocator.getName();
            int n = string.length();
            if (n < 6 || !string.substring(n - 6).equals(".class")) continue;
            boolean bl = false;
            if (fileLocator instanceof ArchiveMemberFileLocator && !hashSet.contains(object = ((ArchiveMemberFileLocator)fileLocator).getArchiveRelativeName())) {
                ArrayList<ArchiveMemberFileLocator> arrayList = (ArrayList<ArchiveMemberFileLocator>)hashMap.get(object);
                if (arrayList != null) {
                    arrayList.add((ArchiveMemberFileLocator)fileLocator);
                    bl = true;
                } else {
                    InputStream inputStream = ((ArchiveMemberFileLocator)fileLocator).getArchiveInputStream();
                    if (inputStream == null) {
                        hashSet.add(object);
                        Tr.debug(tc, "Process archive member using normal algorithm:" + (String)object);
                    } else {
                        Tr.debug(tc, "Process archive member using optimized algorithm:" + (String)object);
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        arrayList = new ArrayList<ArchiveMemberFileLocator>();
                        hashMap.put(object, arrayList);
                        arrayList.add((ArchiveMemberFileLocator)fileLocator);
                        bl = true;
                    }
                }
            }
            if (bl || (object = fileLocator.getInputStream()) == null) continue;
            this.getAnnotationData(moduleDataObject, string, (InputStream)object);
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
        }
        for (String string : hashMap.keySet()) {
            this.getAnnotationDataForZippedArchive(moduleDataObject, (List)hashMap.get(string));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnnotationData");
        }
    }

    private void getAnnotationDataForZippedArchive(ModuleDataObject moduleDataObject, List<ArchiveMemberFileLocator> list) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationDataForZippedArchive(" + moduleDataObject.iv_Key + ",number of locators=" + list.size() + ")");
        }
        ArchiveMemberFileLocator archiveMemberFileLocator = list.get(0);
        Tr.debug(tc, "The name of the archive is: " + archiveMemberFileLocator.getArchiveRelativeName());
        InputStream inputStream = archiveMemberFileLocator.getArchiveInputStream();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        HashSet<String> hashSet = new HashSet<String>();
        for (ArchiveMemberFileLocator object2 : list) {
            hashSet.add(object2.getRelativeName());
            Tr.debug(tc, "We need annotation processing for:" + object2.getRelativeName());
        }
        String string = null;
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string2 = zipEntry.getName();
                Tr.debug(tc, "Reading ZipEntry:" + string2);
                if (hashSet.contains(string2)) {
                    Tr.debug(tc, "Process annotations for:" + string2);
                    hashSet.remove(string2);
                    ZipInputStream zipInputStream2 = zipInputStream;
                    if (zipInputStream2 != null) {
                        this.getAnnotationData(moduleDataObject, string2, zipInputStream2);
                        zipInputStream.closeEntry();
                        zipEntry = null;
                    }
                }
                if (hashSet.isEmpty()) continue;
                zipEntry = zipInputStream.getNextEntry();
            }
            if (!hashSet.isEmpty()) {
                Tr.debug(tc, "There are unprocessed classes:" + hashSet);
                String string3 = (String)hashSet.iterator().next();
                throw new RuntimeException("Unexpected exception: Annotation processing is skipped for the following classes: " + hashSet);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, CLASS_NAME + "getAnnotationData", "434", this);
            AnnotationException annotationException = new AnnotationException("Unable to communicate with file for class:  " + string, iOException);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", annotationException);
            throw annotationException;
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, CLASS_NAME + "getAnnotationData", "593", this);
                AnnotationException annotationException = new AnnotationException("Unable to close the zip file for class:  " + archiveMemberFileLocator.getArchiveRelativeName(), iOException);
                Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", annotationException);
                throw annotationException;
            }
        }
    }

    private void getAnnotationData(ModuleDataObject moduleDataObject, String string, InputStream inputStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationData(" + moduleDataObject.iv_Key + "," + string + ", InputStream)");
        }
        try {
            ClassReader classReader = new ClassReader(inputStream);
            ClassWriter classWriter = new ClassWriter(true);
            ASMClassAdapter aSMClassAdapter = this.getClassAdapter(classWriter, this, moduleDataObject);
            classReader.accept((ClassVisitor)aSMClassAdapter, false);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, CLASS_NAME + "getAnnotationData", "434", this);
            AnnotationException annotationException = new AnnotationException("Unable to communicate with file for class:  " + string, iOException);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", annotationException);
            throw annotationException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, CLASS_NAME + "getAnnotationData", "442", this);
            AnnotationException annotationException = new AnnotationException("Annotation processing failed for class:  " + string, exception);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", annotationException);
            throw annotationException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnnotationData");
        }
    }

    public WSAnnotationAdapter getAnnotationAdapterInstance(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationAdapterInstance(" + string + ")");
        }
        Class<?> clazz = null;
        WSAnnotationAdapter wSAnnotationAdapter = null;
        AdapterAndInstance adapterAndInstance = this.sv_AnnotationMap.get(string);
        if (adapterAndInstance != null) {
            if (adapterAndInstance.iv_AnnotationAdapterClass == null) {
                try {
                    clazz = Class.forName(adapterAndInstance.iv_ClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, CLASS_NAME + "getAnnotationAdapterInstance", "193", this);
                    AnnotationException annotationException = new AnnotationException("No adapter class found for class:  " + adapterAndInstance.iv_ClassName, classNotFoundException);
                    Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", annotationException);
                    throw annotationException;
                }
                try {
                    adapterAndInstance.iv_AnnotationAdapterClass = (WSAnnotationAdapter)clazz.newInstance();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, CLASS_NAME + "getAnnotationAdapterInstance", "220", this);
                    AnnotationException annotationException = new AnnotationException("Unable to instantiate class:  " + clazz.getName(), exception);
                    Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", annotationException);
                    throw annotationException;
                }
            }
            wSAnnotationAdapter = adapterAndInstance.iv_AnnotationAdapterClass;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnnotationAdapterInstance", wSAnnotationAdapter);
        }
        return wSAnnotationAdapter;
    }

    private ASMClassAdapter getClassAdapter(ClassWriter classWriter, AnnotationConfigReader annotationConfigReader, ModuleDataObject moduleDataObject) {
        if (this.classAdapterName.equals("ASMClassAdapter")) {
            return new ASMClassAdapter((ClassVisitor)classWriter, this, moduleDataObject);
        }
        if (this.classAdapterName.equals("WSClassAdapter")) {
            return new WSClassAdapter((ClassVisitor)classWriter, this, moduleDataObject);
        }
        return null;
    }

    private void getStreamsFromDirectory(File file, ArrayList<FileInputStream> arrayList) {
        File[] fileArray = file.listFiles();
        String string = null;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.getStreamsFromDirectory(fileArray[i], arrayList);
                continue;
            }
            string = fileArray[i].getName();
            if (!string.endsWith(".class")) continue;
            try {
                arrayList.add(new FileInputStream(fileArray[i]));
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                FFDCFilter.processException((Throwable)fileNotFoundException, CLASS_NAME + "getStreamsFromDirectory", "544", this);
                AnnotationException annotationException = new AnnotationException("Unable to create FileInputStream for class:  " + fileArray[i].getName(), fileNotFoundException);
                Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", annotationException);
                throw annotationException;
            }
        }
    }
}

