/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.Serializable;

public class TaskCommandSession
implements Serializable {
    private static TraceComponent tc = Tr.register(TaskCommandSession.class, "TaskCommandSession", "com.ibm.ws.management.cmdframework.impl");
    private static final long serialVersionUID = -8640690019170184381L;
    private long sessionId;
    private long lastActiveTime;
    static final long TIMEOUT = 600000L;

    public TaskCommandSession() {
        this.lastActiveTime = this.sessionId = System.currentTimeMillis();
    }

    public long getSessionId() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "session id", new Long(this.sessionId));
        }
        return this.sessionId;
    }

    public void refreshActiveTimeStamp() {
        this.lastActiveTime = System.currentTimeMillis();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TaskCommandSession)) {
            return false;
        }
        return ((TaskCommandSession)object).sessionId == this.sessionId;
    }

    public int hashCode() {
        return new Long(this.sessionId).hashCode();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.lastActiveTime + 600000L;
    }

    public String toString() {
        return "sessionId:" + this.sessionId + ", lastActiveTime:" + this.lastActiveTime;
    }
}

