/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public abstract class CommandMgrImpl
extends CommandMgr {
    private static TraceComponent tc = Tr.register(CommandMgrImpl.class, "CommandMgrImpl", "com.ibm.ws.management.resources.cmdframework");
    protected CommandProviderHelper helper = null;

    public Collection listCommandGroups() throws ConnectorException, CommandException {
        return CommandMetadataMgr.getInstance().listCommandGroups();
    }

    public Collection listCommands(String string) throws ConnectorException, CommandException {
        return CommandMetadataMgr.getInstance().listCommands(string);
    }

    public Collection listCommands() throws ConnectorException, CommandException {
        return CommandMetadataMgr.getInstance().listCommands();
    }

    public Collection listAllCommands() throws ConnectorException, CommandException {
        return CommandMetadataMgr.getInstance().listAllCommands();
    }

    public CommandMetadata getCommandMetadata(String string) throws CommandNotFoundException, ConnectorException, CommandException {
        return CommandMetadataMgr.getInstance().getCommandMetadata(string);
    }

    public Collection getAllCommandMetadata() throws ConnectorException, CommandException {
        Collection collection = CommandMetadataMgr.getInstance().listAllCommands();
        Iterator iterator = collection.iterator();
        ArrayList<CommandMetadata> arrayList = new ArrayList<CommandMetadata>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            CommandMetadata commandMetadata = CommandMgr.getCommandMgr().getCommandMetadata(string);
            arrayList.add(commandMetadata);
        }
        return arrayList;
    }

    public CommandGroupMetadata getCommandGroupMetadata(String string) throws CommandNotFoundException, ConnectorException, CommandException {
        return CommandMetadataMgr.getInstance().getCommandGroupMetadata(string);
    }

    public Collection getAllCommandGroupMetadata() throws ConnectorException, CommandException {
        Collection collection = CommandMetadataMgr.getInstance().listCommandGroups();
        Iterator iterator = collection.iterator();
        ArrayList<CommandGroupMetadata> arrayList = new ArrayList<CommandGroupMetadata>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            CommandGroupMetadata commandGroupMetadata = CommandMgr.getCommandMgr().getCommandGroupMetadata(string);
            arrayList.add(commandGroupMetadata);
        }
        return arrayList;
    }

    public AdminCommand createCommand(String string) throws ConnectorException, CommandException {
        CommandMetadata commandMetadata = (CommandMetadata)CommandUtility.clone(CommandMetadataMgr.getInstance().getCommandMetadata(string));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createCommand(" + string + ") uses cmd metadata: @" + Integer.toHexString(commandMetadata.hashCode()), commandMetadata);
        }
        return CommandMetadataMgr.getInstance().getCommandProvider(string).createCommand(commandMetadata);
    }

    public AdminCommand loadCommand(InputStream inputStream) throws CommandLoadException, ConnectorException, CommandException {
        try {
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            XMIResourceImpl xMIResourceImpl = new XMIResourceImpl();
            xMIResourceImpl.setURI(URI.createURI("Command.xmi"));
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put("DECLARE_XML", Boolean.FALSE);
            xMIResourceImpl.load(inputStream, hashMap);
            EList eList = xMIResourceImpl.getContents();
            CommandData commandData = (CommandData)eList.get(0);
            String string = commandData.getName();
            return CommandMetadataMgr.getInstance().getCommandProvider(string).loadCommand(commandData);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new CommandLoadException(iOException);
        }
        catch (CommandNotFoundException commandNotFoundException) {
            commandNotFoundException.printStackTrace();
            throw new CommandLoadException(commandNotFoundException);
        }
    }
}

