/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.cmdframework.CommandHistory;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CmdNotificationHandler;
import com.ibm.websphere.management.cmdframework.provider.CommandNotification;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import com.ibm.ws.management.cmdframework.impl.EObjectSerializer;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSession;
import java.util.HashMap;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;

public class ClientAdminCommand
extends AbstractAdminCommand {
    private static TraceComponent tc = Tr.register(ClientAdminCommand.class, "ClientAdminCommand", "com.ibm.ws.management.cmdframework.impl");
    private CmdNotificationHandler cnh;
    private AdminClient adminClient = CommandMgr.getCommandMgr().getCommandProviderHelper().getAdminClient();
    private HashMap downloadFiles = null;

    public ClientAdminCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    public void execute() {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute");
            }
            try {
                this.validate();
                EObjectSerializer eObjectSerializer = new EObjectSerializer();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CommandData sending is " + this.getCommandData());
                }
                CommandUtility.handleUploadFileParamsBeforeExecute(this, this.adminClient);
                this.downloadFiles = CommandUtility.handleDownloadFileParamsBeforeExecute(this, this.adminClient);
                eObjectSerializer.setEObjectValue(this.getCommandData());
                CommandResult commandResult = this.asyncCmdSession == null ? (CommandResult)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "execute", new Object[]{eObjectSerializer}, new String[]{"com.ibm.ws.management.cmdframework.impl.EObjectSerializer"}) : (CommandResult)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "executeAsync", new Object[]{this.asyncCmdSession, eObjectSerializer}, new String[]{"com.ibm.ws.management.cmdframework.impl.TaskCommandSession", "com.ibm.ws.management.cmdframework.impl.EObjectSerializer"});
                if (commandResult != null && commandResult.isSuccessful() && !this.isAsyncCommand()) {
                    CommandUtility.downloadFiles(this.adminClient, this.downloadFiles);
                }
                this.setCommandResult(commandResult);
            }
            catch (Exception exception) {
                CommandResultImpl commandResultImpl = new CommandResultImpl();
                commandResultImpl.setException(exception);
                this.setCommandResult(commandResultImpl);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "caught exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    public void execute(CommandHistory commandHistory) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", commandHistory);
        }
        commandHistory.add(this.getCommandData());
        this.execute();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    public TaskCommandSession getCommandSession() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCommandSession");
            }
            if (this.asyncCmdSession == null) {
                try {
                    this.asyncCmdSession = (TaskCommandSession)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getCmdSession", new Object[]{this.getName()}, new String[]{"java.lang.String"});
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "caught exception", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandSession", this.asyncCmdSession);
        }
        return this.asyncCmdSession;
    }

    protected void setupListener(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupListener", object);
        }
        try {
            ClientCmdNotificationListener clientCmdNotificationListener = new ClientCmdNotificationListener(this.getCommandSession().getSessionId());
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("CmdNotification");
            this.adminClient.addNotificationListener(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), clientCmdNotificationListener, (NotificationFilter)notificationFilterSupport, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupListener");
        }
    }

    public class ClientCmdNotificationListener
    extends AbstractAdminCommand.CmdNotificationListener {
        public ClientCmdNotificationListener(long l) {
            super(ClientAdminCommand.this);
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ClientCmdNotificationListener");
            }
            this.session = l;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ClientCmdNotificationListener");
            }
        }

        public void removeListener() throws Exception {
            ClientAdminCommand.this.adminClient.removeNotificationListener(CommandUtility.getRemoteCmdMgrMbean(ClientAdminCommand.this.adminClient), this);
        }

        public void handleNotification(Notification notification, Object object) {
            Object object2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{notification, object});
            }
            if ((object2 = notification.getUserData()) instanceof CommandNotification) {
                CommandNotification commandNotification = (CommandNotification)object2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command name is " + commandNotification.getCmdName() + ", Command status is " + commandNotification.getCmdStatus() + ", Command message is " + commandNotification.getMessage() + ", session id is " + commandNotification.getSessionID());
                }
                if (commandNotification.getSessionID() == ClientAdminCommand.this.asyncCmdSession.getSessionId()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command status is " + commandNotification.getCmdStatus());
                    }
                    if (commandNotification.getCmdStatus().equals("Completed")) {
                        block17: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Command completed.  Result is " + commandNotification.getResult().getResult());
                            }
                            this.complete = true;
                            if (commandNotification.getResult().isSuccessful()) {
                                try {
                                    CommandUtility.downloadFiles(ClientAdminCommand.this.adminClient, ClientAdminCommand.this.downloadFiles);
                                }
                                catch (Exception exception) {
                                    if (!(commandNotification.getResult() instanceof CommandResultImpl)) break block17;
                                    ((CommandResultImpl)commandNotification.getResult()).setException(exception);
                                }
                            }
                        }
                        ClientAdminCommand.this.setCommandResult(commandNotification.getResult());
                        try {
                            this.removeListener();
                        }
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "unexpected exception", exception);
                            }
                            FFDCFilter.processException(exception, "com.ibm.websphere.management.cmdframework.CmdNotificationListener", "134");
                        }
                    }
                    ClientAdminCommand.this.cnh.handleCmdNotification(commandNotification);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command notified");
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "received irrelevant event", object2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
        }
    }
}

