/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.async.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.provider.CmdNotificationHandler;
import com.ibm.websphere.management.cmdframework.provider.CommandNotification;
import com.ibm.ws.management.async.client.ADTSemaphore;
import com.ibm.ws.management.async.client.AsyncCommandHandlerIF;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import org.eclipse.emf.common.util.EList;

public class AsyncCommandClient {
    private static TraceComponent tc = Tr.register(AsyncCommandClient.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    public static final String HIDDEN_PROP_PARAM_NAME = "ADTCommandProps";
    public static final String STEP_DISPLAY_FORMAT_KEY = "StepDisplayFormatKey";
    public static final String MULTIPLE_SCOPES_PER_STEP_FORMAT_VALUE = "MultipleScopesPerStepFormatValue";
    public static final String ONE_SCOPE_PER_STEP_FORMAT_VALUE = "OneScopePerStepFormatValue";
    private AsyncCommandHandlerIF _asyncCmdHandler;
    private Session _session;
    private ADTSemaphore _uiSema;
    private ADTSemaphore _opCompleteSema;
    private AsyncCommandHandlerIF _clientNotifHandler;

    public AsyncCommandClient(Session session, AsyncCommandHandlerIF asyncCommandHandlerIF) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AsyncCommandClient", new Object[]{session, asyncCommandHandlerIF});
        }
        this._session = session;
        this._clientNotifHandler = asyncCommandHandlerIF;
        this._uiSema = new ADTSemaphore(session.toString() + ".uiSema");
        this._opCompleteSema = new ADTSemaphore(session.toString() + ".opCompleteSema");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AsyncCommandClient");
        }
    }

    public void execute(AdminCommand adminCommand) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "execute", new Object[]{adminCommand});
            }
            try {
                if (adminCommand instanceof TaskCommand) {
                    if (((TaskCommand)adminCommand).hasPreviousStep()) {
                        ((TaskCommand)adminCommand).previousStep();
                    } else if (((TaskCommand)adminCommand).hasNextStep()) {
                        ((TaskCommand)adminCommand).nextStep();
                    } else {
                        String[] stringArray = ((TaskCommand)adminCommand).listCommandSteps();
                        if (stringArray != null && stringArray.length > 0) {
                            ((TaskCommand)adminCommand).gotoStep(stringArray[0]);
                        }
                    }
                }
                adminCommand.execute();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, stringWriter.toString());
            }
        }
        if (adminCommand.isAsyncCommand()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "waiting");
            }
            this._opCompleteSema.waitForOpEvent("Op execution completed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    public void processCommandParameters(AdminCommand adminCommand) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCommandParameters", new Object[]{adminCommand});
        }
        if (adminCommand.isAsyncCommand() && adminCommand instanceof TaskCommand) {
            CmdNotificationHandlerImpl cmdNotificationHandlerImpl = new CmdNotificationHandlerImpl();
            adminCommand.setCmdHandler(cmdNotificationHandlerImpl);
            ((TaskCommand)adminCommand).processTaskParameters();
            this._checkResult(adminCommand, cmdNotificationHandlerImpl);
            this._uiSema.waitForOpEvent("User input obtained");
            this._checkResult(adminCommand, cmdNotificationHandlerImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processCommandParameters");
        }
    }

    public void setStepDisplayFormat(AdminCommand adminCommand, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStepDisplayFormat", new Object[]{adminCommand, string});
        }
        EList eList = adminCommand.getCommandMetadata().getParameters();
        for (int i = 0; i < eList.size(); ++i) {
            ParameterMetadata parameterMetadata = (ParameterMetadata)eList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processing parameter metadata: " + parameterMetadata);
            }
            if (!HIDDEN_PROP_PARAM_NAME.equals(parameterMetadata.getName())) continue;
            try {
                Hashtable<String, String> hashtable = adminCommand.getParameter(HIDDEN_PROP_PARAM_NAME);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "hidden prop object: " + hashtable);
                }
                if (hashtable == null) {
                    hashtable = new Hashtable<String, String>();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "creating an empty hashtable");
                    }
                }
                if (!(hashtable instanceof Hashtable)) break;
                hashtable.put(STEP_DISPLAY_FORMAT_KEY, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "hidden prop object after setting step display format key: " + hashtable);
                }
                adminCommand.setParameter(HIDDEN_PROP_PARAM_NAME, hashtable);
            }
            catch (InvalidParameterNameException invalidParameterNameException) {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Unexpected InvalidParameterNameException caught: " + invalidParameterNameException.getMessage());
            }
            catch (InvalidParameterValueException invalidParameterValueException) {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Unexpected InvalidParameterValueException caught: " + invalidParameterValueException.getMessage());
            }
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStepDisplayFormat");
        }
    }

    private void _checkResult(AdminCommand adminCommand, CmdNotificationHandlerImpl cmdNotificationHandlerImpl) throws Throwable {
        CommandResult commandResult;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_checkResult", new Object[]{adminCommand, cmdNotificationHandlerImpl});
        }
        if ((commandResult = adminCommand.getCommandResult()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "null result; get result from notification");
            }
            commandResult = cmdNotificationHandlerImpl.getCommandResult();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "command result: " + commandResult);
        }
        if (commandResult != null && !commandResult.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "command not succesful: " + commandResult.getException());
            }
            Throwable throwable = commandResult.getException();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_checkResult", new Object[]{"not error"});
        }
    }

    class CmdNotificationHandlerImpl
    implements CmdNotificationHandler {
        private String _cmdStatus;
        private CommandResult _cmdResult;

        public synchronized void handleCmdNotification(CommandNotification commandNotification) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleCmdNotification", new Object[]{commandNotification});
            }
            if (commandNotification.getCmdStatus().equals("Completed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "command completed with result: " + commandNotification.getResult().getResult());
                }
                this._cmdStatus = "Completed";
                this._cmdResult = commandNotification.getResult();
                CommandResult commandResult = commandNotification.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "result: " + commandResult);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "result exception: " + commandResult.getException());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "result successful: " + commandResult.isSuccessful());
                }
                AsyncCommandClient.this._opCompleteSema.notifyOfOpEvent("Op execution completed");
                if (!commandResult.isSuccessful()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "result is set to not successful");
                    }
                    AsyncCommandClient.this._uiSema.notifyOfOpEvent("Op execution completed");
                }
                AsyncCommandClient.this._clientNotifHandler.handleNotification(commandNotification);
            }
            if (commandNotification.getCmdStatus().equals("InProgress")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "command in progress");
                }
                this._cmdStatus = "InProgress";
                this._cmdResult = null;
                AsyncCommandClient.this._clientNotifHandler.handleNotification(commandNotification);
            }
            if (commandNotification.getCmdStatus().equals("Interactive")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "command in interactive");
                }
                this._cmdStatus = "Interactive";
                this._cmdResult = null;
                AsyncCommandClient.this._uiSema.notifyOfOpEvent("User input obtained");
            }
        }

        public String getCommandStatus() {
            return this._cmdStatus;
        }

        public CommandResult getCommandResult() {
            return this._cmdResult;
        }
    }
}

