/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.logging.MessageConverter;
import com.ibm.ws.logging.ConvertLogConfig;
import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class ConvertLog {
    private static String svBundle = "com.ibm.ejs.resources.RasMessages";
    private static final int MESSAGE_ID_LENGTH_V5 = 9;
    private static final int MESSAGE_ID_LENGTH_V6 = 10;

    private ConvertLog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        ConvertLogConfig convertLogConfig = new ConvertLogConfig(stringArray);
        boolean bl = convertLogConfig.isValid();
        if (!bl) {
            return;
        }
        InputStreamReader inputStreamReader = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            try {
                inputStreamReader = new InputStreamReader(new FileInputStream(convertLogConfig.iInputFilename));
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = TraceNLS.getFormattedMessage(svBundle, "CONVERTLOG_INPUTFILENOTFOUND", new Object[]{convertLogConfig.iInputFilename}, "TRAS0025E: Unable to load source file " + convertLogConfig.iInputFilename, true);
                System.err.println(string);
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            try {
                outputStreamWriter = new OutputStreamWriter(new FileOutputStream(convertLogConfig.iOutputFilename));
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = TraceNLS.getFormattedMessage(svBundle, "CONVERTLOG_OUTPUTFILENOTFOUND", new Object[]{convertLogConfig.iOutputFilename}, "TRAS0026E: Unable to open destination file " + convertLogConfig.iOutputFilename, true);
                System.err.println(string);
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            char[] cArray = ConvertLog.read(inputStreamReader);
            char[] cArray2 = convertLogConfig.ibConvertWAS5toWAS6 ? ConvertLog.doConversion(cArray, 9, MessageConverter.CONVERSION_TYPE_WASV5_TO_WASV6) : (convertLogConfig.ibConvertWAS6toWAS5 ? ConvertLog.doConversion(cArray, 10, MessageConverter.CONVERSION_TYPE_WASV6_TO_WASV5) : cArray);
            outputStreamWriter.write(cArray2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string = TraceNLS.getFormattedMessage(svBundle, "CONVERTLOG_OUTOFMEMORY", new Object[]{convertLogConfig.iInputFilename}, "TRAS0027E: Insufficient memory to process source file " + convertLogConfig.iInputFilename, true);
            System.err.println(string);
            outOfMemoryError.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static char[] doConversion(char[] cArray, int n, short s) throws IOException {
        char[] cArray2 = ":".toCharArray();
        char[] cArray3 = "</msgId>".toCharArray();
        char[] cArray4 = ConvertLog.doConversion(cArray, n, cArray2, s);
        cArray = cArray4;
        cArray4 = ConvertLog.doConversion(cArray, n, cArray3, s);
        return cArray4;
    }

    private static char[] doConversion(char[] cArray, int n, char[] cArray2, short s) throws IOException {
        int n2 = cArray.length;
        if (n2 == 0) {
            return null;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 <= n2 - 1) {
            n4 = ConvertLog.indexOf(cArray, n3, cArray2);
            if (n4 < 0) {
                n5 = cArray.length - n3;
                charArrayWriter.write(cArray, n3, n5);
                n3 += n5;
                continue;
            }
            if (n4 - n3 >= n + 1) {
                n5 = n4 - n3 - n - 1;
                charArrayWriter.write(cArray, n3, n5);
                n3 += n5;
                char c = cArray[n4 - n - 1];
                if (c == ' ' || c == '\"' || c == '>') {
                    charArrayWriter.write(c);
                    ++n3;
                    int n6 = n + 1;
                    String string = new String(cArray, n4 - n, n6);
                    String string2 = MessageConverter.convert(string, s);
                    charArrayWriter.write(string2);
                    n3 += n6;
                    continue;
                }
                n5 = n + 1;
                charArrayWriter.write(cArray, n3, n5);
                n3 += n5;
                continue;
            }
            n5 = n4 - n3 + 1;
            charArrayWriter.write(cArray, n3, n5);
            n3 += n5;
        }
        return charArrayWriter.toCharArray();
    }

    private static final int indexOf(char[] cArray, int n, char[] cArray2) {
        if (cArray2 == null || cArray2.length == 0) {
            return -1;
        }
        int n2 = cArray2.length;
        int n3 = cArray.length;
        for (int i = n; i < n3; ++i) {
            int n4 = 0;
            if (cArray[i] != cArray2[n4]) continue;
            for (int j = i; j < n3 && cArray[j] == cArray2[n4]; ++j) {
                if (++n4 != n2) continue;
                return i;
            }
        }
        return -1;
    }

    private static char[] read(InputStreamReader inputStreamReader) throws IOException {
        char[] cArray = new char[8192];
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int n = 1;
        while (n > 0) {
            n = inputStreamReader.read(cArray);
            if (n <= 0) continue;
            charArrayWriter.write(cArray, 0, n);
        }
        charArrayWriter.flush();
        charArrayWriter.close();
        char[] cArray2 = charArrayWriter.toCharArray();
        charArrayWriter = null;
        return cArray2;
    }
}

