/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.http.channel.inbound.impl.HttpICLReadCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpIgnoreBodyCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundChannel;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.ws.http.channel.inbound.impl.HttpRequestHandler;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.InboundConnectionLink;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.impl.BaseConnectionLink;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedMethodException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.exception.MessageTooLargeException;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HttpInboundLink
extends BaseConnectionLink
implements InterChannelCallback,
InboundConnectionLink {
    private static final TraceComponent tc = Tr.register(HttpInboundLink.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private HttpInboundServiceContextImpl myInterface = null;
    private HttpInboundChannel myChannel = null;
    private TCPConnectionContext myTSC = null;
    private boolean bPartialParsedRequest = false;
    private int numRequestsProcessed = 0;
    private boolean filterExceptions = false;
    private boolean bIsActive = false;
    private List appSides = new ArrayList(5);

    public HttpInboundLink(HttpInboundChannel httpInboundChannel, VirtualConnection virtualConnection) {
        this.init(virtualConnection, httpInboundChannel);
        this.myInterface = new HttpInboundServiceContextImpl(null, this, this.getVirtualConnection(), this.getChannel().getHttpConfig());
    }

    public void init(VirtualConnection virtualConnection, HttpInboundChannel httpInboundChannel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Init on link: " + this + " " + virtualConnection);
        }
        super.init(virtualConnection);
        this.myChannel = httpInboundChannel;
        if (null != this.getHTTPContext()) {
            this.getHTTPContext().setHttpConfig(httpInboundChannel.getHttpConfig());
        }
        this.getVirtualConnection().getStateMap().put(CallbackIDs.CALLBACK_HTTPICL, this);
        this.bIsActive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying inbound link: " + this + " " + this.getVirtualConnection());
        }
        HttpInboundLink httpInboundLink = this;
        synchronized (httpInboundLink) {
            if (!this.bIsActive) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignoring destroy on an inactive object");
                }
                return;
            }
            this.bIsActive = false;
        }
        this.getVirtualConnection().getStateMap().remove(CallbackIDs.CALLBACK_HTTPICL);
        this.getVirtualConnection().getStateMap().remove("zConfiguredHttpReadBufferSize");
        super.destroy();
        for (int i = this.appSides.size() - 1; i >= 0; --i) {
            ConnectionReadyCallback connectionReadyCallback = (ConnectionReadyCallback)this.appSides.remove(i);
            connectionReadyCallback.destroy(exception);
        }
        this.myInterface.clear();
        this.myInterface.destroy();
        this.myInterface = null;
        this.myTSC = null;
        this.filterExceptions = false;
        this.numRequestsProcessed = 0;
        this.myChannel = null;
    }

    public Object getChannelAccessor() {
        return this.myInterface;
    }

    protected HttpInboundServiceContextImpl getHTTPContext() {
        return this.myInterface;
    }

    protected HttpInboundChannel getChannel() {
        return this.myChannel;
    }

    protected boolean maxRequestsServed() {
        if (this.getChannel().isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Channel stopped, disabling keep-alive request");
            }
            return true;
        }
        if (!this.getChannel().getHttpConfig().isKeepAliveEnabled()) {
            return true;
        }
        int n = this.getChannel().getHttpConfig().getMaximumPersistentRequests();
        if (0 <= n) {
            return this.numRequestsProcessed >= n;
        }
        return false;
    }

    protected boolean isFirstRequest() {
        return 0 == this.numRequestsProcessed || 1 == this.numRequestsProcessed && this.getHTTPContext().headersParsed();
    }

    protected boolean isPartiallyParsed() {
        return this.bPartialParsedRequest;
    }

    protected void setPartiallyParsed(boolean bl) {
        this.bPartialParsedRequest = bl;
    }

    public void ready(VirtualConnection virtualConnection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ready: " + this + " " + virtualConnection);
        }
        this.myTSC = (TCPConnectionContext)this.getDeviceLink().getChannelAccessor();
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = this.getHTTPContext();
        httpInboundServiceContextImpl.init(this.myTSC, this, virtualConnection, this.getChannel().getHttpConfig());
        if (this.getChannel().getHttpConfig().isErrorLoggingEnabled()) {
            this.getChannel().getHttpConfig().getHttpLogger().log(HttpConstants.LOG_INFO, "Received new connection ", (HttpServiceContext)httpInboundServiceContextImpl);
        }
        this.handleNewInformation();
        VirtualConnection virtualConnection2 = null;
        while (this.isPartiallyParsed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Partial request, reading more");
            }
            if (null == (virtualConnection2 = this.myTSC.getReadInterface().read(1L, HttpICLReadCallback.getRef(), false, httpInboundServiceContextImpl.getReadTimeout()))) break;
            this.handleNewInformation();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ready");
        }
    }

    void handleNewInformation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing new information: " + this.getVirtualConnection());
        }
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = this.getHTTPContext();
        if (!this.isPartiallyParsed() && this.getChannel().isStopped()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Channel stopped during initial read");
            }
            httpInboundServiceContextImpl.setHeadersParsed();
            httpInboundServiceContextImpl.getResponse().setVersion(HttpConstants.HTTP_VERSION_10);
            this.sendErrorMessage(HttpConstants.STATUS_UNAVAILABLE);
            return;
        }
        boolean bl = false;
        try {
            bl = httpInboundServiceContextImpl.parseMessage();
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            httpInboundServiceContextImpl.setHeadersParsed();
            this.sendErrorMessage(unsupportedMethodException);
            this.setPartiallyParsed(false);
            return;
        }
        catch (UnsupportedProtocolVersionException unsupportedProtocolVersionException) {
            httpInboundServiceContextImpl.setHeadersParsed();
            this.sendErrorMessage(unsupportedProtocolVersionException);
            this.setPartiallyParsed(false);
            return;
        }
        catch (MessageTooLargeException messageTooLargeException) {
            httpInboundServiceContextImpl.setHeadersParsed();
            this.sendErrorMessage(HttpConstants.STATUS_ENTITY_TOO_LARGE);
            this.setPartiallyParsed(false);
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "HttpInboundLink.handleNewInformation", "1", this);
            httpInboundServiceContextImpl.setHeadersParsed();
            this.sendErrorMessage(exception);
            this.setPartiallyParsed(false);
            return;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "HttpInboundLink.handleNewInformation", "2", this);
            httpInboundServiceContextImpl.setHeadersParsed();
            this.sendErrorMessage(throwable);
            this.setPartiallyParsed(false);
            return;
        }
        this.setPartiallyParsed(!bl);
        if (this.isPartiallyParsed()) {
            httpInboundServiceContextImpl.setupReadBuffers(httpInboundServiceContextImpl.getHttpConfig().getIncomingHdrBufferSize(), false);
            return;
        }
        httpInboundServiceContextImpl.setRequestVersion(httpInboundServiceContextImpl.getRequest().getVersionValue());
        httpInboundServiceContextImpl.setRequestMethod(httpInboundServiceContextImpl.getRequest().getMethodValue());
        httpInboundServiceContextImpl.getResponseImpl().init(httpInboundServiceContextImpl);
        ++this.numRequestsProcessed;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Received request number " + this.numRequestsProcessed + " on link " + this);
        }
        if (!httpInboundServiceContextImpl.check100Continue()) {
            return;
        }
        this.handleDiscrimination();
    }

    protected void handleDiscrimination() {
        if (this.getHTTPContext().checkFormData()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Discrimination will be called");
        }
        if (this.getChannel().getHttpConfig().runningOnZOS()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Storing buffer size on z/OS");
            }
            this.getVirtualConnection().getStateMap().put("zConfiguredHttpReadBufferSize", new Integer(this.getChannel().getHttpConfig().getIncomingBodyBufferSize()));
        }
        ConnectionReadyCallback connectionReadyCallback = this.getApplicationCallback();
        DiscriminationProcess discriminationProcess = this.getChannel().getDiscriminationProcess();
        int n = 0;
        try {
            n = discriminationProcess.discriminate(this.getVirtualConnection(), this.getHTTPContext().getRequest(), this);
        }
        catch (Exception exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during discriminate: " + exception);
            }
            this.setPartiallyParsed(false);
            this.sendErrorMessage(exception);
            return;
        }
        if (1 == n) {
            if (null == connectionReadyCallback) {
                this.appSides.add(this.getApplicationCallback());
            } else if (!this.getApplicationCallback().equals(connectionReadyCallback)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received new appside connlink: " + connectionReadyCallback + " vs " + this.getApplicationCallback());
                }
                if (!this.appSides.contains(this.getApplicationCallback())) {
                    this.appSides.add(this.getApplicationCallback());
                }
            }
            try {
                this.getApplicationCallback().ready(this.getVirtualConnection());
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "HttpInboundLink.handleDiscrimination", "1", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "App side ready() threw exception: " + throwable);
                }
                if (!this.bIsActive) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Link not active, returning out.");
                    }
                    return;
                }
                if (this.getHTTPContext().headersSent()) {
                    this.getDeviceLink().close(this.getVirtualConnection(), new Exception(throwable));
                    return;
                }
                this.sendErrorMessage(HttpConstants.STATUS_UNAVAILABLE);
                return;
            }
        } else {
            this.setPartiallyParsed(false);
            this.sendErrorMessage(new Exception("Discrimination failed"));
        }
    }

    private void sendErrorMessage(Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending a 400 for [" + exception + "]");
        }
        this.sendErrorMessage(HttpConstants.STATUS_BAD_REQUEST);
    }

    private void sendErrorMessage(Throwable throwable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending a 400 for throwable [" + throwable + "]");
        }
        this.sendErrorMessage(HttpConstants.STATUS_BAD_REQUEST);
    }

    private void sendErrorMessage(UnsupportedProtocolVersionException unsupportedProtocolVersionException) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending 505 for " + unsupportedProtocolVersionException.getMessage());
        }
        this.sendErrorMessage(HttpConstants.STATUS_VERSION);
    }

    private void sendErrorMessage(UnsupportedMethodException unsupportedMethodException) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending 501 for " + unsupportedMethodException.getMessage());
        }
        this.sendErrorMessage(HttpConstants.STATUS_NOT_IMPLEMENTED);
    }

    private void sendErrorMessage(StatusCodes statusCodes) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending an error page back [code: " + statusCodes + "]");
        }
        try {
            this.getHTTPContext().sendError(statusCodes.getHttpError());
        }
        catch (MessageSentException messageSentException) {
            this.close(this.getVirtualConnection(), new Exception("HTTP Message failure"));
        }
    }

    private void handlePipeLining() {
        block9: {
            HttpInboundServiceContextImpl httpInboundServiceContextImpl = this.getHTTPContext();
            WsByteBuffer wsByteBuffer = httpInboundServiceContextImpl.returnLastBuffer();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Pipelined request found: " + wsByteBuffer);
            }
            ((HttpServiceContextImpl)httpInboundServiceContextImpl).clear();
            httpInboundServiceContextImpl.addToCreatedBuffer(wsByteBuffer);
            httpInboundServiceContextImpl.disableBufferModification();
            String string = (String)this.getVirtualConnection().getStateMap().get("TCP_THREADPOOL_NAME");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Threadpool name is [" + string + "]");
            }
            ThreadPool threadPool = null;
            threadPool = null != string ? ThreadPoolRepositoryManager.getThreadPoolRepository().getThreadPool(string) : this.getChannel().getConfig().getChannelFramework().getDefaultThreadPool();
            if (null != threadPool) {
                HttpRequestHandler httpRequestHandler = new HttpRequestHandler(this);
                try {
                    int n = threadPool.execute(httpRequestHandler, 0);
                    if (0 == n) {
                        return;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "ThreadPool failed to run handler, rc=" + n);
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName() + ".handlePipeLining", "1", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Error queueing pipeline request to threadpool; " + throwable);
                    }
                    break block9;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to find any pool, continuing on this thread");
            }
        }
        this.ready(this.getVirtualConnection());
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        VirtualConnection virtualConnection2;
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "close() called: " + this + " " + virtualConnection);
        }
        boolean bl2 = bl = null != exception;
        if (bl && tc.isDebugEnabled()) {
            Tr.debug(tc, "close() in error state, " + exception);
        }
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = this.getHTTPContext();
        HttpChannelConfig httpChannelConfig = httpInboundServiceContextImpl.getHttpConfig();
        if (httpInboundServiceContextImpl.containsLargeMessage()) {
            this.getChannel().getFactory().releaseLargeMessage();
        }
        if (!bl && !httpInboundServiceContextImpl.isMessageSent()) {
            try {
                virtualConnection2 = httpInboundServiceContextImpl.finishResponseMessage(null, this, false);
                if (null == virtualConnection2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "finishing response msg async");
                    }
                    return;
                }
            }
            catch (MessageSentException messageSentException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error: message sent exception when flag doesn't agree");
                }
                this.getDeviceLink().close(virtualConnection, messageSentException);
                return;
            }
        }
        if (!bl && this.getChannel().isRunning() && !httpInboundServiceContextImpl.isIncomingMessageFullyRead()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Incoming request body never read.");
            }
            try {
                virtualConnection2 = httpInboundServiceContextImpl.getRequestBodyBuffer(HttpIgnoreBodyCallback.getRef(), false);
                boolean bl3 = false;
                while (null != virtualConnection2) {
                    WsByteBuffer wsByteBuffer = httpInboundServiceContextImpl.getRequestBodyBuffer();
                    if (null != wsByteBuffer) {
                        wsByteBuffer.release();
                        virtualConnection2 = httpInboundServiceContextImpl.getRequestBodyBuffer(HttpIgnoreBodyCallback.getRef(), false);
                        continue;
                    }
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "close() waiting for body purge callback");
                    }
                    return;
                }
            }
            catch (Exception exception2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception purging request body: " + exception2);
                }
                bl = true;
            }
        }
        if (!bl && httpInboundServiceContextImpl.isPersistent() && this.getChannel().isRunning()) {
            if (httpChannelConfig.isErrorLoggingEnabledAtDebug()) {
                httpChannelConfig.getHttpLogger().log(HttpConstants.LOG_DEBUG, "Reading for another request", (HttpServiceContext)httpInboundServiceContextImpl);
            }
            this.myTSC.getWriteInterface().setBuffers(null);
            if (httpInboundServiceContextImpl.isReadDataAvailable()) {
                this.handlePipeLining();
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading for another request...");
            }
            this.getVirtualConnection().getStateMap().put("HTTPFirstRead", "true");
            httpInboundServiceContextImpl.clear();
            httpInboundServiceContextImpl.setReadBuffer(null);
            httpInboundServiceContextImpl.setupJITRead(httpChannelConfig.getIncomingHdrBufferSize());
            if (httpChannelConfig.isKeepThread()) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "keepThread says to block read");
                    }
                    this.myTSC.getReadInterface().read(1L, httpChannelConfig.getPersistTimeout());
                    this.ready(virtualConnection);
                }
                catch (IOException iOException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "IOException while reading data.");
                    }
                    if (httpChannelConfig.isErrorLoggingEnabled()) {
                        httpChannelConfig.getHttpLogger().log(HttpConstants.LOG_WARN, "Read for another request failed", (HttpServiceContext)httpInboundServiceContextImpl);
                    }
                    this.myTSC.getWriteInterface().setBuffer(null);
                    this.myTSC.getReadInterface().setBuffer(null);
                    this.getDeviceLink().close(virtualConnection, null);
                }
                return;
            }
            this.myTSC.getReadInterface().read(1L, HttpICLReadCallback.getRef(), true, httpChannelConfig.getPersistTimeout());
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Closing connection");
            }
            if (httpChannelConfig.isErrorLoggingEnabled()) {
                httpChannelConfig.getHttpLogger().log(HttpConstants.LOG_INFO, "Closing connection to client", (HttpServiceContext)httpInboundServiceContextImpl);
            }
            if (this.filterExceptions) {
                exception = null;
            }
            this.myTSC.getWriteInterface().setBuffer(null);
            this.myTSC.getReadInterface().setBuffer(null);
            this.getDeviceLink().close(virtualConnection, exception);
        }
    }

    public void complete(VirtualConnection virtualConnection) {
        this.close(virtualConnection, null);
    }

    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called on " + this + " " + virtualConnection);
        }
        try {
            this.close(virtualConnection, (Exception)throwable);
        }
        catch (ClassCastException classCastException) {
            this.close(virtualConnection, new Exception("Problem when finishing response"));
        }
    }

    protected void setFilterCloseExceptions(boolean bl) {
        this.filterExceptions = bl;
    }

    public HttpObjectFactory getObjectFactory() {
        return this.getChannel().getObjectFactory();
    }
}

