/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ws.genericbnf.impl.FastNonSynchHashBucket;
import com.ibm.ws.genericbnf.impl.FastNonSynchHashEntry;

public class FastNonSynchHashTable {
    private static final int yVar = 3;
    private int xVar = 1000;
    private FastNonSynchHashBucket[][] mainTable = null;

    public FastNonSynchHashTable(int n) {
        this.xVar = n / 3 + 1;
        this.initBuckets();
    }

    public FastNonSynchHashTable() {
        this.initBuckets();
    }

    private void initBuckets() {
        this.mainTable = new FastNonSynchHashBucket[this.xVar][3];
        for (int i = 0; i < this.xVar; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mainTable[i][j] = new FastNonSynchHashBucket();
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.xVar; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mainTable[i][j].setRoot(null);
            }
        }
    }

    public Object get(Object object) {
        int n = object.hashCode();
        return this.getValueFromBucket(this.getBucket(n), n, object, false);
    }

    public Object get(Object object, int n) {
        return this.getValueFromBucket(this.getBucket(n), n, object, false);
    }

    private Object getValueFromBucket(FastNonSynchHashBucket fastNonSynchHashBucket, int n, Object object, boolean bl) {
        FastNonSynchHashEntry fastNonSynchHashEntry = null;
        for (FastNonSynchHashEntry fastNonSynchHashEntry2 = fastNonSynchHashBucket.getRoot(); null != fastNonSynchHashEntry2; fastNonSynchHashEntry2 = fastNonSynchHashEntry2.getNext()) {
            if (fastNonSynchHashEntry2.getHash() == n && fastNonSynchHashEntry2.getKey().equals(object)) {
                if (bl) {
                    if (null == fastNonSynchHashEntry) {
                        fastNonSynchHashBucket.setRoot(fastNonSynchHashEntry2.getNext());
                    } else {
                        fastNonSynchHashEntry.setNext(fastNonSynchHashEntry2.getNext());
                    }
                }
                return fastNonSynchHashEntry2.getValue();
            }
            fastNonSynchHashEntry = fastNonSynchHashEntry2;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        if (null == object2) {
            throw new NullPointerException();
        }
        int n = object.hashCode();
        FastNonSynchHashBucket fastNonSynchHashBucket = this.getBucket(n);
        Object object3 = this.getValueFromBucket(fastNonSynchHashBucket, n, object, false);
        if (null != object3) {
            return object3;
        }
        FastNonSynchHashEntry fastNonSynchHashEntry = new FastNonSynchHashEntry(n, object, object2);
        return this.putIntoBucket(fastNonSynchHashBucket, fastNonSynchHashEntry);
    }

    public Object put(Object object, int n, Object object2) {
        FastNonSynchHashBucket fastNonSynchHashBucket = this.getBucket(n);
        Object object3 = this.getValueFromBucket(fastNonSynchHashBucket, n, object, false);
        if (null != object3) {
            return object3;
        }
        FastNonSynchHashEntry fastNonSynchHashEntry = new FastNonSynchHashEntry(n, object, object2);
        return this.putIntoBucket(fastNonSynchHashBucket, fastNonSynchHashEntry);
    }

    public Object forcePut(Object object, Object object2) {
        if (null == object2) {
            throw new NullPointerException();
        }
        int n = object.hashCode();
        FastNonSynchHashBucket fastNonSynchHashBucket = this.getBucket(n);
        this.getValueFromBucket(fastNonSynchHashBucket, n, object, true);
        FastNonSynchHashEntry fastNonSynchHashEntry = new FastNonSynchHashEntry(n, object, object2);
        return this.putIntoBucket(fastNonSynchHashBucket, fastNonSynchHashEntry);
    }

    public Object forcePut(Object object, int n, Object object2) {
        if (null == object2) {
            throw new NullPointerException();
        }
        FastNonSynchHashBucket fastNonSynchHashBucket = this.getBucket(n);
        this.getValueFromBucket(fastNonSynchHashBucket, n, object, true);
        FastNonSynchHashEntry fastNonSynchHashEntry = new FastNonSynchHashEntry(n, object, object2);
        return this.putIntoBucket(fastNonSynchHashBucket, fastNonSynchHashEntry);
    }

    private FastNonSynchHashBucket getBucket(int n) {
        int n2 = n & Integer.MAX_VALUE;
        return this.mainTable[n2 % this.xVar][n2 % 3];
    }

    private Object putIntoBucket(FastNonSynchHashBucket fastNonSynchHashBucket, FastNonSynchHashEntry fastNonSynchHashEntry) {
        FastNonSynchHashEntry fastNonSynchHashEntry2 = null;
        for (FastNonSynchHashEntry fastNonSynchHashEntry3 = fastNonSynchHashBucket.getRoot(); null != fastNonSynchHashEntry3; fastNonSynchHashEntry3 = fastNonSynchHashEntry3.getNext()) {
            if (fastNonSynchHashEntry3.getHash() == fastNonSynchHashEntry.getHash() && fastNonSynchHashEntry3.getKey().equals(fastNonSynchHashEntry.getKey())) {
                return fastNonSynchHashEntry3.getValue();
            }
            fastNonSynchHashEntry2 = fastNonSynchHashEntry3;
        }
        if (null == fastNonSynchHashEntry2) {
            if (null == fastNonSynchHashBucket.getRoot()) {
                fastNonSynchHashBucket.setRoot(fastNonSynchHashEntry);
                return fastNonSynchHashEntry.getValue();
            }
            fastNonSynchHashEntry2 = fastNonSynchHashBucket.getRoot();
            while (null != fastNonSynchHashEntry2.getNext()) {
                fastNonSynchHashEntry2 = fastNonSynchHashEntry2.getNext();
            }
        }
        fastNonSynchHashEntry2.setNext(fastNonSynchHashEntry);
        return fastNonSynchHashEntry.getValue();
    }

    public boolean containsKey(Object object) {
        int n = object.hashCode();
        return null != this.getValueFromBucket(this.getBucket(n), n, object, false);
    }

    public boolean containsKey(Object object, int n) {
        return null != this.getValueFromBucket(this.getBucket(n), n, object, false);
    }

    public Object remove(Object object) {
        int n = object.hashCode();
        return this.getValueFromBucket(this.getBucket(n), n, object, true);
    }

    public Object remove(Object object, int n) {
        return this.getValueFromBucket(this.getBucket(n), n, object, true);
    }
}

