/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JITUtils {
    static final String JIT_TRACE_GROUP = "JITDeploy";
    static final String JIT_RSRC_BUNDLE = "com.ibm.ejs.container.container";
    static final String INDENT = "     ";
    static final Class[] NO_PARAMS = new Class[0];
    private static final String CLASS_NAME = JITUtils.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "JITDeploy", "com.ibm.ejs.container.container");
    private static String svUserInstallRoot = null;
    static final Type TYPE_Exception = Type.getType((String)"Ljava/lang/Exception;");
    static final Type TYPE_Object = Type.getType((String)"Ljava/lang/Object;");
    static final Type TYPE_Object_ARRAY = Type.getType((String)"[Ljava/lang/Object;");
    static final Type TYPE_String = Type.getType((String)"Ljava/lang/String;");
    static final Type TYPE_Throwable = Type.getType((String)"Ljava/lang/Throwable;");
    static final Type TYPE_Serializable = Type.getType((String)"Ljava/io/Serializable;");

    JITUtils() {
    }

    static String convertClassName(String string) {
        return string.replace('.', '/');
    }

    static final String jdiMethodSignature(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        Class<?>[] classArray = method.getParameterTypes();
        stringBuilder.append("(");
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(JITUtils.mapTypeToJDIEncoding(classArray[i]));
        }
        stringBuilder.append(")");
        stringBuilder.append(JITUtils.mapTypeToJDIEncoding(method.getReturnType()));
        return stringBuilder.toString();
    }

    private static final String mapTypeToJDIEncoding(Class clazz) {
        String string = clazz.getName();
        String string2 = clazz.isArray() ? string.replace('.', '/') : (string.indexOf(46) > 0 ? "L" + string.replace('.', '/') + ";" : (string.equals("void") ? "V" : (string.equals("boolean") ? "Z" : (string.equals("int") ? "I" : (string.equals("long") ? "J" : (string.equals("double") ? "D" : (string.equals("float") ? "F" : (string.equals("char") ? "C" : (string.equals("byte") ? "B" : (string.equals("short") ? "S" : "L" + string + ";"))))))))));
        return string2;
    }

    static Type[] getTypes(Class[] classArray) {
        int n = classArray.length;
        Type[] typeArray = new Type[n];
        for (int i = 0; i < n; ++i) {
            typeArray[i] = Type.getType((Class)classArray[i]);
        }
        return typeArray;
    }

    static Class<?>[] getCheckedExceptions(Method method, boolean bl, boolean bl2) throws EJBConfigurationException {
        boolean bl3 = false;
        Class<?>[] classArray = method.getExceptionTypes();
        int n = classArray.length;
        ArrayList arrayList = new ArrayList(n);
        for (Class<?> clazz : classArray) {
            Class clazz2;
            int string;
            if (clazz == RemoteException.class) {
                if (!bl) {
                    Tr.warning(tc, "JIT_INVALID_THROW_REMOTE_CNTR5101W", (Object)new Object[]{method.getName(), method.getDeclaringClass().getName()});
                }
                bl3 = true;
                continue;
            }
            if (RemoteException.class.isAssignableFrom(clazz)) {
                String string2 = method.getDeclaringClass().getName();
                Tr.error(tc, "JIT_INVALID_SUBCLASS_REMOTE_EX_CNTR5102E", new Object[]{clazz.getName(), method.getName(), string2});
                throw new EJBConfigurationException("Application exception " + clazz.getName() + " defined on method " + method.getName() + " of interface " + string2 + " must not subclass java.rmi.RemoteException.");
            }
            if (bl2) {
                string = 0;
                for (Class<?> clazz3 : classArray) {
                    if (clazz == clazz3 || !clazz3.isAssignableFrom(clazz)) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getCheckedExceptions: ignoring " + clazz.getName() + ", subclass of " + clazz3.getName());
                    }
                    string = 1;
                    break;
                }
                if (string != 0) continue;
                arrayList.add(clazz);
                continue;
            }
            int n2 = arrayList.size();
            for (string = 0; string < n2 && !(clazz2 = (Class)arrayList.get(string)).isAssignableFrom(clazz); ++string) {
            }
            arrayList.add(string, clazz);
        }
        if (bl && !bl3) {
            String string = method.getDeclaringClass().getName();
            Tr.error(tc, "JIT_MISSING_REMOTE_EX_CNTR5104E", new Object[]{method.getName(), string});
            throw new EJBConfigurationException("Method " + method.getName() + " of interface " + string + " must throw java.rmi.RemoteException");
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    static void unbox(GeneratorAdapter generatorAdapter, Type type) {
        switch (type.getSort()) {
            case 0: {
                return;
            }
            case 1: {
                generatorAdapter.visitTypeInsn(192, "java/lang/Boolean");
                generatorAdapter.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 2: {
                generatorAdapter.visitTypeInsn(192, "java/lang/Character");
                generatorAdapter.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                break;
            }
            case 3: {
                generatorAdapter.visitTypeInsn(192, "java/lang/Byte");
                generatorAdapter.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                break;
            }
            case 4: {
                generatorAdapter.visitTypeInsn(192, "java/lang/Short");
                generatorAdapter.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                break;
            }
            case 5: {
                generatorAdapter.visitTypeInsn(192, "java/lang/Integer");
                generatorAdapter.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                break;
            }
            case 6: {
                generatorAdapter.visitTypeInsn(192, "java/lang/Float");
                generatorAdapter.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                break;
            }
            case 7: {
                generatorAdapter.visitTypeInsn(192, "java/lang/Long");
                generatorAdapter.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                break;
            }
            case 8: {
                generatorAdapter.visitTypeInsn(192, "java/lang/Double");
                generatorAdapter.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                break;
            }
            default: {
                generatorAdapter.checkCast(type);
            }
        }
    }

    static String USER_INSTALL_ROOT() {
        if (svUserInstallRoot == null) {
            try {
                String string = (String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("user.install.root", null));
                if (string == null) {
                    string = (String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("was.install.root", ""));
                }
                svUserInstallRoot = string;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, CLASS_NAME + ".USER_INSTALL_ROOT", "419");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "USER_INSTALL_ROOT() failed : " + throwable.getMessage());
                }
                svUserInstallRoot = "";
            }
        }
        return svUserInstallRoot;
    }

    static void writeToClassFile(String string, byte[] byArray) {
        block3: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "writeToClassFile (" + string + ", " + (byArray == null ? "null" : byArray.length + " bytes") + ")");
            }
            try {
                File file = new File(JITUtils.USER_INSTALL_ROOT() + "/logs/JITDeploy/" + string + ".class");
                File file2 = file.getParentFile();
                file2.mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, CLASS_NAME + ".writeToClassFile", "463");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "writeToClassFile failed for class " + string + " : " + throwable.getMessage());
            }
        }
    }
}

