/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.ejbcontainer.jitdeploy.JIT_Stub;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.dopriv.GetClassLoaderPrivileged;
import java.lang.ref.WeakReference;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JITClassLoader
extends ClassLoader {
    private static final String CLASS_NAME = JITClassLoader.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "JITDeploy", "com.ibm.ejs.container.container");
    private static final String OMG_STUB_PREFIX = "org.omg.stub.";
    private static final ProtectionDomain svPD;
    private static WeakHashMap<ClassLoader, WeakReference<JITClassLoader>> svInstanceMap;
    private final ClassLoader ivParent;
    private final CompoundClassLoader ivAppCL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JITClassLoader getJITClassLoader(ClassLoader classLoader) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoader: " + classLoader);
        }
        if (classLoader instanceof JITClassLoader) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getClassLoader: " + classLoader);
            }
            return (JITClassLoader)classLoader;
        }
        JITClassLoader jITClassLoader = null;
        WeakHashMap<ClassLoader, WeakReference<JITClassLoader>> weakHashMap = svInstanceMap;
        synchronized (weakHashMap) {
            WeakReference<JITClassLoader> weakReference = svInstanceMap.get(classLoader);
            if (weakReference != null) {
                jITClassLoader = (JITClassLoader)weakReference.get();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "existing JITCL found for parent : " + jITClassLoader);
                }
            }
            if (jITClassLoader == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "existing JITCL not found - creating new one");
                }
                jITClassLoader = new JITClassLoader(classLoader);
                weakReference = new WeakReference<JITClassLoader>(jITClassLoader);
                svInstanceMap.put(classLoader, weakReference);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoader: " + jITClassLoader);
        }
        return jITClassLoader;
    }

    private JITClassLoader() {
        throw new IllegalStateException("Unsupported constructor");
    }

    private JITClassLoader(ClassLoader classLoader) {
        super(classLoader);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "JITClassLoader.<init>: " + classLoader);
        }
        this.ivParent = classLoader;
        this.ivAppCL = classLoader instanceof CompoundClassLoader ? (CompoundClassLoader)classLoader : null;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findClass: " + string);
        }
        Class clazz = null;
        String string2 = JIT_Stub.getRemoteInterfaceName(string);
        if (string2 != null) {
            Object object;
            block20: {
                if (!string.startsWith(OMG_STUB_PREFIX)) {
                    object = OMG_STUB_PREFIX + string;
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "attempting load of class: " + (String)object);
                        }
                        clazz = this.ivParent.loadClass((String)object);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "findClass: " + clazz);
                        }
                        return clazz;
                    }
                    catch (Throwable throwable) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block20;
                        Tr.debug(tc, "org.omg.stub load failed: " + throwable);
                    }
                }
            }
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "loading remote interface: " + string2);
                }
                object = this.ivParent.loadClass(string2);
                byte[] byArray = JIT_Stub.generateStubBytes((Class)object);
                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new GetClassLoaderPrivileged((Class<?>)object));
                if (classLoader instanceof CompoundClassLoader) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "define using interface classloader: " + classLoader);
                    }
                    CompoundClassLoader compoundClassLoader = (CompoundClassLoader)classLoader;
                    clazz = compoundClassLoader.defineApplicationClass(string, byArray);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "define using this classloader: " + this);
                    }
                    clazz = this.defineApplicationClass(string, byArray);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "findClass failed: " + classNotFoundException);
                }
                throw new ClassNotFoundException(string, classNotFoundException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, CLASS_NAME + ".findClass", "95", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "findClass failed: " + throwable);
                }
                throw new ClassNotFoundException(string, throwable);
            }
        }
        if (clazz == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "findClass: ClassNotFoundException: " + string);
            }
            throw new ClassNotFoundException(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findClass: " + clazz);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> defineApplicationClass(String string, byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "defineApplicationClass: " + string);
        }
        Class<?> clazz = null;
        if (this.ivAppCL != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "delegating to parent : " + this.ivAppCL);
            }
            clazz = this.ivAppCL.defineApplicationClass(string, byArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "defineApplicationClass: " + clazz);
            }
            return clazz;
        }
        JITClassLoader jITClassLoader = this;
        synchronized (jITClassLoader) {
            clazz = this.findLoadedClass(string);
            if (clazz == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling defineClass on this");
                }
                clazz = this.defineClass(string, byArray, 0, byArray.length, svPD);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "class has already been loaded");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "defineApplicationClass: " + clazz);
        }
        return clazz;
    }

    static {
        svInstanceMap = new WeakHashMap();
        Permissions permissions = new Permissions();
        ((PermissionCollection)permissions).add(new AllPermission());
        svPD = new ProtectionDomain(null, permissions);
    }
}

