/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;

public class KeySetManager {
    private static final TraceComponent tc = Tr.register(KeySetManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static KeySetManager thisClass = null;
    private HashMap keySetMap = new HashMap();

    private KeySetManager() {
    }

    public static KeySetManager getInstance() {
        if (thisClass == null) {
            thisClass = new KeySetManager();
        }
        return thisClass;
    }

    public synchronized void initializeKeySets(Security security, boolean bl) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeKeySets");
        }
        try {
            EList eList;
            if (bl) {
                this.keySetMap.clear();
            }
            if ((eList = security.getKeySets()) != null && eList.size() > 0) {
                for (int i = 0; i < eList.size(); ++i) {
                    KeySet keySet = (KeySet)eList.get(i);
                    if (keySet == null) continue;
                    String string = keySet.getManagementScope().getScopeName();
                    if (string != null && !ManagementScopeManager.getInstance().currentScopeContained(string)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skipping keyset name \"" + keySet.getName() + "\" having scope \"" + string + "\".");
                        continue;
                    }
                    WSKeySet wSKeySet = new WSKeySet(keySet);
                    if (wSKeySet == null) continue;
                    this.keySetMap.put(keySet.getName(), wSKeySet);
                }
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception initializing KeySets.", new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.KeySetManager.initializeKeySets", "101", this);
            throw new KeyException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeKeySets");
        }
    }

    public WSKeySet getKeySet(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeySet -> " + string);
        }
        boolean bl = false;
        WSKeySet wSKeySet = (WSKeySet)this.keySetMap.get(string);
        if (wSKeySet != null) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeySet -> " + bl);
        }
        return wSKeySet;
    }
}

