/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.service;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.ws.cluster.Compressor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.cluster.distribution.ClientClusterContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ClientClusterContextImpl
implements ClientClusterContext {
    private static final TraceComponent tc = Tr.register(ClientClusterContextImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private DescriptionManager descMgr;
    private static final int clientContextVersion = 3;
    private List clusters;

    public ClientClusterContextImpl(List list) {
        DescriptionManagerFactory.getInstance();
        this.descMgr = DescriptionManagerFactory.getDescriptionManager();
        this.clusters = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", list);
        }
        ListIterator<ClusterDescription> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            DescriptionKey descriptionKey = (DescriptionKey)listIterator.next();
            ClusterDescription clusterDescription = (ClusterDescription)this.descMgr.getDescription(descriptionKey);
            if (clusterDescription != null) {
                listIterator.set(clusterDescription);
                continue;
            }
            listIterator.remove();
        }
        this.clusters = list;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public byte[] exportClientContext() {
        byte[] byArray;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "exportClientContext");
            }
            byArray = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeInt(3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wrote context version 3");
                }
                this.sendClientContextClusters(objectOutputStream);
                objectOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                objectOutputStream.close();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, ClientClusterContextImpl.class.getName() + ".exportClientContext", "121", this);
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "unexpected exception", iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportClientContext", byArray);
        }
        return byArray;
    }

    public void importClusterContext(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveClientContext", byArray);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        WsObjectInputStream wsObjectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(Compressor.decompress(byArray, 4));
            wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
            DescriptionManagerFactory.getInstance();
            DescriptionManagerFactory.getDescriptionManager().update(wsObjectInputStream);
            wsObjectInputStream.close();
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, ClientClusterContextImpl.class.getName() + ".receiveClientContext", "151", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveClientContext");
        }
    }

    private void sendClientContextClusters(ObjectOutput objectOutput) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendClientContextPrefix");
        }
        Iterator iterator = this.clusters.iterator();
        while (iterator.hasNext()) {
            ClusterDescription clusterDescription = (ClusterDescription)iterator.next();
            ClusterDescription.Memento memento = (ClusterDescription.Memento)((Object)clusterDescription);
            objectOutput.writeBoolean(true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote available to process true");
            }
            KeyRepositoryFactory.getInstance().getKeyRepository().exportToStream(objectOutput, clusterDescription.getKey());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote cluster Key " + clusterDescription.getKey());
            }
            objectOutput.writeLong(memento.getStructuralEpoch());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wrote structural epoch " + memento.getStructuralEpoch());
            }
            objectOutput.writeLong(memento.getInfluentialEpoch());
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "wrote influential epoch " + memento.getInfluentialEpoch());
        }
        objectOutput.writeBoolean(false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wrote available to process false");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendClientContextPrefix");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.4 ");
        }
    }
}

