/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBContainerException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.csi.EJBClusterNameService;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.Server;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;

public class ApplicationServerRuntimeImpl
extends WsComponentImpl
implements EJBClusterNameService,
DeployedObjectListener {
    private static final TraceComponent tc = Tr.register(ApplicationServerRuntimeImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String cellName = AdminServiceFactory.getAdminService().getCellName();
    private static ClusterMemberService clusterMemberService = null;
    private Identity containingClusterIdentity = null;
    private Server server = null;

    public static void setClusterMemberService(ClusterMemberService clusterMemberService) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setClusterMemberService", clusterMemberService);
        }
        ApplicationServerRuntimeImpl.clusterMemberService = clusterMemberService;
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        ApplicationMgr applicationMgr;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", object);
            }
            super.initialize(object);
            try {
                this.server = (Server)WsServiceRegistry.getService(this, Server.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, ApplicationServerRuntimeImpl.class.getName() + ".initialize", "116");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "initialize getService Failed");
                }
                throw new ComponentDisabledException();
            }
            String string = this.server.getClusterName();
            if (string != null) {
                this.containingClusterIdentity = IdentityMapping.getApplicationServerCluster(cellName, string);
                applicationMgr = null;
                try {
                    applicationMgr = (EJBContainer)WsServiceRegistry.getService(this, EJBContainer.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, ApplicationServerRuntimeImpl.class.getName() + ".initialize", "128");
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "initialize getService Failed");
                    }
                    throw new ComponentDisabledException();
                }
                try {
                    applicationMgr.setClusterNameService(this);
                }
                catch (EJBContainerException eJBContainerException) {
                    FFDCFilter.processException((Throwable)eJBContainerException, ApplicationServerRuntimeImpl.class.getName() + ".start", "107", this);
                    if (!tc.isEventEnabled()) break block14;
                    Tr.event(tc, "unexpected", (Object)eJBContainerException);
                }
            }
        }
        applicationMgr = null;
        try {
            applicationMgr = (ApplicationMgr)WsServiceRegistry.getService(this, ApplicationMgr.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ApplicationServerRuntimeImpl.class.getName() + ".initialize", "147");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize getService Failed");
            }
            throw new ComponentDisabledException();
        }
        applicationMgr.addDeployedObjectListener(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", new Object[]{clusterMemberService, this.containingClusterIdentity});
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        super.start();
        this.joinStandaloneCluster(cellName, this.server.getNodeName(), this.server.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public Identity getClusterIdentity(J2EEName j2EEName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterIdentity", new Object[]{j2EEName, j2EEName.getModule()});
        }
        Identity identity = this.containingClusterIdentity;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterIdentity", identity);
        }
        return identity;
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        block15: {
            DeployedObject deployedObject;
            String string;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stateChanged", deployedObjectEvent);
            }
            try {
                string = deployedObjectEvent.getDeployedObject().getName();
                deployedObject = deployedObjectEvent.getDeployedObject();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, ApplicationServerRuntimeImpl.class.getName(), "188", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "unexpected exception", exception);
                }
                return;
            }
            String string2 = null;
            if (!(deployedObject instanceof DeployedModule)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "stateChanged", string + " is not a deployed module.");
                }
                return;
            }
            string2 = ((DeployedModule)deployedObject).getDeployedApplication().getName();
            if (deployedObjectEvent.getPropertyName() != null && deployedObjectEvent.getPropertyName().equals("state")) {
                if (deployedObjectEvent.getNewValue() != null && deployedObjectEvent.getNewValue().equals("STARTED")) {
                    Identity identity = IdentityMapping.getApplicationCluster(cellName, string2, string);
                    try {
                        clusterMemberService.joinCluster(identity);
                        clusterMemberService.defineAttribute(string);
                    }
                    catch (NoClusterDefinedException noClusterDefinedException) {
                        FFDCFilter.processException((Throwable)noClusterDefinedException, ApplicationServerRuntimeImpl.class.getName(), "165", this);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "unexpected exception", noClusterDefinedException);
                        }
                        break block15;
                    }
                }
                if (deployedObjectEvent.getOldValue() != null && deployedObjectEvent.getOldValue().equals("STARTED")) {
                    Identity identity = IdentityMapping.getApplicationCluster(cellName, string2, string);
                    try {
                        clusterMemberService.disjoinCluster(identity);
                        clusterMemberService.undefineAttribute(string);
                    }
                    catch (NoClusterDefinedException noClusterDefinedException) {
                        FFDCFilter.processException((Throwable)noClusterDefinedException, ApplicationServerRuntimeImpl.class.getName(), "176", this);
                        if (!tc.isEventEnabled()) break block15;
                        Tr.event(tc, "unexpected exception", noClusterDefinedException);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged", new Object[]{deployedObjectEvent.getPropertyName(), deployedObjectEvent.getOldValue(), deployedObjectEvent.getNewValue(), deployedObjectEvent.getRuntimeState()});
        }
    }

    private void joinStandaloneCluster(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "joinStandaloneCluster", new Object[]{string, string2, string3});
        }
        try {
            Identity identity = IdentityMapping.getServerInstanceCluster(string, string2, string3);
            clusterMemberService.joinCluster(identity);
        }
        catch (NoClusterDefinedException noClusterDefinedException) {
            FFDCFilter.processException(noClusterDefinedException, ApplicationServerRuntimeImpl.class.getName() + ".joinSingletonCluster", "197", this, new Object[]{string, string2, string3});
            if (tc.isEventEnabled()) {
                Tr.event(tc, "joinSingletonCluster", noClusterDefinedException);
            }
            Tr.error(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{"joinSingletonCluster", noClusterDefinedException});
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.14 ");
        }
    }
}

