/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.ws.cluster.channel.ChannelSelectionAdapterImpl;
import com.ibm.ws.cluster.channel.ChannelTargetImpl;
import com.ibm.ws.cluster.channel.HealthMonitorAllowRemovePolicy;
import com.ibm.ws.cluster.channel.HealthMonitorRemoveTaskPolicy;
import com.ibm.ws.cluster.channel.HealthMonitorSleepTimePolicy;
import com.ibm.ws.cluster.channel.HealthMonitorSteppedSleepTimePolicy;
import com.ibm.ws.cluster.channel.MonitorAdvisorManager;
import com.ibm.ws.cluster.channel.MonitorAdvisorManagerFactory;
import com.ibm.ws.cluster.channel.MonitorTaskInfo;
import com.ibm.ws.cluster.selection.TargetImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPool;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPoolFactory;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.adapter.channel.ChannelTarget;
import com.ibm.wsspi.cluster.adapter.channel.HealthMonitorFactory;
import com.ibm.wsspi.cluster.adapter.channel.HealthMonitorManager;
import com.ibm.wsspi.cluster.adapter.channel.MonitorAdvisor;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class HealthMonitorManagerImpl
extends WsComponentImpl
implements HealthMonitorManager {
    private static final TraceComponent tc = Tr.register(HealthMonitorManager.class, "HealthMonitor", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final DescriptionManager descManager;
    private static final SelectionService selectionService;
    private static final ClusterService clusterService;
    private static final int Initial_Enqueue_Interval = 50;
    private static final String PROXY_SERVER_TYPE = "PROXY_SERVER";
    private WeakHashMap epTasks = null;
    private SleeperThreadPool sleeperThreadPool = null;
    private MonitorAdvisorManager advisorManager = null;
    private HealthMonitorSleepTimePolicy sleepTimePolicy = null;
    private HealthMonitorRemoveTaskPolicy removeTaskPolicy = null;
    private boolean postedNoHealthMonitorWarning = false;
    private HealthMonitorManager healthMonitorManager = null;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{object});
        }
        try {
            WsServiceRegistry.addService(this, HealthMonitorManager.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, HealthMonitorManagerImpl.class.getName() + ".initialize", "129");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "initialize addService Failed");
            }
            throw new ComponentDisabledException();
        }
        this.epTasks = new WeakHashMap();
        this.sleeperThreadPool = SleeperThreadPoolFactory.getInstance();
        this.advisorManager = MonitorAdvisorManagerFactory.getInstance();
        this.sleeperThreadPool.setMinimumPoolSize(0);
        this.sleeperThreadPool.setMaximumPoolSize(10);
        this.sleepTimePolicy = new HealthMonitorSteppedSleepTimePolicy(this.epTasks, this.sleeperThreadPool);
        this.removeTaskPolicy = new HealthMonitorAllowRemovePolicy(this.epTasks, this.sleeperThreadPool);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this.healthMonitorManager = HealthMonitorFactory.getHealthMonitorManager();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitoringEndPoints(CFEndPoint[] cFEndPointArray, EndPoint[] endPointArray) {
        if (cFEndPointArray == null || endPointArray == null || cFEndPointArray.length != endPointArray.length) {
            throw new IllegalArgumentException("No [CF]EndPoint argument(s) or sizes not match.");
        }
        int n = cFEndPointArray.length;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addMonitoringEndPoints", Integer.toString(n));
        }
        for (int i = 0; i < n; ++i) {
            Identity identity = endPointArray[i].getIdentity();
            WeakHashMap weakHashMap = this.epTasks;
            synchronized (weakHashMap) {
                EndPointMonitorTask endPointMonitorTask = (EndPointMonitorTask)this.epTasks.get(identity);
                if (endPointMonitorTask == null) {
                    endPointMonitorTask = new EndPointMonitorTask(cFEndPointArray[i], endPointArray[i]);
                    this.epTasks.put(identity, endPointMonitorTask);
                    this.sleeperThreadPool.RunInTimeOrder(endPointMonitorTask, 50);
                } else if (!this.sleeperThreadPool.inQueue(endPointMonitorTask)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "addMonitoringEndPoints", "Sync task back to the sleep queue:" + endPointMonitorTask);
                    }
                    this.sleeperThreadPool.RunInTimeOrder(endPointMonitorTask, 50);
                }
                continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addMonitoringEndPoints", this.epTasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitoringEndPoints(CFEndPoint[] cFEndPointArray, EndPoint[] endPointArray) {
        if (cFEndPointArray == null || endPointArray == null || cFEndPointArray.length != endPointArray.length) {
            throw new IllegalArgumentException("No [CF]EndPoint argument(s) or sizes not match.");
        }
        int n = cFEndPointArray.length;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeMonitoringEndPoints", Integer.toString(n));
        }
        for (int i = 0; i < n; ++i) {
            endPointArray[i].setAvailability(true);
            Identity identity = endPointArray[i].getIdentity();
            WeakHashMap weakHashMap = this.epTasks;
            synchronized (weakHashMap) {
                EndPointMonitorTask endPointMonitorTask = (EndPointMonitorTask)this.epTasks.get(identity);
                if (endPointMonitorTask != null) {
                    this.epTasks.remove(identity);
                }
                continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeMonitoringEndPoints", this.epTasks);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startMonitorEndPoints(ChannelTargetImpl channelTargetImpl, CFEndPointCriteria cFEndPointCriteria) {
        block15: {
            EndPoint[] endPointArray;
            CFEndPoint[] cFEndPointArray;
            block13: {
                int n;
                EndPoint[] endPointArray2;
                CFEndPoint[] cFEndPointArray2;
                block14: {
                    block10: {
                        block11: {
                            block12: {
                                if (tc.isEntryEnabled()) {
                                    Tr.entry(tc, "startMonitorEndPoints");
                                }
                                boolean bl = true;
                                cFEndPointArray2 = channelTargetImpl.getCFEndpoints();
                                endPointArray2 = channelTargetImpl.getEndpoints();
                                if (this.healthMonitorManager == null) break block10;
                                if (ChannelSelectionAdapterImpl.cfService == null) {
                                    Tr.error(tc, "NLSKEY_CFS_UNAVAILABLE");
                                    throw new IllegalStateException("The ChannelFrameworkService is not available for obtaining all selected end points..");
                                }
                                if (cFEndPointArray2 == null) {
                                    cFEndPointArray = channelTargetImpl.getCFEndPoint();
                                    cFEndPointArray2 = channelTargetImpl.getCFEndpoints();
                                    endPointArray2 = channelTargetImpl.getEndpoints();
                                    if (cFEndPointArray == null) {
                                        bl = false;
                                    }
                                }
                                if (!bl || cFEndPointArray2 == null || endPointArray2 == null || cFEndPointArray2.length <= 0 || endPointArray2.length <= 0) break block11;
                                cFEndPointArray = ChannelSelectionAdapterImpl.cfService.getEndPoints(cFEndPointArray2, cFEndPointCriteria);
                                endPointArray = channelTargetImpl.getEndpoints();
                                if (cFEndPointArray == null || cFEndPointArray == null || cFEndPointArray.length <= 0 || cFEndPointArray.length <= 0) break block12;
                                if (cFEndPointArray.length >= endPointArray.length) break block13;
                                endPointArray = new EndPoint[cFEndPointArray.length];
                                n = 0;
                                break block14;
                            }
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Unable to retrieve end points to monitor for this ChannelTarget.");
                            }
                            break block15;
                        }
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Unable to retrieve end points to monitor for this ChannelTarget.");
                        }
                        break block15;
                    }
                    if (!this.postedNoHealthMonitorWarning) {
                        this.postedNoHealthMonitorWarning = true;
                        Tr.event(tc, "HealthMonitorManager is not available.");
                    }
                    break block15;
                }
                for (int i = 0; i < cFEndPointArray.length; ++i) {
                    while (cFEndPointArray[i] != cFEndPointArray2[n]) {
                        ++n;
                    }
                    endPointArray[i] = endPointArray2[n];
                }
            }
            this.addMonitoringEndPoints(cFEndPointArray, endPointArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startMonitorEndPoints");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void stopMonitorEndPoints(ChannelTargetImpl channelTargetImpl, CFEndPointCriteria cFEndPointCriteria) {
        block15: {
            EndPoint[] endPointArray;
            CFEndPoint[] cFEndPointArray;
            block13: {
                int n;
                EndPoint[] endPointArray2;
                CFEndPoint[] cFEndPointArray2;
                block14: {
                    block10: {
                        block11: {
                            block12: {
                                if (tc.isEntryEnabled()) {
                                    Tr.entry(tc, "stopMonitorEndPoints");
                                }
                                boolean bl = true;
                                cFEndPointArray2 = channelTargetImpl.getCFEndpoints();
                                endPointArray2 = channelTargetImpl.getEndpoints();
                                if (this.healthMonitorManager == null) break block10;
                                if (ChannelSelectionAdapterImpl.cfService == null) {
                                    Tr.error(tc, "NLSKEY_CFS_UNAVAILABLE");
                                    throw new IllegalStateException("The ChannelFrameworkService is not available for obtaining all selected end points..");
                                }
                                if (cFEndPointArray2 == null) {
                                    cFEndPointArray = channelTargetImpl.getCFEndPoint();
                                    cFEndPointArray2 = channelTargetImpl.getCFEndpoints();
                                    endPointArray2 = channelTargetImpl.getEndpoints();
                                    if (cFEndPointArray == null) {
                                        bl = false;
                                    }
                                }
                                if (!bl || cFEndPointArray2 == null || endPointArray2 == null || cFEndPointArray2.length <= 0 || endPointArray2.length <= 0) break block11;
                                cFEndPointArray = ChannelSelectionAdapterImpl.cfService.getEndPoints(cFEndPointArray2, cFEndPointCriteria);
                                endPointArray = channelTargetImpl.getEndpoints();
                                if (cFEndPointArray == null || cFEndPointArray == null || cFEndPointArray.length <= 0 || cFEndPointArray.length <= 0) break block12;
                                if (cFEndPointArray.length >= endPointArray.length) break block13;
                                endPointArray = new EndPoint[cFEndPointArray.length];
                                n = 0;
                                break block14;
                            }
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Unable to retrieve end points to monitor for this ChannelTarget.");
                            }
                            break block15;
                        }
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Unable to retrieve end points for this ChannelTarget.");
                        }
                        break block15;
                    }
                    if (!this.postedNoHealthMonitorWarning) {
                        this.postedNoHealthMonitorWarning = true;
                        Tr.event(tc, "HealthMonitorManager is not available.");
                    }
                    break block15;
                }
                for (int i = 0; i < cFEndPointArray.length; ++i) {
                    while (cFEndPointArray[i] != cFEndPointArray2[n]) {
                        ++n;
                    }
                    endPointArray[i] = endPointArray2[n];
                }
            }
            this.removeMonitoringEndPoints(cFEndPointArray, endPointArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopMonitorEndPoints");
        }
    }

    public void startMonitor(ChannelTarget channelTarget) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startMonitor ChannelTarget", channelTarget);
            }
            if (channelTarget == null) {
                throw new IllegalArgumentException("The channelTarget attribute must not be null.");
            }
            try {
                this.startMonitorEndPoints((ChannelTargetImpl)channelTarget, ((ChannelTargetImpl)channelTarget).getCFEndPointCriteria());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, HealthMonitorManagerImpl.class.getName() + ".startMonitor", "402");
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Unexpected exception: could not startMonitor ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startMonitor ChannelTarget");
        }
    }

    public void startMonitor(Identity identity, CFEndPointCriteria cFEndPointCriteria) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startMonitor clusterIdentity", new Object[]{identity, cFEndPointCriteria});
            }
            if (identity == null) {
                throw new IllegalArgumentException("The Identity attribute must not be null.");
            }
            if (cFEndPointCriteria == null) {
                throw new IllegalArgumentException("The CFEndPointCriteria attribute must not be null.");
            }
            try {
                Target[] targetArray = this.getTargetList(identity);
                for (int i = 0; i < targetArray.length; ++i) {
                    ChannelTargetImpl channelTargetImpl = new ChannelTargetImpl(targetArray[i], cFEndPointCriteria);
                    this.startMonitorEndPoints(channelTargetImpl, cFEndPointCriteria);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, HealthMonitorManagerImpl.class.getName() + ".startMonitor", "435");
                if (!tc.isEventEnabled()) break block7;
                Tr.event(tc, "Unexpected exception: could not startMonitor ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startMonitor clusterIdentity");
        }
    }

    public void stopMonitor(ChannelTarget channelTarget) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stopMonitor ChannelTarget", channelTarget);
            }
            if (channelTarget == null) {
                throw new IllegalArgumentException("The channelTarget attribute must not be null.");
            }
            try {
                this.stopMonitorEndPoints((ChannelTargetImpl)channelTarget, ((ChannelTargetImpl)channelTarget).getCFEndPointCriteria());
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, HealthMonitorManagerImpl.class.getName() + ".stopMonitor", "458");
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Unexpected exception: could not stopMonitor ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopMonitor ChannelTarget");
        }
    }

    public void stopMonitor(Identity identity, CFEndPointCriteria cFEndPointCriteria) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stopMonitor clusterIdentity", new Object[]{identity, cFEndPointCriteria});
            }
            if (identity == null) {
                throw new IllegalArgumentException("The Identity attribute must not be null.");
            }
            if (cFEndPointCriteria == null) {
                throw new IllegalArgumentException("The CFEndPointCriteria attribute must not be null.");
            }
            try {
                Target[] targetArray = this.getTargetList(identity);
                for (int i = 0; i < targetArray.length; ++i) {
                    ChannelTargetImpl channelTargetImpl = new ChannelTargetImpl(targetArray[i], cFEndPointCriteria);
                    this.stopMonitorEndPoints(channelTargetImpl, cFEndPointCriteria);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, HealthMonitorManagerImpl.class.getName() + ".stopMonitor", "491");
                if (!tc.isEventEnabled()) break block7;
                Tr.event(tc, "Unexpected exception: could not stopMonitor ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopMonitor clusterIdentity");
        }
    }

    public void registerMonitorAdvisor(Class clazz) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerMonitorAdvisor", clazz);
            }
            if (clazz == null) {
                throw new IllegalArgumentException("The Class attribute must not be null.");
            }
            try {
                this.advisorManager.registerAdvisor(clazz);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, HealthMonitorManagerImpl.class.getName() + ".registerAdvisor", "513");
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Unexpected exception: could not registerAdvisor ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerMonitorAdvisor");
        }
    }

    public void deregisterMonitorAdvisor(Class clazz) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deregisterMonitorAdvisor", clazz);
            }
            if (clazz == null) {
                throw new IllegalArgumentException("The Class attribute must not be null.");
            }
            try {
                this.advisorManager.deregisterAdvisor(clazz);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, HealthMonitorManagerImpl.class.getName() + ".deregisterMonitorAdvisor", "535");
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Unexpected exception: could not deregisterMonitorAdvisor ", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterMonitorAdvisor");
        }
    }

    private Target[] getTargetList(Identity identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetList", identity);
        }
        Target[] targetArray = null;
        Identity[] identityArray = new Identity[]{identity};
        Identity[] identityArray2 = clusterService.getMemberIdentities(identity);
        targetArray = new Target[identityArray2.length];
        for (int i = 0; i < identityArray2.length; ++i) {
            EndPoint[] endPointArray = clusterService.matchEndPoints(identityArray2[i], ChannelTargetImpl.distinction);
            targetArray[i] = new TargetImpl(identityArray, identityArray2[i], endPointArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetList", targetArray);
        }
        return targetArray;
    }

    public Class[] getRegisteredMonitorAdvisors() {
        return this.advisorManager.getRegisteredAdvisors();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : 1.11.1.1 : none");
        }
        DescriptionManagerFactory.getInstance();
        descManager = DescriptionManagerFactory.getDescriptionManager();
        selectionService = SelectionServiceFactory.getSelectionService();
        clusterService = ClusterServiceFactory.getClusterService();
    }

    class EndPointMonitorTask
    extends MonitorTask {
        EndPointMonitorTask(CFEndPoint cFEndPoint, EndPoint endPoint) {
            super(cFEndPoint, endPoint);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EndPointMonitorTask endPointMonitorTask;
            Identity identity = this.endPoint.getIdentity();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run", new Object[]{identity, HealthMonitorManagerImpl.this.epTasks});
            }
            if ((endPointMonitorTask = (EndPointMonitorTask)HealthMonitorManagerImpl.this.epTasks.get(identity)) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run: identity is not in epTasks");
                }
                this.advisorsCache.remove(identity);
                return;
            }
            Description description = descManager.getDescription((DescriptionKey)identity);
            Class clazz = this.cfEndPoint.getChannelAccessor();
            if (description != null && clazz != null) {
                this.advisors = (ArrayList)this.advisorsCache.get(identity);
                if (this.advisors == null) {
                    Map map = this.advisorsCache;
                    synchronized (map) {
                        this.advisors = HealthMonitorManagerImpl.this.advisorManager.getAdvisors(clazz);
                        this.advisorsCache.put(identity, this.advisors);
                    }
                }
                if (this.advisors != null && this.advisors.size() > 0) {
                    boolean bl = false;
                    block11: for (int i = 0; !bl && i < this.advisors.size(); ++i) {
                        block25: {
                            MonitorAdvisor monitorAdvisor = (MonitorAdvisor)this.advisors.get(i);
                            try {
                                this.lastAdvice = monitorAdvisor.getAdvice(this.cfEndPoint);
                            }
                            catch (Exception exception) {
                                this.lastAdvice = -2;
                                if (!tc.isDebugEnabled()) break block25;
                                Tr.debug(tc, "run Exception: ", exception);
                            }
                        }
                        switch (this.lastAdvice) {
                            case 1: {
                                this.endPoint.setAvailability(true);
                                this.incSuccessfulTest();
                                bl = true;
                                continue block11;
                            }
                            case -1: {
                                this.endPoint.setAvailability(false);
                                this.incUnsuccessfulTest();
                                bl = true;
                                continue block11;
                            }
                            case 0: {
                                continue block11;
                            }
                            case -2: {
                                bl = true;
                            }
                        }
                    }
                } else {
                    this.lastAdvice = -2;
                }
                int n = HealthMonitorManagerImpl.this.sleepTimePolicy.getSleepTime(this);
                if (this.endPoint.isAvailable() && HealthMonitorManagerImpl.this.removeTaskPolicy.canRemove(this) && n >= 15000 || this.lastAdvice == -2) {
                    HealthMonitorManagerImpl.this.epTasks.remove(identity);
                }
                if (n > 0) {
                    HealthMonitorManagerImpl.this.sleeperThreadPool.RunInTimeOrder(this, n);
                } else {
                    HealthMonitorManagerImpl.this.sleeperThreadPool.RunAfterLast(this, -n);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "run: removing identity from epTasks");
                }
                HealthMonitorManagerImpl.this.epTasks.remove(identity);
            }
            this.setLastAccessedTimeStamp();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run", this.endPoint.isAvailable() ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public String toString() {
            String string = "EndPointMonitorTask@" + Integer.toHexString(System.identityHashCode(this));
            String string2 = this.endPoint.getClass().getName();
            string2 = string2.substring(string2.lastIndexOf(46) + 1) + "@" + Integer.toHexString(System.identityHashCode(this.endPoint));
            String string3 = this.endPoint.isAvailable() ? "" : "UN";
            return "[" + string3 + "available]" + string + ":" + string2 + ":" + this.endPoint.getIdentity();
        }
    }

    abstract class MonitorTask
    implements Runnable,
    MonitorTaskInfo {
        CFEndPoint cfEndPoint;
        EndPoint endPoint;
        int testCount;
        int lastAdvice;
        long stateChangedTimeStamp;
        long lastAccessedTimeStamp;
        ArrayList advisors;
        Map advisorsCache = Collections.synchronizedMap(new HashMap());

        MonitorTask(CFEndPoint cFEndPoint, EndPoint endPoint) {
            this.endPoint = endPoint;
            this.cfEndPoint = cFEndPoint;
            this.testCount = 0;
            this.lastAdvice = 0;
            this.stateChangedTimeStamp = 0L;
            this.advisors = null;
        }

        public EndPoint getEndPoint() {
            return this.endPoint;
        }

        public CFEndPoint getCFEndPoint() {
            return this.cfEndPoint;
        }

        public int getTestCount() {
            return this.testCount;
        }

        final void resetTestCount() {
            this.testCount = 0;
        }

        final void incSuccessfulTest() {
            if (this.testCount < 0) {
                this.testCount = 1;
                this.setStateChangedTimeStamp();
            } else if (this.testCount < Integer.MAX_VALUE) {
                ++this.testCount;
            }
        }

        final void incUnsuccessfulTest() {
            if (this.testCount > 0) {
                this.testCount = -1;
                this.setStateChangedTimeStamp();
            } else if (this.testCount > Integer.MIN_VALUE) {
                --this.testCount;
            }
        }

        public int getLastAdvice() {
            return this.lastAdvice;
        }

        public long getStateChangedTimeStamp() {
            return this.stateChangedTimeStamp;
        }

        long setStateChangedTimeStamp() {
            this.stateChangedTimeStamp = System.currentTimeMillis();
            return this.stateChangedTimeStamp;
        }

        public long getLastAccessedTimeStamp() {
            return this.lastAccessedTimeStamp;
        }

        long setLastAccessedTimeStamp() {
            this.lastAccessedTimeStamp = System.currentTimeMillis();
            return this.lastAccessedTimeStamp;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof MonitorTask) {
                bl = this.endPoint == ((MonitorTask)object).endPoint;
            }
            return bl;
        }
    }
}

