/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.classloader.ClassLoaderInstancePreDefinePlugin;
import com.ibm.websphere.classloader.ClassLoaderPlugin;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.classloader.ClassProviderListener;
import com.ibm.ws.classloader.CompoundEnumeration;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.classloader.SinglePathClassProvider;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ServerIdentityHelper;
import com.ibm.ws.util.PathUtils;
import com.ibm.wsspi.classloader.JIT_StubClassPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class CompoundClassLoader
extends SecureClassLoader
implements ClassProviderListener,
WsClassLoader {
    private static final TraceComponent tc;
    protected ClassLoader parent = null;
    protected String localClassPath = "";
    protected String[] nativelibpaths = new String[0];
    protected boolean delegate = false;
    protected String[] protectedPrefixes = null;
    protected SinglePathClassProvider[] providers = new SinglePathClassProvider[0];
    protected Vector reloadableParents = new Vector();
    protected HashSet badResources = new HashSet();
    protected Map codeSourcePermissions;
    protected static DynamicPolicy dynamicPolicy;
    protected ServerIdentityHelper serverIdentityHelper = null;
    private boolean cacheZipFiles;
    private List preDefinePlugins = null;
    private JIT_StubClassPlugin JIT_StubPlugin = null;
    public static ClassLoaderPlugin plugin;
    private static final ProtectionDomain svPD;

    public CompoundClassLoader(String[] stringArray, ClassLoader classLoader, boolean bl) {
        super(classLoader);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CompoundClassLoader this=" + this);
        }
        if (WSLauncher.isZOS()) {
            this.serverIdentityHelper = ServerIdentityHelper.getServerIdentityHelper();
        }
        this.parent = classLoader != null ? classLoader : CompoundClassLoader.getSystemClassLoader();
        this.delegate = bl;
        this.addPaths(stringArray);
        this.preDefinePlugins = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CompoundClassLoader");
        }
    }

    public CompoundClassLoader(String[] stringArray, ClassLoader classLoader, String[] stringArray2, boolean bl) {
        this(stringArray, classLoader, bl);
        this.protectedPrefixes = stringArray2;
    }

    protected CompoundClassLoader(CompoundClassLoader compoundClassLoader) {
        super(compoundClassLoader.getParent());
        this.parent = compoundClassLoader.parent;
        this.localClassPath = compoundClassLoader.localClassPath;
        this.nativelibpaths = compoundClassLoader.nativelibpaths;
        this.protectedPrefixes = compoundClassLoader.protectedPrefixes;
        this.delegate = compoundClassLoader.delegate;
        this.providers = compoundClassLoader.providers;
        this.reloadableParents = compoundClassLoader.reloadableParents;
        this.codeSourcePermissions = compoundClassLoader.codeSourcePermissions;
        this.serverIdentityHelper = compoundClassLoader.serverIdentityHelper;
        this.preDefinePlugins = new ArrayList(compoundClassLoader.preDefinePlugins);
    }

    void setCacheZipFiles(boolean bl) {
        this.cacheZipFiles = bl;
    }

    public void setDelegationMode(boolean bl) {
        this.delegate = bl;
    }

    public boolean getDelegationMode() {
        return this.delegate;
    }

    public CompoundClassLoader reload() {
        return this.reload(true);
    }

    public CompoundClassLoader reload(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reload this=" + this);
        }
        int n = this.providers.length;
        for (int i = 0; i < n; ++i) {
            this.providers[i].reload();
        }
        return new CompoundClassLoader(this);
    }

    public void dispose(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dispose this=" + this);
        }
        this.clearBadResourceList();
        int n = this.providers.length;
        for (int i = 0; i < n; ++i) {
            this.providers[i].dispose();
        }
        this.reloadableParents.clear();
        this.localClassPath = "";
        this.nativelibpaths = null;
        this.preDefinePlugins.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBadResourceList() {
        HashSet hashSet = this.badResources;
        synchronized (hashSet) {
            this.badResources.clear();
        }
    }

    public synchronized void addPaths(String[] stringArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addPaths paths='" + PathUtils.arrayToString(stringArray) + "'");
        }
        if (stringArray != null && stringArray.length != 0) {
            ArrayList<SinglePathClassProvider> arrayList = new ArrayList<SinglePathClassProvider>();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(SinglePathClassProvider.create(stringArray[i], this.cacheZipFiles));
            }
            this.addProviders(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addPaths complete this=" + this);
                Tr.debug(tc, "addPaths complete traversed=" + this.getClassPath());
            }
        }
    }

    public synchronized void addNativeLibPaths(String[] stringArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addNativeLibPaths native paths='" + PathUtils.arrayToString(stringArray) + "'");
        }
        if (stringArray != null && stringArray.length != 0) {
            String[] stringArray2 = this.nativelibpaths;
            this.nativelibpaths = new String[stringArray2.length + stringArray.length];
            System.arraycopy(stringArray2, 0, this.nativelibpaths, 0, stringArray2.length);
            System.arraycopy(stringArray, 0, this.nativelibpaths, stringArray2.length, stringArray.length);
        }
    }

    public void removePaths(String[] stringArray) {
        ArrayList<SinglePathClassProvider> arrayList = new ArrayList<SinglePathClassProvider>();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = this.providers.length - 1; n >= 0; --n) {
            for (n2 = stringArray.length - 1; n2 >= 0; --n2) {
                if (!this.providers[n].getPath().equals(stringArray[n2])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                arrayList.add(this.providers[n]);
                stringBuffer.append(File.pathSeparatorChar).append(this.providers[n].getPath());
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing path: " + this.providers[n].getPath());
            }
            this.providers[n].dispose();
            bl = false;
        }
        this.localClassPath = stringBuffer.length() > 0 ? stringBuffer.substring(1) : "";
        int n3 = arrayList.size();
        SinglePathClassProvider[] singlePathClassProviderArray = new SinglePathClassProvider[n3];
        singlePathClassProviderArray = arrayList.toArray(singlePathClassProviderArray);
        this.providers = singlePathClassProviderArray;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removePaths complete this=" + this);
            Tr.debug(tc, "removePaths complete traversed=" + this.getClassPath());
        }
    }

    protected void addProviders(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = this.providers.length;
        SinglePathClassProvider[] singlePathClassProviderArray = new SinglePathClassProvider[n + n2];
        StringBuffer stringBuffer = new StringBuffer();
        SinglePathClassProvider singlePathClassProvider = null;
        for (int i = 0; i < n; ++i) {
            singlePathClassProvider = (SinglePathClassProvider)arrayList.get(i);
            singlePathClassProviderArray[n2++] = singlePathClassProvider;
            stringBuffer.append(File.pathSeparatorChar).append(singlePathClassProvider.getPath());
        }
        if (stringBuffer.length() > 0) {
            this.localClassPath = this.localClassPath.length() == 0 ? stringBuffer.substring(1) : this.localClassPath.concat(stringBuffer.toString());
        }
        System.arraycopy(this.providers, 0, singlePathClassProviderArray, 0, this.providers.length);
        this.providers = singlePathClassProviderArray;
    }

    public void addClassProviderListener(ClassProviderListener classProviderListener) {
        this.reloadableParents.add(classProviderListener);
    }

    public void classLoadedFromFile(File file) {
        int n = this.reloadableParents.size();
        for (int i = 0; i < n; ++i) {
            ClassProviderListener classProviderListener = (ClassProviderListener)this.reloadableParents.elementAt(i);
            classProviderListener.classLoadedFromFile(file);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized Class loadClass(String var1_1, boolean var2_2) throws ClassNotFoundException {
        block21: {
            if (CompoundClassLoader.tc.isEntryEnabled()) {
                Tr.entry(CompoundClassLoader.tc, "loadClass name=" + var1_1 + " this=" + super.toString());
            }
            var3_3 = CompoundClassLoader.tc.isDebugEnabled();
            var4_4 = this.checkForSystemPrefix(var1_1);
            var5_5 = this.findLoadedClass(var1_1);
            var6_6 = this.delegate;
            if (!var6_6 && (var1_1.startsWith("java.") || var1_1.startsWith("[Ljava."))) {
                var6_6 = true;
            }
            if (var5_5 == null) {
                if (var6_6) {
                    try {
                        if (var4_4) {
                            throw new ClassNotFoundException(var1_1);
                        }
                        var5_5 = this.parent.loadClass(var1_1);
                        if (var3_3) {
                            Tr.debug(CompoundClassLoader.tc, "loaded " + var1_1 + " from parent");
                        }
                        break block21;
                    }
                    catch (ClassNotFoundException var7_7) {
                        var5_5 = this.findClass(var1_1, var6_6);
                        if (var3_3) {
                            Tr.debug(CompoundClassLoader.tc, "loaded " + var1_1 + " from this=" + this);
                        }
                        break block21;
                    }
                }
                var5_5 = this.findClass(var1_1, var6_6);
                if (var5_5 == null) {
                    if (var4_4) {
                        throw new ClassNotFoundException(var1_1);
                    }
                    try {
                        var5_5 = this.parent.loadClass(var1_1);
                        if (!var3_3) ** GOTO lbl42
                        Tr.debug(CompoundClassLoader.tc, "loaded " + var1_1 + " from parent");
                    }
                    catch (ClassNotFoundException var7_8) {
                        if (this.JIT_StubPlugin != null && var1_1.endsWith("_Stub")) {
                            var5_5 = this.JIT_StubPlugin.defineStubClass(var1_1);
                            if (var3_3 && var5_5 != null) {
                                Tr.debug(CompoundClassLoader.tc, "loaded " + var1_1 + " from JIT_StubClassPlugin");
                            }
                        }
                        if (var5_5 != null) ** GOTO lbl42
                        throw var7_8;
                    }
                } else if (var3_3) {
                    Tr.debug(CompoundClassLoader.tc, "loaded " + var1_1 + " from this=" + this);
                }
            }
        }
        var7_9 = null;
        if (var2_2 || var3_3) {
            var8_10 = var5_5;
            var7_9 = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return var8_10.getClassLoader();
                }
            });
        }
        if (var3_3) {
            Tr.debug(CompoundClassLoader.tc, "loaded " + var1_1 + " using classloader=" + var7_9);
        }
        if (var2_2 && var7_9 == this) {
            this.resolveClass(var5_5);
        }
        if (CompoundClassLoader.tc.isEntryEnabled()) {
            Tr.exit(CompoundClassLoader.tc, "loadClass");
        }
        return var5_5;
    }

    public synchronized Class defineApplicationClass(String string, byte[] byArray) {
        Class<?> clazz;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "defineApplicationClass: " + string);
        }
        if ((clazz = this.findLoadedClass(string)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "calling defineClass on this");
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length, svPD);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "class has already been loaded");
        }
        return clazz;
    }

    public void localResolveClass(Class clazz) {
        this.resolveClass(clazz);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        return this.findClass(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findClass name=" + string + " this=" + super.toString());
        }
        if ((clazz = this.findLoadedClass(string)) == null) {
            byte[] byArray = null;
            SinglePathClassProvider singlePathClassProvider = null;
            boolean bl2 = tc.isDebugEnabled();
            Object object = null;
            try {
                if (this.serverIdentityHelper != null) {
                    object = this.serverIdentityHelper.push();
                }
                int n = this.providers.length;
                for (int i = 0; i < n; ++i) {
                    byArray = this.providers[i].getClassBytes(string, this);
                    if (byArray == null) continue;
                    if (bl2) {
                        Tr.debug(tc, "class " + string + " found in " + this.providers[i]);
                    }
                    singlePathClassProvider = this.providers[i];
                    break;
                }
            }
            finally {
                if (object != null) {
                    this.serverIdentityHelper.pop(object);
                }
            }
            if (byArray == null) {
                if (!bl) {
                    return null;
                }
                if (this.JIT_StubPlugin != null && string.endsWith("_Stub") && (clazz = this.JIT_StubPlugin.defineStubClass(string)) != null) {
                    if (bl2) {
                        Tr.debug(tc, "loaded " + string + " from JIT_StubClassPlugin");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findClass");
                    }
                    return clazz;
                }
                throw new ClassNotFoundException(string);
            }
            if (plugin != null) {
                byte[] byArray2 = null;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    byArray2 = new byte[byArray.length];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                }
                byte[] byArray3 = plugin.preDefineApplicationClass(string, byArray);
                if (byArray2 != null) {
                    if (byArray3 != byArray) {
                        Tr.debug(tc, "class bytes replaced by " + plugin);
                    } else {
                        for (int i = 0; i < byArray.length; ++i) {
                            if (byArray[i] == byArray2[i]) continue;
                            Tr.debug(tc, "class bytes changed at offset " + i + " by " + plugin);
                            break;
                        }
                    }
                }
                byArray = byArray3;
            }
            clazz = this._defineClass(string, byArray, singlePathClassProvider);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findClass");
        }
        return clazz;
    }

    protected Class _defineClass(String string, byte[] byArray, SinglePathClassProvider singlePathClassProvider) {
        Object object;
        Object object2;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            object2 = string.substring(0, n);
            Package package_ = this.getPackage((String)object2);
            object = singlePathClassProvider.getManifest();
            if (package_ == null) {
                if (object != null) {
                    this.definePackage((String)object2, (Manifest)object, singlePathClassProvider.getURL());
                } else {
                    this.definePackage((String)object2, null, null, null, null, null, null, null);
                }
            } else if (System.getSecurityManager() != null) {
                boolean bl;
                URL uRL = singlePathClassProvider.getURL();
                if (package_.isSealed()) {
                    bl = package_.isSealed(uRL);
                } else {
                    boolean bl2 = bl = object == null || !this.isSealed((String)object2, (Manifest)object);
                }
                if (!bl) {
                    throw new SecurityException("sealing violation on package=" + package_.getName() + " at codesource=" + uRL);
                }
            }
        }
        object2 = new CodeSource(singlePathClassProvider.getURL(), (Certificate[])null);
        if (this.preDefinePlugins.size() > 0) {
            for (int i = 0; i < this.preDefinePlugins.size(); ++i) {
                object = (ClassLoaderInstancePreDefinePlugin)this.preDefinePlugins.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Transforming " + string + " by " + object.getClass().getName());
                }
                byArray = object.transformClass(string, byArray, (CodeSource)object2, this);
            }
        }
        return this.defineClass(string, byArray, 0, byArray.length, (CodeSource)object2);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String string) {
        URL uRL;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource", string);
        }
        if (this.badResources.contains(string)) {
            return null;
        }
        if (this.delegate) {
            uRL = this.parent.getResource(string);
            if (uRL == null) {
                uRL = this.findResource(string);
            }
        } else {
            uRL = this.findResource(string);
            if (uRL == null) {
                uRL = this.parent.getResource(string);
            }
        }
        if (uRL == null) {
            HashSet hashSet = this.badResources;
            synchronized (hashSet) {
                this.badResources.add(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource");
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL findResource(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findResource", new Object[]{string});
        }
        URL uRL = null;
        boolean bl = tc.isDebugEnabled();
        Object object = null;
        try {
            if (this.serverIdentityHelper != null) {
                object = this.serverIdentityHelper.push();
            }
            int n = this.providers.length;
            for (int i = 0; i < n; ++i) {
                uRL = this.providers[i].getResource(string);
                if (uRL == null) continue;
                if (bl) {
                    Tr.debug(tc, "resource " + string + " found in " + this.providers[i]);
                }
                break;
            }
        }
        finally {
            if (object != null) {
                this.serverIdentityHelper.pop(object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findResource");
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration findResources(String string) throws IOException {
        CompoundEnumeration compoundEnumeration = new CompoundEnumeration();
        boolean bl = tc.isDebugEnabled();
        Object object = null;
        try {
            if (this.serverIdentityHelper != null) {
                object = this.serverIdentityHelper.push();
            }
            int n = this.providers.length;
            for (int i = 0; i < n; ++i) {
                URL uRL;
                if (bl) {
                    Tr.debug(tc, "findResources: looking for resource " + string + " in " + this.providers[i]);
                }
                if ((uRL = this.providers[i].getResource(string)) == null) continue;
                compoundEnumeration.addCompoundElement(uRL);
            }
        }
        finally {
            if (object != null) {
                this.serverIdentityHelper.pop(object);
            }
        }
        return compoundEnumeration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceAsStream", string);
        }
        InputStream inputStream = null;
        if (this.badResources.contains(string)) {
            return null;
        }
        if (this.delegate) {
            inputStream = this.parent.getResourceAsStream(string);
            if (inputStream == null) {
                inputStream = this.localGetResourceAsStream(string);
            }
        } else {
            inputStream = this.localGetResourceAsStream(string);
            if (inputStream == null) {
                inputStream = this.parent.getResourceAsStream(string);
            }
        }
        if (inputStream == null) {
            HashSet hashSet = this.badResources;
            synchronized (hashSet) {
                this.badResources.add(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceAsStream is=" + inputStream);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream localGetResourceAsStream(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "localGetResourceAsStream", string);
        }
        InputStream inputStream = null;
        boolean bl = tc.isDebugEnabled();
        Object object = null;
        try {
            if (this.serverIdentityHelper != null) {
                object = this.serverIdentityHelper.push();
            }
            int n = this.providers.length;
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    Tr.debug(tc, "looking for resource " + string + " in " + this.providers[i]);
                }
                if ((inputStream = this.providers[i].getResourceAsStream(string)) == null) continue;
                if (bl) {
                    Tr.debug(tc, "resource " + string + " found in " + this.providers[i]);
                }
                break;
            }
        }
        finally {
            if (object != null) {
                this.serverIdentityHelper.pop(object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "localGetResourceAsStream is=" + inputStream);
        }
        return inputStream;
    }

    private boolean checkForSystemPrefix(String string) {
        if (this.protectedPrefixes != null) {
            int n = this.protectedPrefixes.length;
            for (int i = 0; i < n; ++i) {
                if (!string.startsWith(this.protectedPrefixes[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected String findLibrary(String string) {
        final String string2 = System.mapLibraryName(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "looking for library: " + string2);
        }
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    File file;
                    File file2;
                    int n;
                    int n2 = CompoundClassLoader.this.nativelibpaths.length;
                    for (n = 0; n < n2; ++n) {
                        file2 = new File(CompoundClassLoader.this.nativelibpaths[n]);
                        if (!file2.isDirectory() || !(file = new File(file2, string2)).exists()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "native library found: " + file.getPath());
                        }
                        return file.getPath();
                    }
                    n2 = CompoundClassLoader.this.providers.length;
                    for (n = 0; n < n2; ++n) {
                        file2 = new File(CompoundClassLoader.this.providers[n].getPath());
                        if (!file2.isDirectory() || !(file = new File(file2, string2)).exists()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "library found: " + file.getPath());
                        }
                        return file.getPath();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    public String getClassPath() {
        String string = null;
        String string2 = null;
        if (this.parent instanceof WsClassLoader) {
            string2 = ((WsClassLoader)((Object)this.parent)).getClassPath();
        } else if (this.parent instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)this.parent).getURLs();
            StringBuffer stringBuffer = new StringBuffer();
            int n = uRLArray.length;
            for (int i = 0; i < n; ++i) {
                if (!uRLArray[i].getProtocol().equals("file")) continue;
                stringBuffer.append(uRLArray[i].getFile() + File.pathSeparatorChar);
            }
            string2 = stringBuffer.toString();
        } else {
            string2 = System.getProperty("java.class.path");
        }
        string = string2 == null ? this.localClassPath : (this.localClassPath.length() == 0 ? string2 : (this.delegate ? string2 + File.pathSeparator + this.localClassPath : this.localClassPath + File.pathSeparator + string2));
        return string;
    }

    public CompoundClassLoader getCurrentClassLoader() {
        return this;
    }

    public String[] getPaths() {
        return this.localClassPath.split(File.pathSeparator);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(super.toString());
        stringBuffer.append("\n   Local ClassPath: ");
        stringBuffer.append(this.localClassPath);
        stringBuffer.append("\n   Delegation Mode: ");
        stringBuffer.append(this.delegate ? "PARENT_FIRST" : "PARENT_LAST");
        return stringBuffer.toString();
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = null;
        if (this.codeSourcePermissions != null) {
            permissionCollection = dynamicPolicy.getPermissions(codeSource, this.codeSourcePermissions);
        }
        if (permissionCollection == null) {
            permissionCollection = super.getPermissions(codeSource);
        }
        return permissionCollection;
    }

    public Map getCodeSourcePermissions() {
        return this.codeSourcePermissions;
    }

    public void setCodeSourcePermissions(Map map) {
        this.codeSourcePermissions = map;
        if (dynamicPolicy == null) {
            dynamicPolicy = DynamicPolicyFactory.getInstance();
        }
    }

    public boolean isAncestor(CompoundClassLoader compoundClassLoader) {
        CompoundClassLoader compoundClassLoader2;
        if (compoundClassLoader == this) {
            return true;
        }
        ClassLoader classLoader = this.getParent();
        if (classLoader instanceof ReloadableClassLoader && (compoundClassLoader2 = ((ReloadableClassLoader)classLoader).getCurrentClassLoader()).isAncestor(compoundClassLoader)) {
            return true;
        }
        return classLoader instanceof CompoundClassLoader && (compoundClassLoader2 = (CompoundClassLoader)classLoader).isAncestor(compoundClassLoader);
    }

    public void addPreDefinePlugin(ClassLoaderInstancePreDefinePlugin classLoaderInstancePreDefinePlugin) {
        int n = this.preDefinePlugins.indexOf(classLoaderInstancePreDefinePlugin);
        if (n != -1) {
            this.preDefinePlugins.remove(n);
        }
        this.preDefinePlugins.add(classLoaderInstancePreDefinePlugin);
    }

    public void removePreDefinePlugin(ClassLoaderInstancePreDefinePlugin classLoaderInstancePreDefinePlugin) {
        this.preDefinePlugins.remove(classLoaderInstancePreDefinePlugin);
    }

    public JIT_StubClassPlugin setJIT_StubClassPlugin(JIT_StubClassPlugin jIT_StubClassPlugin) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setJIT_StubClassPlugin : " + this.JIT_StubPlugin + " -> " + jIT_StubClassPlugin);
        }
        JIT_StubClassPlugin jIT_StubClassPlugin2 = this.JIT_StubPlugin;
        this.JIT_StubPlugin = jIT_StubClassPlugin;
        return jIT_StubClassPlugin2;
    }

    public JIT_StubClassPlugin getJIT_StubClassPlugin() {
        return this.JIT_StubPlugin;
    }

    static {
        Serializable serializable;
        tc = Tr.register(CompoundClassLoader.class, "Websphere ClassLoader", "com.ibm.ws.runtime.runtime");
        plugin = null;
        String string = System.getProperty("com.ibm.websphere.classloader.plugin");
        if (string != null) {
            block4: {
                try {
                    serializable = Class.forName(string, false, ExtClassLoader.getInstance());
                    plugin = (ClassLoaderPlugin)((Class)serializable).newInstance();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.classloader.CompoundClassLoader", "70");
                    throwable.printStackTrace();
                    if (!(throwable instanceof ExceptionInInitializerError)) break block4;
                    ((ExceptionInInitializerError)throwable).getException().printStackTrace();
                }
            }
            if (plugin != null) {
                Tr.info(tc, "WSVR0331I", string);
            }
        }
        serializable = new Permissions();
        ((PermissionCollection)serializable).add(new AllPermission());
        svPD = new ProtectionDomain(null, (PermissionCollection)serializable);
    }
}

