/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSGenerationContext;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryptPart;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryption;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryptPart;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryption;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignPart;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerifyPart;
import javax.security.auth.callback.CallbackHandler;

public abstract class WSSFactory {
    private static WSSFactory instance;

    public static WSSFactory getInstance() throws WSSException {
        instance = null;
        try {
            instance = (WSSFactory)Class.forName("com.ibm.ws.wssecurity.wssapi.WSSFactoryImpl").newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WSSException(illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new WSSException(instantiationException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WSSException(classNotFoundException.getMessage());
        }
        return instance;
    }

    public abstract WSSGenerationContext newWSSGenerationContext();

    public abstract WSSGenerationContext newWSSGenerationContext(String var1);

    public abstract WSSConsumingContext newWSSConsumingContext();

    public abstract WSSConsumingContext newWSSConsumingContext(String var1);

    public abstract WSSSignature newWSSSignature(SecurityToken var1);

    public abstract WSSSignPart newWSSSignPart();

    public abstract WSSEncryption newWSSEncryption(SecurityToken var1);

    public abstract WSSEncryption newWSSEncryption();

    public abstract WSSEncryptPart newWSSEncryptPart();

    public abstract WSSTimestamp newWSSTimestamp() throws WSSException;

    public abstract SecurityToken newSecurityToken(Class var1, CallbackHandler var2, String var3) throws WSSException;

    public abstract SecurityToken[] newSecurityTokens(Class[] var1, CallbackHandler var2, String var3) throws WSSException;

    public abstract SecurityToken newSecurityToken(Class var1, CallbackHandler var2) throws WSSException;

    public abstract SecurityToken[] newSecurityTokens(Class[] var1, CallbackHandler var2) throws WSSException;

    public abstract WSSVerification newWSSVerification(Class var1) throws WSSException;

    public abstract WSSVerification newWSSVerification(Class var1, CallbackHandler var2) throws WSSException;

    public abstract WSSVerification newWSSVerification(Class var1, CallbackHandler var2, String var3) throws WSSException;

    public abstract WSSVerifyPart newWSSVerifyPart();

    public abstract WSSDecryption newWSSDecryption(Class var1, CallbackHandler var2, String var3) throws WSSException;

    public abstract WSSDecryption newWSSDecryption(Class var1, CallbackHandler var2) throws WSSException;

    public abstract WSSDecryption newWSSDecryption(Class var1) throws WSSException;

    public abstract WSSDecryption newWSSDecryption();

    public abstract WSSDecryptPart newWSSDecryptPart();
}

