/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.token;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken;
import com.ibm.ws.wssecurity.util.SecurityContextTokenCache;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.axis2.jaxws.spi.BindingProvider;

public class SecurityContextTokenUtil {
    private static SecurityContextTokenCache _sctCache = null;
    private static final PrivilegedAction getCtxClassLoader = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public static SecurityContextToken getSecurityContextToken(javax.xml.ws.BindingProvider bindingProvider) {
        if (bindingProvider instanceof BindingProvider) {
            SecurityContextToken securityContextToken = SecurityContextTokenUtil.getSecurityContextTokenCache().getSecurityContextToken((BindingProvider)bindingProvider);
            return securityContextToken;
        }
        return null;
    }

    private static SecurityContextTokenCache getSecurityContextTokenCache() {
        if (_sctCache != null) {
            return _sctCache;
        }
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
        String string = "com.ibm.ws.wssecurity.platform.auth.SecurityContextTokenCacheImpl";
        try {
            _sctCache = classLoader != null ? (SecurityContextTokenCache)classLoader.loadClass(string).newInstance() : (SecurityContextTokenCache)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
        return _sctCache;
    }
}

