/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.UNTGenerateCallbackHandler;
import com.ibm.websphere.wssecurity.callbackhandler.X509GenerateCallback;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyStoreConfig;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CertStore;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509GenerateCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = -2223655857588374454L;
    private static final int TYPE_NONE = 0;
    private static final int TYPE_KEYSTORE = 1;
    private static final int TYPE_SPECIAL = 2;
    private int type;
    private boolean requestorCertificate;
    private boolean identityAssertion;
    private String storeRef;
    private String storePath;
    private String storeType;
    private char[] storePassword;
    private String alias;
    private char[] keyPassword;
    private String keyName;
    private List<CertStore> certStores;

    public X509GenerateCallbackHandler(Map<Object, Object> map) {
        this.type = 0;
        CallbackHandlerConfig callbackHandlerConfig = (CallbackHandlerConfig)map.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        if (callbackHandlerConfig != null) {
            Object object;
            Object object2;
            KeyStoreConfig keyStoreConfig = callbackHandlerConfig.getResolvingKeyStore();
            if (keyStoreConfig != null) {
                this.storeRef = keyStoreConfig.getKsRef();
                this.storePath = keyStoreConfig.getPath();
                this.storeType = keyStoreConfig.getType();
                object2 = keyStoreConfig.getPassword();
                char[] cArray = this.storePassword = object2 == null ? null : ((String)object2).toCharArray();
            }
            if ((object2 = callbackHandlerConfig.getKeyInformation()) != null) {
                this.alias = object2.getAlias();
                object = object2.getKeyPass();
                this.keyPassword = object == null ? null : ((String)object).toCharArray();
                this.keyName = object2.getName();
            }
            this.certStores = callbackHandlerConfig.getCertStores();
            object = callbackHandlerConfig.getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
            if (object != null) {
                this.identityAssertion = UNTGenerateCallbackHandler.isTrue(object.toString());
            }
            if ((object = callbackHandlerConfig.getProperties().get("com.ibm.wsspi.wssecurity.token.cert.useRequestorCert")) != null) {
                this.requestorCertificate = UNTGenerateCallbackHandler.isTrue(object.toString());
            }
        }
    }

    public X509GenerateCallbackHandler(String string, String string2, String string3, char[] cArray, String string4, char[] cArray2, String string5, List<CertStore> list) {
        this.type = 1;
        this.storeRef = string;
        this.storePath = string2;
        this.storeType = string3;
        this.storePassword = cArray;
        this.alias = string4;
        this.keyPassword = (char[])(cArray2 != null && cArray2.length != 0 ? cArray2 : null);
        this.keyName = string5;
        this.certStores = list;
    }

    public X509GenerateCallbackHandler(boolean bl, boolean bl2) {
        this.type = 2;
        this.requestorCertificate = bl;
        this.identityAssertion = bl2;
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (callbackArray == null || callbackArray.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        for (int i = 0; i < callbackArray.length; ++i) {
            Callback callback = callbackArray[i];
            if (!(callback instanceof X509GenerateCallback)) continue;
            X509GenerateCallback x509GenerateCallback = (X509GenerateCallback)callback;
            if (this.type == 0) {
                x509GenerateCallback.setKeyStoreReference(this.storeRef);
                x509GenerateCallback.setKeyStorePath(this.storePath);
                x509GenerateCallback.setKeyStoreType(this.storeType);
                x509GenerateCallback.setKeyStorePassword(this.storePassword);
                x509GenerateCallback.setAlias(this.alias);
                x509GenerateCallback.setKeyPassword(this.keyPassword);
                x509GenerateCallback.setKeyName(this.keyName);
                x509GenerateCallback.setCertStores(this.certStores);
                x509GenerateCallback.setUsedRequestorCertificate(this.requestorCertificate);
                x509GenerateCallback.setUsedIdentityAssertion(this.identityAssertion);
                continue;
            }
            if (this.type == 1) {
                x509GenerateCallback.setKeyStoreReference(this.storeRef);
                x509GenerateCallback.setKeyStorePath(this.storePath);
                x509GenerateCallback.setKeyStoreType(this.storeType);
                x509GenerateCallback.setKeyStorePassword(this.storePassword);
                x509GenerateCallback.setAlias(this.alias);
                x509GenerateCallback.setKeyPassword(this.keyPassword);
                x509GenerateCallback.setKeyName(this.keyName);
                x509GenerateCallback.setCertStores(this.certStores);
                continue;
            }
            if (this.type != 2) continue;
            x509GenerateCallback.setUsedRequestorCertificate(this.requestorCertificate);
            x509GenerateCallback.setUsedIdentityAssertion(this.identityAssertion);
        }
    }
}

