/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.X509ConsumeCallback;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyStoreConfig;
import java.io.IOException;
import java.io.Serializable;
import java.security.Provider;
import java.security.cert.PKIXBuilderParameters;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509ConsumeCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = 4652590475346979402L;
    private boolean existKeyStore;
    private boolean trustAnyCertificate;
    private String keyStoreRef;
    private String keyStorePath;
    private String keyStoreType;
    private char[] keyStorePassword;
    private String alias;
    private char[] keyPassword;
    private String keyName;
    private String trustAnchorPath;
    private String trustAnchorType;
    private char[] trustAnchorPassword;
    private List certStores;
    private PKIXBuilderParameters certPathParam;
    private Provider provider;

    public X509ConsumeCallbackHandler(Map<Object, Object> map) {
        this.existKeyStore = false;
        this.trustAnyCertificate = false;
        CallbackHandlerConfig callbackHandlerConfig = (CallbackHandlerConfig)map.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        if (callbackHandlerConfig != null) {
            Object object;
            this.trustAnyCertificate = callbackHandlerConfig.isTrustAnyCertificate();
            this.certStores = callbackHandlerConfig.getCertStores();
            this.certPathParam = callbackHandlerConfig.getPKIXBuilderParameters();
            this.provider = callbackHandlerConfig.getProvider();
            KeyStoreConfig keyStoreConfig = callbackHandlerConfig.getResolvingKeyStore();
            if (keyStoreConfig != null) {
                this.existKeyStore = true;
                this.keyStoreRef = keyStoreConfig.getKsRef();
                this.keyStorePath = keyStoreConfig.getPath();
                this.keyStoreType = keyStoreConfig.getType();
                object = keyStoreConfig.getPassword();
                char[] cArray = this.keyStorePassword = object == null ? null : ((String)object).toCharArray();
            }
            if ((object = callbackHandlerConfig.getKeyInformation()) != null) {
                this.alias = object.getAlias();
                this.keyName = object.getName();
                String string = object.getKeyPass();
                this.keyPassword = string == null ? null : string.toCharArray();
            }
        }
    }

    public X509ConsumeCallbackHandler(String string, String string2, String string3, char[] cArray, String string4, char[] cArray2, String string5, String string6, String string7, char[] cArray3, List list, Provider provider) {
        this.existKeyStore = true;
        this.trustAnyCertificate = false;
        this.keyStoreRef = string;
        this.keyStorePath = string2;
        this.keyStoreType = string3;
        this.keyStorePassword = cArray;
        this.alias = string4;
        this.keyPassword = (char[])(cArray2 != null && cArray2.length != 0 ? cArray2 : null);
        this.keyName = string5;
        this.trustAnchorPath = string6;
        this.trustAnchorType = string7;
        if (cArray3 != null && cArray3.length != 0) {
            this.trustAnchorPassword = cArray3;
        } else {
            this.keyPassword = null;
        }
        this.certStores = list;
        this.provider = provider;
    }

    public X509ConsumeCallbackHandler(String string, String string2, String string3, char[] cArray, String string4, char[] cArray2, String string5) {
        this.existKeyStore = true;
        this.trustAnyCertificate = true;
        this.keyStoreRef = string;
        this.keyStorePath = string2;
        this.keyStoreType = string3;
        this.keyStorePassword = cArray;
        this.alias = string4;
        this.keyPassword = (char[])(cArray2 != null && cArray2.length != 0 ? cArray2 : null);
        this.keyName = string5;
    }

    public X509ConsumeCallbackHandler(String string, String string2, char[] cArray, List list, Provider provider) {
        this.existKeyStore = false;
        this.trustAnyCertificate = false;
        this.trustAnchorPath = string;
        this.trustAnchorType = string2;
        this.trustAnchorPassword = cArray;
        this.certStores = list;
        this.provider = provider;
    }

    public X509ConsumeCallbackHandler() {
        this.existKeyStore = false;
        this.trustAnyCertificate = true;
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (callbackArray == null || callbackArray.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        for (int i = 0; i < callbackArray.length; ++i) {
            Callback callback = callbackArray[i];
            if (!(callback instanceof X509ConsumeCallback)) continue;
            X509ConsumeCallback x509ConsumeCallback = (X509ConsumeCallback)callback;
            x509ConsumeCallback.setExistKeyStore(this.existKeyStore);
            x509ConsumeCallback.setKeyStoreReference(this.keyStoreRef);
            x509ConsumeCallback.setKeyStorePath(this.keyStorePath);
            x509ConsumeCallback.setKeyStoreType(this.keyStoreType);
            x509ConsumeCallback.setKeyStorePassword(this.keyStorePassword);
            x509ConsumeCallback.setAlias(this.alias);
            x509ConsumeCallback.setKeyPassword(this.keyPassword);
            x509ConsumeCallback.setKeyName(this.keyName);
            x509ConsumeCallback.setTrustAnyCertificate(this.trustAnyCertificate);
            x509ConsumeCallback.setTrustAnchorPath(this.trustAnchorPath);
            x509ConsumeCallback.setTrustAnchorType(this.trustAnchorType);
            x509ConsumeCallback.setTrustAnchorPassword(this.trustAnchorPassword);
            x509ConsumeCallback.setCertStores(this.certStores);
            x509ConsumeCallback.setCertPathParameter(this.certPathParam);
            x509ConsumeCallback.setProvider(this.provider);
        }
    }
}

