/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wssecurity.callbackhandler;

import com.ibm.websphere.wssecurity.callbackhandler.UNTGenerateCallback;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UNTGenerateCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = 3486899256146086776L;
    private String userid;
    private char[] password;
    private boolean identityAssertion;
    private boolean runAsSubject;
    private boolean sendRealm;
    private boolean nonce;
    private boolean createdTimestamp;
    private static final String[] TRUE_VALUES = new String[]{"yes", "on", "true", "1"};

    public static boolean isTrue(String string) {
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < TRUE_VALUES.length; ++i) {
                if (!TRUE_VALUES[i].equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return bl;
    }

    public UNTGenerateCallbackHandler(Map<Object, Object> map) {
        CallbackHandlerConfig callbackHandlerConfig = (CallbackHandlerConfig)map.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        if (callbackHandlerConfig != null) {
            this.userid = callbackHandlerConfig.getUserId();
            this.password = callbackHandlerConfig.getUserPassword();
            Object object = callbackHandlerConfig.getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
            if (object != null) {
                this.identityAssertion = UNTGenerateCallbackHandler.isTrue(object.toString());
            }
            if ((object = callbackHandlerConfig.getProperties().get(Constants.WSSECURITY_USE_RUNASIDENTITY)) != null) {
                this.runAsSubject = UNTGenerateCallbackHandler.isTrue(object.toString());
            }
            if ((object = callbackHandlerConfig.getProperties().get("com.ibm.wsspi.wssecurity.token.IDAssertion.sendRealm")) != null) {
                this.sendRealm = UNTGenerateCallbackHandler.isTrue(object.toString());
            }
            if ((object = callbackHandlerConfig.getProperties().get(Constants.WSSECURITY_ADD_NONCE)) != null) {
                this.nonce = UNTGenerateCallbackHandler.isTrue(object.toString());
            }
            if ((object = callbackHandlerConfig.getProperties().get(Constants.WSSECURITY_ADD_TIMESTAMP)) != null) {
                this.createdTimestamp = UNTGenerateCallbackHandler.isTrue(object.toString());
            }
        }
    }

    public UNTGenerateCallbackHandler(String string, String string2) {
        this.userid = string;
        this.password = string2 == null ? null : string2.toCharArray();
        this.identityAssertion = false;
        this.runAsSubject = false;
        this.sendRealm = false;
        this.nonce = false;
        this.createdTimestamp = false;
    }

    public UNTGenerateCallbackHandler(String string, String string2, boolean bl, boolean bl2) {
        this.userid = string;
        this.password = string2 == null ? null : string2.toCharArray();
        this.identityAssertion = false;
        this.runAsSubject = false;
        this.sendRealm = false;
        this.nonce = bl;
        this.createdTimestamp = bl2;
    }

    public UNTGenerateCallbackHandler(boolean bl, boolean bl2) {
        this.userid = null;
        this.password = null;
        this.identityAssertion = false;
        this.runAsSubject = bl;
        this.sendRealm = bl2;
        this.nonce = false;
        this.createdTimestamp = false;
    }

    public UNTGenerateCallbackHandler(boolean bl) {
        this.userid = null;
        this.password = null;
        this.identityAssertion = bl;
        this.runAsSubject = false;
        this.sendRealm = false;
        this.nonce = false;
        this.createdTimestamp = false;
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (callbackArray == null || callbackArray.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        for (int i = 0; i < callbackArray.length; ++i) {
            Callback callback = callbackArray[i];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.userid);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password);
                continue;
            }
            if (!(callback instanceof UNTGenerateCallback)) continue;
            ((UNTGenerateCallback)callback).setUsedIdentityAssertion(this.identityAssertion);
            ((UNTGenerateCallback)callback).setUsedRunAsSubject(this.runAsSubject);
            ((UNTGenerateCallback)callback).setSentRelm(this.sendRealm);
            ((UNTGenerateCallback)callback).setNonce(this.nonce);
            ((UNTGenerateCallback)callback).setCreatedTimestamp(this.createdTimestamp);
        }
    }
}

