/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReference;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.integration.Registry;
import java.rmi.Remote;
import javax.xml.namespace.QName;

public abstract class EndpointReferenceManager {
    private static final String CLASSNAME = "com.ibm.websphere.wsaddressing.EndpointReferenceManager";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointReferenceManager.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    protected static EndpointReferenceManager _endpointReferenceManager = null;
    private static final String IMPL_CLASSNAME = "com.ibm.ws.wsaddressing.EndpointReferenceManagerImpl";

    protected abstract EndpointReference createConcreteEndpointReference(QName var1, String var2) throws EndpointReferenceCreationException;

    protected abstract EndpointReference createConcreteEndpointReference(QName var1, String var2, Remote var3) throws EndpointReferenceCreationException;

    protected abstract String getConcreteReferenceParameterFromMessageContext(QName var1) throws ReferenceParameterCreationException;

    protected static EndpointReferenceManager getEPRManager() {
        return _endpointReferenceManager;
    }

    public static EndpointReference createEndpointReference(QName qName, String string) throws EndpointReferenceCreationException {
        EndpointReference endpointReference = null;
        if (EndpointReferenceManager.getEPRManager() != null) {
            endpointReference = EndpointReferenceManager.getEPRManager().createConcreteEndpointReference(qName, string);
        }
        return endpointReference;
    }

    public static EndpointReference createEndpointReference(QName qName, String string, Remote remote) throws EndpointReferenceCreationException {
        EndpointReference endpointReference = null;
        if (EndpointReferenceManager.getEPRManager() != null) {
            endpointReference = EndpointReferenceManager.getEPRManager().createConcreteEndpointReference(qName, string, remote);
        }
        return endpointReference;
    }

    public static String getReferenceParameterFromMessageContext(QName qName) throws ReferenceParameterCreationException {
        String string = Registry.getCombinedReferenceParameterReader().getReferenceParameterFromMessageContext(qName);
        if (string == null && EndpointReferenceManager.getEPRManager() != null) {
            string = EndpointReferenceManager.getEPRManager().getConcreteReferenceParameterFromMessageContext(qName);
        }
        return string;
    }

    private static void traceAndFFDCException(Exception exception) {
        String string = exception.getClass().getName();
        String string2 = exception.getMessage();
        Object[] objectArray = new Object[]{string, string2};
        String string3 = "Caught a " + string + ": " + string2 + " when trying to create a new concrete EndpointReferenceManager instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, string3);
        FFDCFilter.processException(exception, CLASSNAME, "1:1.23:288");
    }

    static {
        EndpointReferenceManager endpointReferenceManager = null;
        try {
            endpointReferenceManager = (EndpointReferenceManager)Class.forName(IMPL_CLASSNAME).newInstance();
        }
        catch (InstantiationException instantiationException) {
            EndpointReferenceManager.traceAndFFDCException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            EndpointReferenceManager.traceAndFFDCException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            EndpointReferenceManager.traceAndFFDCException(classNotFoundException);
        }
        _endpointReferenceManager = endpointReferenceManager;
    }
}

