/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;

public class SSLSocketFactory
extends javax.net.ssl.SSLSocketFactory {
    private static final TraceComponent tc = Tr.register(SSLSocketFactory.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    protected Properties props;
    private javax.net.ssl.SSLSocketFactory default_factory = null;
    private javax.net.ssl.SSLSocketFactory factory = null;
    protected boolean default_constructor = true;
    private static SSLSocketFactory thisClass = null;

    public SSLSocketFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLSocketFactory(1)");
        }
        try {
            HashMap hashMap = new HashMap();
            Map map = JSSEHelper.getInstance().getOutboundConnectionInfo();
            this.props = SSLConfigManager.getInstance().getDefaultSystemProperties(true);
            if (this.props == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting default SSL properties from WebSphere configuration.");
                }
                this.props = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting javax.net.ssl.* SSL System properties.");
                }
                this.default_constructor = false;
            }
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLSocketFactory(1)");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLSocketFactory exception getting default SSL properties.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor", "100", this);
            this.props = null;
        }
    }

    public SSLSocketFactory(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLSocketFactory(2)", new Object[]{string});
        }
        try {
            this.default_constructor = false;
            HashMap hashMap = new HashMap();
            Map map = JSSEHelper.getInstance().getOutboundConnectionInfo();
            this.props = JSSEHelper.getInstance().getProperties(string, hashMap, null);
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLSocketFactory(2)");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLSocketFactory exception getting SSL properties from alias.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor(alias)", "137", this);
            this.props = null;
        }
    }

    public SSLSocketFactory(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLSocketFactory(3)");
        }
        try {
            this.default_constructor = false;
            this.props = properties;
            HashMap hashMap = new HashMap();
            Map map = JSSEHelper.getInstance().getOutboundConnectionInfo();
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLSocketFactory(3)");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLSocketFactory exception getting SSL properties from properties.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor(sslprops)", "174", this);
            this.props = null;
        }
    }

    public SSLSocketFactory(String string, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLSocketFactory(4)", new Object[]{string, map});
        }
        try {
            this.default_constructor = false;
            this.props = JSSEHelper.getInstance().getProperties(string, map, null);
            this.default_factory = JSSEHelper.getInstance().getSSLSocketFactory(map, this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLSocketFactory(4)");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLSocketFactory exception getting SSL properties from selections.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.constructor(alias, dynamicSelectionInfo, endPointName)", "213", this);
            this.props = null;
        }
    }

    public static SocketFactory getDefault() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefault");
        }
        if (thisClass == null) {
            try {
                thisClass = new SSLSocketFactory();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLSocketFactory exception getting default socket factory.", new Object[]{exception});
                }
                FFDCFilter.processException(exception, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.getDefault", "236");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefault");
        }
        return thisClass;
    }

    public String[] getDefaultCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultCipherSuites");
        }
        return this.default_factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedCipherSuites");
        }
        return this.default_factory.getSupportedCipherSuites();
    }

    public Socket createSocket() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(0)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(0)");
        }
        return this.default_factory.createSocket();
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(1)", new Object[]{socket, string, new Integer(n), new Boolean(bl)});
        }
        SSLSocket sSLSocket = null;
        Properties properties = this.props;
        try {
            HashMap<String, String> hashMap = JSSEHelper.getInstance().getOutboundConnectionInfo();
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                hashMap.put("com.ibm.ssl.direction", "outbound");
                hashMap.put("com.ibm.ssl.remoteHost", string);
                hashMap.put("com.ibm.ssl.remotePort", Integer.toString(n));
            }
            String string2 = (String)hashMap.get("com.ibm.ssl.endPointName");
            if (this.default_constructor || string2 != null && string2.equals("ADMIN_SOAP")) {
                properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, properties);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(1)", "333", this);
            this.factory = this.default_factory;
        }
        sSLSocket = (SSLSocket)this.factory.createSocket(socket, string, n, bl);
        sSLSocket = SSLConfigManager.getInstance().setCipherListOnSocket(properties, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(1)");
        }
        return sSLSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(2)", new Object[]{inetAddress, new Integer(n)});
        }
        SSLSocket sSLSocket = null;
        Properties properties = this.props;
        try {
            HashMap<String, String> hashMap;
            String string = null;
            if (inetAddress != null) {
                try {
                    string = inetAddress.getHostName();
                    if (string == null) {
                        string = inetAddress.getCanonicalHostName();
                    }
                }
                catch (Throwable throwable) {
                    string = inetAddress.getHostAddress();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting hostname from socket.", new Object[]{throwable});
                    }
                    FFDCFilter.processException(throwable, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(2)", "400", this);
                }
            }
            if ((hashMap = JSSEHelper.getInstance().getOutboundConnectionInfo()) == null) {
                hashMap = new HashMap<String, String>();
                hashMap.put("com.ibm.ssl.direction", "outbound");
                hashMap.put("com.ibm.ssl.remoteHost", string);
                hashMap.put("com.ibm.ssl.remotePort", Integer.toString(n));
            }
            String string2 = (String)hashMap.get("com.ibm.ssl.endPointName");
            if (this.default_constructor || string2 != null && string2.equals("ADMIN_SOAP")) {
                properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, properties);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(2)", "410", this);
            this.factory = this.default_factory;
        }
        sSLSocket = (SSLSocket)this.factory.createSocket(inetAddress, n);
        sSLSocket = SSLConfigManager.getInstance().setCipherListOnSocket(properties, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(2)");
        }
        return sSLSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(3)", new Object[]{inetAddress, new Integer(n), inetAddress2, new Integer(n2)});
        }
        SSLSocket sSLSocket = null;
        Properties properties = this.props;
        try {
            HashMap<String, String> hashMap;
            String string = null;
            if (inetAddress != null) {
                try {
                    string = inetAddress.getHostName();
                    if (string == null) {
                        string = inetAddress.getCanonicalHostName();
                    }
                }
                catch (Throwable throwable) {
                    string = inetAddress.getHostAddress();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting hostname from socket.", new Object[]{throwable});
                    }
                    FFDCFilter.processException(throwable, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(3)", "464", this);
                }
            }
            if ((hashMap = JSSEHelper.getInstance().getOutboundConnectionInfo()) == null) {
                hashMap = new HashMap<String, String>();
                hashMap.put("com.ibm.ssl.direction", "outbound");
                hashMap.put("com.ibm.ssl.remoteHost", string);
                hashMap.put("com.ibm.ssl.remotePort", Integer.toString(n));
            }
            String string2 = (String)hashMap.get("com.ibm.ssl.endPointName");
            if (this.default_constructor || string2 != null && string2.equals("ADMIN_SOAP")) {
                properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, properties);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(3)", "494", this);
            this.factory = this.default_factory;
        }
        sSLSocket = (SSLSocket)this.factory.createSocket(inetAddress, n, inetAddress2, n2);
        sSLSocket = SSLConfigManager.getInstance().setCipherListOnSocket(properties, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(3)");
        }
        return sSLSocket;
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(4)", new Object[]{string, new Integer(n)});
        }
        SSLSocket sSLSocket = null;
        Properties properties = this.props;
        try {
            HashMap<String, String> hashMap = JSSEHelper.getInstance().getOutboundConnectionInfo();
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                hashMap.put("com.ibm.ssl.direction", "outbound");
                hashMap.put("com.ibm.ssl.remoteHost", string);
                hashMap.put("com.ibm.ssl.remotePort", Integer.toString(n));
            }
            String string2 = (String)hashMap.get("com.ibm.ssl.endPointName");
            if (this.default_constructor || string2 != null && string2.equals("ADMIN_SOAP")) {
                properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, properties);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(4)", "558", this);
            this.factory = this.default_factory;
        }
        sSLSocket = (SSLSocket)this.factory.createSocket(string, n);
        sSLSocket = SSLConfigManager.getInstance().setCipherListOnSocket(properties, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(4), not null");
        }
        return sSLSocket;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSocket(5)", new Object[]{string, new Integer(n), inetAddress, new Integer(n2)});
        }
        SSLSocket sSLSocket = null;
        Properties properties = this.props;
        try {
            HashMap<String, String> hashMap = JSSEHelper.getInstance().getOutboundConnectionInfo();
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                hashMap.put("com.ibm.ssl.direction", "outbound");
                hashMap.put("com.ibm.ssl.remoteHost", string);
                hashMap.put("com.ibm.ssl.remotePort", Integer.toString(n));
            }
            String string2 = (String)hashMap.get("com.ibm.ssl.endPointName");
            if (this.default_constructor || string2 != null && string2.equals("ADMIN_SOAP")) {
                properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            }
            this.factory = JSSEHelper.getInstance().getSSLSocketFactory(hashMap, properties);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLSocketFactory.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.ssl.protocol.SSLSocketFactory.createSocket(5)", "622", this);
            this.factory = this.default_factory;
        }
        sSLSocket = (SSLSocket)this.factory.createSocket(string, n, inetAddress, n2);
        sSLSocket = SSLConfigManager.getInstance().setCipherListOnSocket(properties, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSocket(5)");
        }
        return sSLSocket;
    }
}

