/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.response;

import com.ibm.websphere.servlet.response.DateHeaderField;
import com.ibm.websphere.servlet.response.HeaderField;
import com.ibm.websphere.servlet.response.HeaderFieldNames;
import com.ibm.websphere.servlet.response.IntHeaderField;
import com.ibm.websphere.servlet.response.NilHeaderField;
import com.ibm.websphere.servlet.response.StringHeaderField;
import java.io.Serializable;
import java.util.Enumeration;
import javax.servlet.http.HttpServletResponse;

class StoredHeader
implements Serializable {
    private static final long serialVersionUID = 3905521588232138806L;
    private HeaderField _field = NilHeaderField.instance();
    private int _size;

    public Enumeration getHeaderNames() {
        return new HeaderFieldNames(this._field);
    }

    public String getHeader(String string) {
        HeaderField headerField = this.getHeaderField(string);
        if (headerField != null) {
            return headerField.getStringValue();
        }
        return null;
    }

    public int getIntHeader(String string) {
        HeaderField headerField = this.getHeaderField(string);
        if (headerField != null) {
            return headerField.getIntValue();
        }
        return -1;
    }

    public long getDateHeader(String string) {
        HeaderField headerField = this.getHeaderField(string);
        if (headerField != null) {
            return headerField.getDateValue();
        }
        return -1L;
    }

    public boolean containsHeader(String string) {
        return this.getHeaderField(string) != null;
    }

    public synchronized void setHeader(String string, String string2) {
        HeaderField headerField = this.getHeaderField(string);
        if (headerField != null) {
            headerField.setStringValue(string2);
        } else {
            this._field = new StringHeaderField(string, string2, this._field);
            ++this._size;
        }
    }

    public synchronized void setIntHeader(String string, int n) {
        HeaderField headerField = this.getHeaderField(string);
        if (headerField != null) {
            headerField.setIntValue(n);
        } else {
            this._field = new IntHeaderField(string, n, this._field);
            ++this._size;
        }
    }

    public synchronized void setDateHeader(String string, long l) {
        HeaderField headerField = this.getHeaderField(string);
        if (headerField != null) {
            headerField.setDateValue(l);
        } else {
            this._field = new DateHeaderField(string, l, this._field);
            ++this._size;
        }
    }

    public int getSize() {
        return this._size;
    }

    public void transferHeader(HttpServletResponse httpServletResponse) {
        this._field.transferHeader(httpServletResponse);
    }

    private HeaderField getHeaderField(String string) {
        String string2 = string.toLowerCase();
        HeaderField headerField = this._field;
        while (!headerField.isNil()) {
            if (headerField.getName().toLowerCase().equals(string2)) {
                return headerField;
            }
            if (headerField.hasMoreFields()) {
                headerField = headerField.getNextField();
                continue;
            }
            return null;
        }
        return null;
    }
}

