/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth.callback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSIdentityCallback;
import com.ibm.wsspi.security.auth.callback.WSProtocolPolicyCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class WSCallbackHandlerImpl
implements CallbackHandler {
    private String userName;
    private String realm;
    private String password;
    private byte[] credToken;
    private Map appContext;
    private static final TraceComponent tc = Tr.register(WSCallbackHandlerImpl.class, null, "com.ibm.ejs.resources.security");

    public WSCallbackHandlerImpl(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandlerImpl(userName = \"" + string + "\", password = \"********\")");
        }
        this.userName = string;
        this.password = string2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandlerImpl(userName, password)");
        }
    }

    public WSCallbackHandlerImpl(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandlerImpl(userName = \"" + string + "\", password = \"********\", realmName = \"" + string2 + "\")");
        }
        this.userName = string;
        this.password = string3;
        this.realm = string2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandlerImpl(userName, password)");
        }
    }

    public WSCallbackHandlerImpl(String string, String string2, String string3, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandlerImpl(userName = \"" + string + "\", password = \"********\", realmName = \"" + string2 + "\", appContext = \"" + map + "\")");
        }
        this.userName = string;
        this.password = string3;
        this.realm = string2;
        this.appContext = map;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandlerImpl(userName, password)");
        }
    }

    public WSCallbackHandlerImpl(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCallbackHandlerImpl(credToken)");
        }
        this.credToken = CredentialsHelper.copyCredToken(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCallbackHandlerImpl(credToken)");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        int n = 0;
        if (callbackArray == null || (n = callbackArray.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(callbacks)");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(callbackArray[i].getClass().getName());
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
            Tr.entry(tc, "handle(callbacks = \"" + stringBuffer.toString() + "\")");
        }
        for (int i = 0; i < n; ++i) {
            Callback callback = callbackArray[i];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.userName);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password == null ? null : this.password.toCharArray());
                continue;
            }
            if (callback instanceof WSCredTokenCallbackImpl) {
                ((WSCredTokenCallbackImpl)callback).setCredToken(this.credToken);
                continue;
            }
            if (callback instanceof WSRealmNameCallbackImpl) {
                ((WSRealmNameCallbackImpl)callback).setRealmName(this.realm);
                continue;
            }
            if (callback instanceof WSAppContextCallback) {
                ((WSAppContextCallback)callback).setContext(this.appContext);
                continue;
            }
            if (callback instanceof WSTokenHolderCallback || callback instanceof WSServletRequestCallback || callback instanceof WSServletResponseCallback || callback instanceof WSIdentityCallback || callback instanceof WSProtocolPolicyCallback || callback instanceof WSX509CertificateChainCallback) continue;
            throw new UnsupportedCallbackException(callback, "Unsupported callback: " + callback.getClass().getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks)");
        }
    }
}

