/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.filetransfer.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.websphere.management.repository.RepositoryTempInputStream;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.repository.TempFileInputStream;
import com.ibm.ws.util.ImplFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FileDownloadInputStream
extends RepositoryTempInputStream
implements Serializable {
    private static final long serialVersionUID = 6521346973672823614L;
    private boolean isInputStreamDeserialized = false;
    private static TraceComponent tc = Tr.register(FileDownloadInputStream.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    FileTransferOptions options = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
    FileTransferConfig ftConfig;

    public FileDownloadInputStream() {
        this.options.setCompress(true);
        this.options.setDeleteSourceOnCompletion(true);
    }

    public FileDownloadInputStream(File file) {
        this();
        this.tempfile = file;
    }

    public FileTransferOptions getOptions() {
        return this.options;
    }

    public void setOptions(FileTransferOptions fileTransferOptions) {
        this.options = fileTransferOptions;
    }

    public FileTransferConfig getFileTransferConfig() {
        return this.ftConfig;
    }

    public void setFileTransferConfig(FileTransferConfig fileTransferConfig) {
        this.ftConfig = fileTransferConfig;
    }

    public void setCompress(boolean bl) {
        this.options.setCompress(bl);
    }

    public void setDeleteSourceOnCompletion(boolean bl) {
        this.options.setDeleteSourceOnCompletion(bl);
    }

    public boolean isCompress() {
        return this.options.isCompress();
    }

    public boolean isDeleteSourceOnCompletion() {
        return this.options.isDeleteSourceOnCompletion();
    }

    public void connect() throws IOException {
        Object object;
        try {
            if (this.remoteStream == null) {
                if (AdminHelper.getPlatformHelper().isServantJvm()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "FileDownload: Servant", this.tempfile);
                    }
                    this.remoteStream = new TempFileInputStream(this.tempfile);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "FileDownload: Remote Client", this.srcPath);
                    }
                    object = (FileTransferClient)ImplFactory.loadImplFromKey(FileTransferClient.class);
                    object.setFileTransferConfig(this.ftConfig);
                    this.remoteStream = object.downloadFile(this.srcPath, this.options);
                }
            }
        }
        catch (TransferFailedException transferFailedException) {
            FFDCFilter.processException((Throwable)transferFailedException, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.connect", "203", this);
            throw new IOException(transferFailedException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.connect", "204", this);
            throw new IOException(exception.getMessage());
        }
        if (this.remoteStream == null) {
            object = new IOException("Failed to download file: " + this.srcPath);
            FFDCFilter.processException((Throwable)object, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.connect", "205", this);
            throw object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            if (this.remoteStream != null) {
                this.remoteStream.close();
            }
            objectOutputStream.defaultWriteObject();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.writeObject", "317", this);
            Tr.service(tc, "ADFS0119", iOException);
            throw iOException;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
            this.isInputStreamDeserialized = true;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.readObject", "330", this);
            Tr.service(tc, "ADFS0119", iOException);
            throw iOException;
        }
    }

    public InputStream getStream() throws FileNotFoundException {
        Tr.entry(tc, "Entering FileDownloadInputStream.getStream ");
        try {
            if (this.isInputStreamDeserialized) {
                this.connect();
            } else {
                super.getStream();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream.getStream", "151", this);
            if (throwable instanceof FileNotFoundException) {
                throw (FileNotFoundException)throwable;
            }
            throw new FileNotFoundException("File download failed: " + throwable.toString());
        }
        Tr.exit(tc, "Exiting FileDownloadInputStream.getStream ");
        return this.remoteStream;
    }
}

