/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandHistory;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.RequiredParameterNotFoundException;
import com.ibm.websphere.management.cmdframework.UploadFile;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataFactory;
import com.ibm.websphere.management.cmdframework.commanddata.GenericObjectValue;
import com.ibm.websphere.management.cmdframework.commanddata.ObjectValue;
import com.ibm.websphere.management.cmdframework.commanddata.UserData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadataFactory;
import com.ibm.websphere.management.cmdframework.commandmetadata.CustomProperties;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.provider.CmdNotificationHandler;
import com.ibm.websphere.management.cmdframework.provider.CommandNotification;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.LocalCommandMgr;
import com.ibm.ws.management.cmdframework.impl.RemoteCommandMgr;
import com.ibm.ws.management.cmdframework.impl.ServerCommandMgr;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSession;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSessionMgr;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public abstract class AbstractAdminCommand
extends AbstractCommand
implements AdminCommand {
    private static TraceComponent tc = Tr.register(AbstractAdminCommand.class, "AbstractAdminCommand", "com.ibm.websphere.management.resources.cmdframework");
    public static final String ASYNC_CUSTOM_TAG = "async";
    public static final String PRIVATE_CUSTOM_TAG = "private";
    private CommandMetadata metadata;
    private CommandData commandData = null;
    private CommandResult cmdResult = null;
    protected CmdNotificationHandler cnh;
    protected TaskCommandSession asyncCmdSession;
    private static HashMap scriptGenerators = new HashMap();

    public AbstractAdminCommand(CommandMetadata commandMetadata) {
        this(commandMetadata, null);
    }

    public AbstractAdminCommand(CommandData commandData) throws CommandNotFoundException {
        this(AbstractAdminCommand.getCommandMetadata(commandData.getName()), commandData);
    }

    public static CommandMetadata getCommandMetadata(String string) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMetadata", string);
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandMetadata");
            }
            return CommandMgr.getCommandMgr().getCommandMetadata(string);
        }
        catch (CommandNotFoundException commandNotFoundException) {
            throw commandNotFoundException;
        }
        catch (ConnectorException connectorException) {
            return null;
        }
        catch (CommandException commandException) {
            return null;
        }
    }

    private AbstractAdminCommand(CommandMetadata commandMetadata, CommandData commandData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AbstractAdminCommand", new Object[]{commandMetadata, commandData});
        }
        this.metadata = commandMetadata;
        this.setCommandData(commandData);
        if (this.commandData == null) {
            this.commandData = this.initCommandData();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "commandData", this.commandData);
        }
        this.commandData.setName(this.metadata.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AbstractAdminCommand");
        }
    }

    private void setCommandData(CommandData commandData) {
        this.commandData = commandData;
        if (this.commandData != null) {
            Object object;
            UserData userData = this.commandData.getUserData();
            if (userData != null && (object = this.commandData.getUserData().getWorkspaceId()) != null) {
                this.setConfigSession(new Session((String)object, true));
            }
            object = this.getCommandMetadata();
            EList eList = object.getParameters();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                String string = ((ParameterMetadata)iterator.next()).getName();
                if (this.isTable()) {
                    for (int i = 0; i < this.getCommandData().getCmdParams().size(); ++i) {
                        try {
                            Object object2 = this.getParameter(string, i);
                            if (object2 == null) continue;
                            this.setParameter(string, object2, i);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                try {
                    Object object3 = this.getParameter(string);
                    if (object3 == null) continue;
                    this.setParameter(string, object3);
                }
                catch (Exception exception) {
                }
            }
        }
    }

    protected CommandData initCommandData() {
        return CommandDataFactory.eINSTANCE.createCommandData();
    }

    public Locale getLocale() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocale");
        }
        String string = this.getUserData().getLocale();
        Locale locale = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                        locale = new Locale(string2, string3, string4);
                    } else {
                        locale = new Locale(string2, string3);
                    }
                } else {
                    locale = new Locale(string2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "language", string2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "country", string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "variant", string4);
                }
            } else {
                locale = Locale.getDefault();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocale", locale);
        }
        return locale;
    }

    public void setLocale(Locale locale) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLocale", locale);
        }
        String string = null;
        if (locale != null) {
            StringBuffer stringBuffer = new StringBuffer(locale.getLanguage());
            stringBuffer.append('/').append(locale.getCountry());
            stringBuffer.append('/').append(locale.getVariant());
            string = stringBuffer.toString();
            this.getUserData().setLocale(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLocale", string);
        }
    }

    public String getName() {
        return this.metadata.getName();
    }

    public CommandMetadata getCommandMetadata() {
        return this.metadata;
    }

    protected CommandData getCommandData() {
        return this.commandData;
    }

    protected void setCommandMetadata(CommandMetadata commandMetadata) {
        this.metadata = commandMetadata;
    }

    public Object getTargetObject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetObject");
        }
        Object object = null;
        ObjectValue objectValue = this.commandData.getTargetObject();
        if (objectValue != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target Object is " + objectValue);
            }
            object = objectValue.getValue();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetObject", object);
        }
        return object;
    }

    public void setTargetObject(Object object) throws InvalidParameterValueException {
        ObjectValue objectValue;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTargetObject", object);
        }
        if ((string = this.metadata.getTargetObjectType()) == null && this.metadata.isTargetObjectRequired()) {
            throw new InvalidParameterValueException(this.getName(), "targetObject", object);
        }
        if (string != null && !object.getClass().getName().endsWith(string)) {
            throw new InvalidParameterValueException(this.getName(), "targetObject", object);
        }
        if (this.commandData == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "commanddata is null");
            }
            this.commandData = CommandDataFactory.eINSTANCE.createCommandData();
            this.commandData.setName(this.metadata.getName());
        }
        if ((objectValue = this.commandData.getTargetObject()) == null) {
            this.commandData.setTargetObject(CommandDataFactory.eINSTANCE.createGenericObjectValue());
            objectValue = this.commandData.getTargetObject();
        }
        objectValue.setValue(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTargetObject", objectValue);
        }
    }

    public Collection listSetParams() {
        return this.listSetParams(0);
    }

    protected Collection listSetParams(int n) {
        ArrayList<String> arrayList;
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listSetParams," + n);
        }
        if ((eList = this.commandData.getCmdParams()).size() == 0) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            EObject eObject = (EObject)eList.get(n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "paramData", eObject);
            }
            arrayList = new ArrayList<String>();
            EClass eClass = eObject.eClass();
            Iterator iterator = eClass.getEAllStructuralFeatures().iterator();
            while (iterator.hasNext()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "feature", eStructuralFeature);
                }
                if (!eObject.eIsSet(eStructuralFeature)) continue;
                arrayList.add(eStructuralFeature.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listSetParams", arrayList);
        }
        return arrayList;
    }

    public Object getParameter(String string) throws InvalidParameterNameException {
        return this.getParameter(string, 0);
    }

    public boolean isAsyncCommand() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAsyncCommand, command name: " + this.getName());
        }
        boolean bl = false;
        EList eList = this.metadata.getCustom();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Custom = " + eList);
        }
        if (eList != null && !eList.isEmpty()) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                CustomProperties customProperties = (CustomProperties)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Custom = " + customProperties);
                }
                if (!customProperties.getKey().equalsIgnoreCase(ASYNC_CUSTOM_TAG)) continue;
                EList eList2 = customProperties.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valus of async custom tag = " + eList2);
                }
                if (eList2 == null || eList2.isEmpty()) continue;
                String string = (String)eList2.iterator().next();
                bl = string.equalsIgnoreCase("true");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAsyncCommand, command name: " + this.getName() + " return " + bl);
        }
        return bl;
    }

    public boolean isPrivateParameter(String string) throws InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPrivateParameter, command name: " + this.getName() + ", param name: " + string);
        }
        boolean bl = false;
        ParameterMetadata parameterMetadata = this.getParameterMetadata(string);
        EList eList = parameterMetadata.getCustom();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Custom = " + eList);
        }
        if (eList != null && !eList.isEmpty()) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                CustomProperties customProperties = (CustomProperties)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Custom = " + customProperties);
                }
                if (!customProperties.getKey().equalsIgnoreCase(PRIVATE_CUSTOM_TAG)) continue;
                EList eList2 = customProperties.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valus of private custom tag = " + eList2);
                }
                if (eList2 == null || eList2.isEmpty()) continue;
                String string2 = (String)eList2.iterator().next();
                bl = string2.equalsIgnoreCase("true");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPrivateParameter, command name: " + this.getName() + ", param name: " + string + " return " + bl);
        }
        return bl;
    }

    public List listAllParameterName() {
        boolean bl = false;
        return this.listAllParameterName(bl);
    }

    public List listParameterName() {
        boolean bl = true;
        return this.listAllParameterName(bl);
    }

    private List listAllParameterName(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllParameterName, publicOnly=" + bl);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        EList eList = this.metadata.getParameters();
        for (int i = 0; i < eList.size(); ++i) {
            ParameterMetadata parameterMetadata = (ParameterMetadata)eList.get(i);
            String string = parameterMetadata.getName();
            try {
                if (bl && !this.isPrivateParameter(string)) {
                    arrayList.add(string);
                    continue;
                }
                arrayList.add(string);
                continue;
            }
            catch (InvalidParameterNameException invalidParameterNameException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllParameterName, publicOnly=" + bl, new Object[]{arrayList});
        }
        return arrayList;
    }

    protected Object getParameter(String string, int n) throws InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParameter", new Object[]{string, new Integer(n)});
        }
        Object object = null;
        this.getParameterMetadata(string);
        EList eList = this.commandData.getCmdParams();
        if (eList.size() > 0) {
            EObject eObject = (EObject)eList.get(n);
            EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "default attribute value is " + eStructuralFeature.getDefaultValue());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "default param value is " + eObject.eGet(eStructuralFeature));
            }
            if (eStructuralFeature instanceof EAttribute) {
                object = eObject.eGet(eStructuralFeature);
            } else {
                GenericObjectValue genericObjectValue = (GenericObjectValue)eObject.eGet(eStructuralFeature);
                if (genericObjectValue == null) {
                    return null;
                }
                object = genericObjectValue.getValue();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParameter.  Parameter Value is " + object);
        }
        return object;
    }

    public void setParameter(String string, Object object) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter", new Object[]{string, object});
        }
        this.setParameter(string, object, 0, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }

    protected void initializeParameter(String string, Object object) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "InitializeParameter", new Object[]{string, object});
        }
        this.setParameter(string, object, 0, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "InitializeParameter");
        }
    }

    protected void setParameter(String string, Object object, int n) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter", new Object[]{string, object, new Integer(n)});
        }
        this.setParameter(string, object, n, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }

    protected void initializeParameter(String string, Object object, int n) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeParameter", new Object[]{string, object, new Integer(n)});
        }
        this.setParameter(string, object, n, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeParameter");
        }
    }

    private void setParameter(String string, Object object, int n, boolean bl) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter", new Object[]{string, object, new Integer(n)});
        }
        if (this.isParamReadonly(string) && !bl) {
            throw new InvalidParameterValueException(this.getName(), string, object);
        }
        EList eList = this.commandData.getCmdParams();
        EObject eObject = null;
        if (!this.isTable() && eList.size() == 0) {
            try {
                eObject = this.createParamEObject();
                eList.add(eObject);
            }
            catch (CommandNotFoundException commandNotFoundException) {
                commandNotFoundException.printStackTrace();
            }
        } else {
            eObject = (EObject)eList.get(n);
        }
        try {
            EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(string);
            if (eStructuralFeature instanceof EAttribute) {
                eObject.eSet(eStructuralFeature, object);
            } else {
                GenericObjectValue genericObjectValue = (GenericObjectValue)eObject.eGet(eStructuralFeature);
                if (genericObjectValue == null) {
                    genericObjectValue = CommandDataFactory.eINSTANCE.createGenericObjectValue();
                    eObject.eSet(eStructuralFeature, genericObjectValue);
                }
                genericObjectValue.setValue(object);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setParameter");
            }
        }
        catch (ClassCastException classCastException) {
            throw new InvalidParameterValueException(this.getName(), string, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidParameterValueException(this.getName(), string, object);
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidParameterNameException(this.getName(), string);
        }
    }

    protected boolean isTable() {
        return false;
    }

    public Object[] getChoices(String string) {
        return null;
    }

    public Object[] getTargetObjectChoices() {
        return null;
    }

    public void validate() throws CommandValidationException {
        CommandMetadata commandMetadata;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        if ((commandMetadata = this.getCommandMetadata()).isTargetObjectRequired() && this.getTargetObject() == null) {
            throw new CommandValidationException(TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.cmdframework", "ADMF0007E"));
        }
        EList eList = commandMetadata.getParameters();
        EList eList2 = this.getCommandData().getCmdParams();
        if (!this.isTable() && eList2.size() == 0) {
            try {
                EObject eObject = this.createParamEObject();
                eList2.add(eObject);
            }
            catch (CommandNotFoundException commandNotFoundException) {
                commandNotFoundException.printStackTrace();
            }
        }
        for (int i = 0; i < eList2.size(); ++i) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Class<?> clazz;
                ParameterMetadata parameterMetadata = (ParameterMetadata)iterator.next();
                String string = parameterMetadata.getName();
                if (parameterMetadata.isRequired() && this.getParameter(string, i) == null) {
                    throw new RequiredParameterNotFoundException(this.getName(), string);
                }
                Object object = this.getParameter(string, i);
                try {
                    clazz = Class.forName(parameterMetadata.getType());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        clazz = Class.forName("java.lang." + parameterMetadata.getType());
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        throw new CommandValidationException("Type definition is not found for Parameter " + string + classNotFoundException);
                    }
                }
                if (object == null || clazz.isInstance(object)) continue;
                throw new InvalidParameterValueException(this.getName(), string, object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    public void setConfigSession(Session session) {
        this.getUserData().setWorkspaceId(session.toString());
    }

    public Session getConfigSession() {
        Session session;
        String string = this.getUserData().getWorkspaceId();
        if (string == null) {
            session = new Session();
            this.getUserData().setWorkspaceId(session.toString());
        } else {
            session = new Session(string, true);
        }
        return session;
    }

    public CommandResult getCommandResult() {
        return this.cmdResult;
    }

    protected void setCommandResult(CommandResult commandResult) {
        this.cmdResult = commandResult;
    }

    public void save(OutputStream outputStream) {
        block2: {
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            XMIResourceImpl xMIResourceImpl = new XMIResourceImpl();
            xMIResourceImpl.setURI(URI.createURI("Command.xmi"));
            xMIResourceImpl.getContents().add(this.commandData);
            try {
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                hashMap.put("DECLARE_XML", Boolean.TRUE);
                xMIResourceImpl.save(outputStream, hashMap);
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.error(tc, iOException.getMessage());
            }
        }
    }

    public abstract void execute();

    public void execute(CommandHistory commandHistory) {
        this.execute();
        commandHistory.add(this.getCommandData());
    }

    public void setCommandSession(TaskCommandSession taskCommandSession) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCommandSession", taskCommandSession);
        }
        this.asyncCmdSession = taskCommandSession;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCommandSession", this.asyncCmdSession);
        }
    }

    public TaskCommandSession getCommandSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandSession", this.asyncCmdSession);
        }
        if (this.asyncCmdSession == null) {
            if (!this.isLocalMode()) {
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                TaskCommandSessionMgr taskCommandSessionMgr = ((ServerCommandMgr)commandMgr).getTaskCommandSessionMgr();
                this.asyncCmdSession = taskCommandSessionMgr.createTaskCommandSession(this);
            } else {
                this.asyncCmdSession = new TaskCommandSession();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandSession", this.asyncCmdSession);
        }
        return this.asyncCmdSession;
    }

    public void setCmdHandler(CmdNotificationHandler cmdNotificationHandler) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHandler", cmdNotificationHandler);
        }
        this.cnh = cmdNotificationHandler;
        if (!this.isLocalMode()) {
            this.setupListener(this.cnh);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHandler");
        }
    }

    protected void setupListener(Object object) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setupListener", object);
            }
            try {
                CmdNotificationListener cmdNotificationListener = new CmdNotificationListener(this.getCommandSession().getSessionId());
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("CmdNotification");
                AdminServiceFactory.getAdminService().addNotificationListenerExtended(this.getRCMMbeanObjName(), cmdNotificationListener, notificationFilterSupport, object);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception occured", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupListener");
        }
    }

    public Collection getResult() {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        if (this.cmdResult.isSuccessful()) {
            arrayList.add(this.cmdResult.getResult());
        } else {
            arrayList.add(this.cmdResult.getException());
        }
        return arrayList;
    }

    public void sendNotification(CommandNotification commandNotification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendNotification");
        }
        if (!this.isLocalMode()) {
            if (commandNotification.getCmdStatus().equals("Completed") && this.isAsyncCommand()) {
                this.cleanupUploadedFiles();
            }
            RemoteCommandMgr remoteCommandMgr = ((ServerCommandMgr)CommandMgr.getCommandMgr()).getRCMMbean();
            remoteCommandMgr.sendCmdNotification("CmdNotification", commandNotification);
        } else {
            this.cnh.handleCmdNotification(commandNotification);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendNotification");
        }
    }

    public void redo() {
        throw new UnsupportedOperationException();
    }

    public void cleanupUploadedFiles() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupUploadedFiles");
        }
        EList eList = this.getCommandMetadata().getParameters();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            try {
                Object object;
                ParameterMetadata parameterMetadata = (ParameterMetadata)iterator.next();
                if (!parameterMetadata.getType().equals("com.ibm.websphere.management.cmdframework.UploadFile") || (object = this.getParameter(parameterMetadata.getName())) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "detect DownloadFile parameter " + parameterMetadata.getName() + " value is " + object);
                }
                new File(((UploadFile)object).getPath()).delete();
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected exception", throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand.cleanupUploadedFiles", "795", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupUploadedFiles");
        }
    }

    protected EObject createParamEObject() throws CommandNotFoundException {
        EObject eObject = null;
        try {
            eObject = CommandMetadataMgr.getInstance().createParamDataEObject(this.getName());
        }
        catch (CommandNotFoundException commandNotFoundException) {
            FFDCFilter.processException(commandNotFoundException, "com.ibm.websphere.management.commandframework.provider.AbstractAdminCommand", "365");
        }
        return eObject;
    }

    protected UserData getUserData() {
        UserData userData = this.commandData.getUserData();
        if (userData == null) {
            userData = CommandDataFactory.eINSTANCE.createUserData();
            this.commandData.setUserData(userData);
        }
        return userData;
    }

    public void resetCommandData(CommandData commandData) {
        this.setCommandData(commandData);
    }

    protected void resetCommandMetadata(CommandMetadata commandMetadata) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetCommandMetadata", commandMetadata);
        }
        this.metadata = commandMetadata;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetCommandMetadata", this.metadata);
        }
    }

    public String generateScript(String string) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateScript", string);
        }
        Object object = this.getScriptGenerator(string);
        String string2 = null;
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.scripting.adminCommand.AdminCmdScriptGenerator");
            Method method = clazz.getMethod("generateScriptFromCmd", AdminCommand.class);
            Object object2 = method.invoke(object, this);
            string2 = object2.toString();
        }
        catch (Throwable throwable) {
            throw new CommandException(throwable, "unable to generate script from command in " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateScript", string2);
        }
        return string2;
    }

    protected ParameterMetadata getParameterMetadata(String string) throws InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParameterMetadata", string);
        }
        EList eList = this.getCommandMetadata().getParameters();
        ParameterMetadata parameterMetadata = null;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ParameterMetadata parameterMetadata2 = (ParameterMetadata)iterator.next();
            if (!parameterMetadata2.getName().equals(string)) continue;
            parameterMetadata = parameterMetadata2;
            break;
        }
        if (parameterMetadata == null) {
            throw new InvalidParameterNameException(this.getName(), string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParameterMetadata");
        }
        return parameterMetadata;
    }

    private Object getScriptGenerator(String string) throws CommandException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScriptGenerator", string);
        }
        if ((object = scriptGenerators.get(string)) == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.scripting.adminCommand.AdminCmdScriptGenerator");
                Constructor<?> constructor = clazz.getConstructor(String.class);
                object = constructor.newInstance(string);
            }
            catch (Throwable throwable) {
                throw new CommandException(throwable, "unable to instantiate script generator");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScriptGenerator", object);
        }
        return object;
    }

    private ObjectName getRCMMbeanObjName() throws MalformedObjectNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRCMMbeanObjName");
        }
        String string = AdminServiceFactory.getAdminService().getProcessName();
        String string2 = "WebSphere:type=RemoteCommandMgr,process=" + string + ",*";
        ObjectName objectName = new ObjectName(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRCMMbeanObjName", objectName);
        }
        return objectName;
    }

    protected boolean isLocalMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isLocalMode");
        }
        boolean bl = CommandMgr.getCommandMgr() instanceof LocalCommandMgr;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isLocalMode", new Boolean(bl));
        }
        return bl;
    }

    protected boolean isParamReadonly(String string) throws InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isParamReadonly", string);
        }
        ParameterMetadata parameterMetadata = this.getParameterMetadata(string);
        boolean bl = parameterMetadata.isReadonly();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isParamReadonly", new Boolean(bl));
        }
        return bl;
    }

    protected ConfigService getConfigService() {
        return ConfigServiceFactory.getConfigService();
    }

    public ParameterMetadata createParameterMetadata(String string, Hashtable hashtable) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createParameterMetadata", new Object[]{string, hashtable});
        }
        ParameterMetadata parameterMetadata = CommandMetadataFactory.eINSTANCE.createParameterMetadata();
        parameterMetadata.setName(string);
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            Object v = hashtable.get(n);
            EStructuralFeature eStructuralFeature = parameterMetadata.eClass().getEStructuralFeature(n);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting feature " + eStructuralFeature.getName() + " to \"" + v + "\"");
                }
                parameterMetadata.eSet(eStructuralFeature, v);
            }
            catch (ClassCastException classCastException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got unexpected " + classCastException + ", when creating " + string + " ParameterMetadata with " + eStructuralFeature.getName() + " = \"" + v + "\"");
                }
                throw new InvalidParameterValueException(string, eStructuralFeature.getName(), v);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got unexpected " + illegalArgumentException + ", when creating " + string + " ParameterMetadata with " + eStructuralFeature.getName() + " = \"" + v + "\"");
                }
                throw new InvalidParameterValueException(string, eStructuralFeature.getName(), v);
            }
            catch (NullPointerException nullPointerException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got unexpected " + nullPointerException + ", when creating " + string + " ParameterMetadata with feature name " + eStructuralFeature.getName());
                }
                throw new InvalidParameterNameException(string, eStructuralFeature.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createParameterMetadata returns", new Object[]{parameterMetadata});
        }
        return parameterMetadata;
    }

    public class CmdNotificationListener
    implements NotificationListener {
        protected boolean success;
        protected boolean complete;
        protected long session;

        public CmdNotificationListener() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "CmdNotificationListener");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "CmdNotificationListener");
            }
        }

        public CmdNotificationListener(long l) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "CmdNotificationListener");
            }
            this.session = l;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "CmdNotificationListener");
            }
        }

        public void handleNotification(Notification notification, Object object) {
            Object object2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{notification, object});
            }
            if ((object2 = notification.getUserData()) instanceof CommandNotification) {
                CommandNotification commandNotification = (CommandNotification)object2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command name is " + commandNotification.getCmdName() + ", Command status is " + commandNotification.getCmdStatus() + ", Command message is " + commandNotification.getMessage() + ", session id is " + commandNotification.getSessionID());
                }
                if (commandNotification.getSessionID() == AbstractAdminCommand.this.asyncCmdSession.getSessionId()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command status is " + commandNotification.getCmdStatus());
                    }
                    if (commandNotification.getCmdStatus().equals("Completed")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Command completed.  Result is " + commandNotification.getResult().getResult());
                        }
                        this.complete = true;
                        AbstractAdminCommand.this.setCommandResult(commandNotification.getResult());
                        try {
                            this.removeListener();
                        }
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "unexpected exception", exception);
                            }
                            FFDCFilter.processException(exception, "com.ibm.websphere.management.cmdframework.CmdNotificationListener", "134");
                        }
                    }
                    AbstractAdminCommand.this.cnh.handleCmdNotification(commandNotification);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command notified");
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "received irrelevant event", object2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
        }

        public void removeListener() throws Exception {
            AdminServiceFactory.getAdminService().removeNotificationListenerExtended(this);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isComplete() {
            return this.complete;
        }
    }
}

