/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.ws.management.application.J2EEAppDeployment;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Hashtable;

public class AppManagementBaseFactory {
    private static TraceComponent tc = Tr.register(AppManagementBaseFactory.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String implName = "com.ibm.ws.management.application.AppManagementImpl";
    private static final String j2eeImplName = "com.ibm.ws.management.application.J2EEAppDeploymentImpl";

    public static AppManagement createLocalAppManagementImpl() {
        String string = System.getProperty("was.repository.root");
        return AppManagementBaseFactory._createAppManagementImpl(string);
    }

    public static AppManagement createLocalAppManagementImpl(String string) {
        String string2 = System.getProperty("was.repository.root");
        return AppManagementBaseFactory._createAppManagementImpl(string2);
    }

    private static AppManagement _createAppManagementImpl(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Temp extraction dir for multiserver", AppManagementBaseFactory.getTempExtractDir());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configroot: " + string);
        }
        if (string != null) {
            hashtable.put("Config Root for variable map", string);
        }
        try {
            Class<?> clazz = Class.forName(implName);
            Constructor<?> constructor = clazz.getConstructor(Hashtable.class);
            return (AppManagement)constructor.newInstance(hashtable);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    private static J2EEAppDeployment _createJ2EEAppDeploymentImpl(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Temp extraction dir for multiserver", AppManagementBaseFactory.getTempExtractDir());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configroot: " + string);
        }
        hashtable.put("Config Root for variable map", string);
        try {
            Class<?> clazz = Class.forName(j2eeImplName);
            Constructor<?> constructor = clazz.getConstructor(Hashtable.class);
            return (J2EEAppDeployment)constructor.newInstance(hashtable);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static void initMBean(String string, String string2, String string3, String string4) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initMBean");
        }
        AppManagement appManagement = AppManagementBaseFactory._createAppManagementImpl(string);
        AdminServiceFactory.getMBeanFactory().activateMBean("AppManagement", (RuntimeCollaborator)((Object)appManagement), "AppManagement", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Activated AppManegementMBean");
        }
        J2EEAppDeployment j2EEAppDeployment = AppManagementBaseFactory._createJ2EEAppDeploymentImpl(string);
        AdminServiceFactory.getMBeanFactory().activateMBean("J2EEAppDeployment", (RuntimeCollaborator)((Object)j2EEAppDeployment), "J2EEAppDeployment", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Activated J2EEAppDeploymentMBean");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process Type: " + AdminServiceFactory.getAdminService().getProcessType());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initMBean");
        }
    }

    public static String getTempExtractDir() {
        String string;
        block5: {
            string = null;
            try {
                Object object;
                Field field;
                Class<?> clazz = Class.forName("com.ibm.ws.sm.workspace.impl.WorkSpaceConstant");
                if (clazz != null && (field = clazz.getDeclaredField("WORKSPACE_PATH_NAME")) != null && (object = field.get(null)) instanceof String) {
                    String string2;
                    string = string2 = (String)object;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Result using reflection", string);
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception recieved", exception);
            }
        }
        if (string != null) {
            string = System.getProperty("user.install.root") == null ? System.getProperty("java.io.tmpdir") : string + File.separator + "wstemp";
        }
        return string + File.separator;
    }
}

