/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.trust10.util;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DerivedKeyGenerator
implements Serializable {
    private static final long serialVersionUID = 1441952410370373984L;
    public static final String DEFLABEL = "WS-SecureConversation";
    public static final String DEFMAC = "HmacSHA1";
    public static final String AES = "AES";
    public static final int DEFAULT_AES_KEY_LENGTH = 16;
    private byte[] labelBytes;
    private transient Mac mac = null;
    private String macTypeS;
    protected SecretKey secretKey;
    private String encMethodType = null;
    private int defKeyLength;
    private boolean isDebugging;

    public DerivedKeyGenerator(byte[] theSecret) throws InvalidKeyException, NoSuchAlgorithmException {
        this(theSecret, DEFLABEL, DEFLABEL, AES, DEFMAC, 0);
    }

    public DerivedKeyGenerator(byte[] theSecret, String algorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        this(theSecret, DEFLABEL, DEFLABEL, algorithm, DEFMAC, 0);
    }

    public DerivedKeyGenerator(byte[] theSecret, String algorithm, int defaultKeyBytesLength) throws InvalidKeyException, NoSuchAlgorithmException {
        this(theSecret, DEFLABEL, DEFLABEL, algorithm, DEFMAC, defaultKeyBytesLength);
    }

    public DerivedKeyGenerator(byte[] theSecret, String clientLabel, String serviceLabel, String encMethod, String macType, int defaultKeyBytesLength) throws InvalidKeyException, NoSuchAlgorithmException {
        if (clientLabel == null) {
            throw new IllegalArgumentException("label invalid");
        }
        if (serviceLabel == null) {
            throw new IllegalArgumentException("label invalid");
        }
        try {
            this.labelBytes = (clientLabel + serviceLabel).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.labelBytes = (clientLabel + serviceLabel).getBytes();
        }
        this.init(theSecret, encMethod, macType, defaultKeyBytesLength);
    }

    protected void init(byte[] theSecret, String encMethod, String macType, int defaultKeyLength) throws NoSuchAlgorithmException, InvalidKeyException {
        if (defaultKeyLength == 0) {
            defaultKeyLength = 16;
        }
        this.defKeyLength = defaultKeyLength;
        this.secretKey = new PseudoSecretKey(theSecret);
        this.macTypeS = macType == null ? DEFMAC : macType;
        this.mac = Mac.getInstance(this.macTypeS);
        this.mac.init(this.secretKey);
        this.encMethodType = encMethod;
    }

    public SecretKey createKey(byte[] secondPart) throws NoSuchAlgorithmException, InvalidKeyException {
        return this.createKey(secondPart, 0);
    }

    public byte[] createKeyBytes(byte[] secondPart, int numKeyBytes) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] answer = null;
        if (numKeyBytes == 0) {
            numKeyBytes = this.defKeyLength;
        }
        secondPart = this.modBytes(secondPart);
        answer = this.p_sha1(secondPart, numKeyBytes);
        if (this.isDebugging) {
            HexDumpEncoder hde = new HexDumpEncoder();
            String msgString = "derived this key\n" + hde.encodeBuffer(answer);
            msgString = msgString + "\nfrom this key\n" + hde.encodeBuffer(this.secretKey.getEncoded());
            msgString = msgString + "\nand this nonce\n" + hde.encodeBuffer(secondPart);
            new RuntimeException(msgString).printStackTrace(System.out);
        }
        return answer;
    }

    public byte[] createKeyBytes(byte[] secondPart) throws NoSuchAlgorithmException, InvalidKeyException {
        return this.createKeyBytes(secondPart, 0);
    }

    public SecretKey createKey(byte[] secondPart, int numKeyBytes) throws NoSuchAlgorithmException, InvalidKeyException {
        if (numKeyBytes == 0) {
            numKeyBytes = this.defKeyLength;
        }
        secondPart = this.modBytes(secondPart);
        byte[] bytes = this.p_sha1(secondPart, numKeyBytes);
        SecretKeySpec answer = new SecretKeySpec(bytes, this.encMethodType);
        if (this.isDebugging) {
            HexDumpEncoder hde = new HexDumpEncoder();
            String msgString = "derived this key\n" + hde.encodeBuffer(answer.getEncoded());
            msgString = msgString + "\nfrom this key\n" + hde.encodeBuffer(this.secretKey.getEncoded());
            msgString = msgString + "\nand this nonce\n" + hde.encodeBuffer(secondPart);
            msgString = msgString + "\nwhose Base64 is\n" + Base64.encode(secondPart);
            new RuntimeException(msgString).printStackTrace(System.out);
        }
        return answer;
    }

    private byte[] p_sha1(byte[] nonce, int length) {
        byte[] A = new byte[nonce.length];
        byte[] P = null;
        byte[] seed = new byte[nonce.length];
        System.arraycopy(nonce, 0, seed, 0, nonce.length);
        System.arraycopy(nonce, 0, A, 0, nonce.length);
        int MACLEN = this.mac.getMacLength();
        int rounds = length / MACLEN;
        if (length % MACLEN != 0) {
            ++rounds;
        }
        byte[] result = new byte[rounds * MACLEN];
        for (int i = 0; i < rounds; ++i) {
            A = this.hash(A);
            byte[] current = new byte[A.length + seed.length];
            System.arraycopy(A, 0, current, 0, A.length);
            System.arraycopy(seed, 0, current, A.length, seed.length);
            P = this.hash(current);
            System.arraycopy(P, 0, result, i * P.length, P.length);
        }
        byte[] trimmedResult = new byte[length];
        System.arraycopy(result, 0, trimmedResult, 0, length);
        return trimmedResult;
    }

    private byte[] hash(byte[] data) {
        return this.mac.doFinal(data);
    }

    private byte[] modBytes(byte[] secondPart) {
        byte[] lbl2part = new byte[this.labelBytes.length + secondPart.length];
        System.arraycopy(this.labelBytes, 0, lbl2part, 0, this.labelBytes.length);
        System.arraycopy(secondPart, 0, lbl2part, this.labelBytes.length, secondPart.length);
        return lbl2part;
    }

    private static class PseudoSecretKey
    implements SecretKey,
    Serializable {
        private static final long serialVersionUID = 2553603474989758052L;
        private static final String RAW = "RAW";
        private static final String ALGORITHM = "None";
        private byte[] bytes;

        PseudoSecretKey(byte[] bites) {
            if (bites == null || bites.length == 0) {
                throw new RuntimeException("need something to wrap");
            }
            this.bytes = new byte[bites.length];
            System.arraycopy(bites, 0, this.bytes, 0, bites.length);
        }

        public String getAlgorithm() {
            return ALGORITHM;
        }

        public String getFormat() {
            return RAW;
        }

        public byte[] getEncoded() {
            byte[] answer = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, answer, 0, this.bytes.length);
            return answer;
        }
    }
}

