/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.trust10.client.om;

import com.ibm.security.trust10.TrustException;
import com.ibm.security.trust10.client.om.RequestSecurityTokenImpl;
import com.ibm.security.trust10.client.om.RequestSecurityTokenResponseCollectionImpl;
import com.ibm.security.trust10.client.om.RequestSecurityTokenResponseImpl;
import com.ibm.security.trust10.client.om.STSConstantsImpl;
import com.ibm.security.trust10.types.IRSTTemplate;
import com.ibm.security.trust10.types.IRequestSecurityToken;
import com.ibm.security.trust10.types.IRequestSecurityTokenResponseCollection;
import com.ibm.security.trust10.types.ISTSConfiguration;
import com.ibm.security.trust10.types.ISTSRequestor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.StreamWrapper;

public class STSRequestorImpl
implements ISTSRequestor {
    private static String CLASSNAME = STSRequestorImpl.class.getName();
    private static Logger log = Logger.getLogger(CLASSNAME);
    public static final String TRANSPORT_HTTP = "http";
    private ISTSConfiguration config = null;
    private Map etc = null;
    private RequestSecurityTokenImpl rst = null;
    private MessageContext msgCtx = null;
    private Map overrideM;
    private ServiceClient runClient;
    private IRequestSecurityTokenResponseCollection rstrc;
    private AxisService axisService;
    private QName rstQn;
    private OMElement rstElem;
    private static volatile long sequence = 0L;

    private IRequestSecurityTokenResponseCollection run() throws TrustException {
        block7: {
            try {
                OMElement elem = null;
                try {
                    elem = this.runClient.sendReceive(this.rstQn, this.rstElem);
                }
                catch (AxisFault af) {
                    log.logp(Level.FINER, CLASSNAME, "run", "Recieved an Axis Fault");
                    throw new TrustException(af);
                }
                if (elem == null) {
                    throw new TrustException("no response from trust server");
                }
                log.logp(Level.FINER, CLASSNAME, "run", "Element Returned from STS Server: " + ((Object)elem).toString());
                this.rstrc = new RequestSecurityTokenResponseCollectionImpl(this.msgCtx);
                if ("RequestSecurityTokenResponseCollection".equals(elem.getLocalName())) {
                    log.logp(Level.FINER, CLASSNAME, "run", "Creating a Resquest Security Token Response Collection");
                    this.rstrc.consume(elem);
                    break block7;
                }
                if ("RequestSecurityTokenResponse".equals(elem.getLocalName())) {
                    log.logp(Level.FINER, CLASSNAME, "run", "Creating a Single Resquest Security Token Response");
                    RequestSecurityTokenResponseImpl rstr = new RequestSecurityTokenResponseImpl(this.msgCtx);
                    rstr.consume(elem);
                    this.rstrc.add(rstr);
                    break block7;
                }
                throw new TrustException("unexpected response\n" + elem);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new TrustException(exc);
            }
        }
        return this.rstrc;
    }

    public IRequestSecurityTokenResponseCollection issue(Object service) throws TrustException {
        log.entering(CLASSNAME, "issue");
        if (this.rst == null) {
            throw new TrustException("STSRequestor not yet initialized");
        }
        if (service == null || !(service instanceof ServiceClient)) {
            throw new TrustException("NULL or Wrong service input type");
        }
        this.runClient = (ServiceClient)service;
        IRequestSecurityTokenResponseCollection rstrc = this.run();
        log.exiting(CLASSNAME, "issue");
        return rstrc;
    }

    public IRequestSecurityTokenResponseCollection validate(Object service) throws TrustException {
        log.entering(CLASSNAME, "validate");
        if (this.rst == null) {
            throw new TrustException("STSRequestor not yet initialized");
        }
        if (service == null || !(service instanceof ServiceClient)) {
            throw new TrustException("NULL or Wrong service input type");
        }
        this.runClient = (ServiceClient)service;
        IRequestSecurityTokenResponseCollection rstrc = this.run();
        log.exiting(CLASSNAME, "validate");
        return rstrc;
    }

    public IRequestSecurityTokenResponseCollection renew(Object service) throws TrustException {
        log.entering(CLASSNAME, "renew");
        if (this.rst == null) {
            throw new TrustException("STSRequestor not yet initialized");
        }
        if (service == null || !(service instanceof ServiceClient)) {
            throw new TrustException("NULL or Wrong service input type");
        }
        this.runClient = (ServiceClient)service;
        IRequestSecurityTokenResponseCollection rstrc = this.run();
        log.exiting(CLASSNAME, "renew");
        return rstrc;
    }

    public IRequestSecurityTokenResponseCollection cancel(Object service) throws TrustException {
        log.entering(CLASSNAME, "cancel");
        if (this.rst == null) {
            throw new TrustException("STSRequestor not yet initialized");
        }
        if (service == null || !(service instanceof ServiceClient)) {
            throw new TrustException("NULL or Wrong service input type");
        }
        this.runClient = (ServiceClient)service;
        IRequestSecurityTokenResponseCollection rstrc = this.run();
        log.exiting(CLASSNAME, "cancel");
        return rstrc;
    }

    public IRequestSecurityToken getRST() throws TrustException {
        if (this.rst != null) {
            return this.rst;
        }
        return null;
    }

    public Object init(Map parms) throws TrustException {
        if (parms == null) {
            throw new TrustException("null input parameters");
        }
        Object o = parms.get("STS_Conf");
        if (o == null) {
            throw new TrustException("must have STSConstantsImpl.ISTSCONFIGURATION in parms");
        }
        if (!(o instanceof ISTSConfiguration)) {
            throw new TrustException("unsupported object type for value of STSConstantsImpl.ISTSCONFIGURATION");
        }
        this.config = (ISTSConfiguration)o;
        o = parms.get("RSTTemplate");
        if (o == null) {
            throw new TrustException("must have STSConstantsImpl.RSTTEMPLATE in parms");
        }
        if (!(o instanceof IRSTTemplate)) {
            throw new TrustException("unsupported object type for value of STSConstantsImpl.RSTTEMPLATE");
        }
        IRSTTemplate template = (IRSTTemplate)o;
        this.etc = new HashMap(parms);
        o = this.etc.get("axis2_messagecontext_propertymap");
        this.overrideM = null;
        if (o != null && !(o instanceof Map)) {
            throw new TrustException("unsupported object type for value of STSConstantsImpl.AXIS2_MESSAGECONTEXT_PROPERTYMAP");
        }
        if (o != null) {
            this.overrideM = new HashMap((Map)o);
        }
        String SYS_LOGGING_LEVEL = System.getProperty("Logging.Level");
        if (this.config.get(STSConstantsImpl.LOG_LEVEL) != null) {
            SYS_LOGGING_LEVEL = (String)this.config.get(STSConstantsImpl.LOG_LEVEL);
        }
        if (SYS_LOGGING_LEVEL != null) {
            SYS_LOGGING_LEVEL = SYS_LOGGING_LEVEL.trim();
            log.setLevel(Level.parse(SYS_LOGGING_LEVEL));
            Handler[] handlers = log.getParent().getHandlers();
            if (handlers != null) {
                for (int i = 0; i < handlers.length; ++i) {
                    handlers[i].setLevel(Level.parse(SYS_LOGGING_LEVEL));
                }
            }
        }
        ServiceClient client = null;
        try {
            String soapLevelS;
            AxisConfiguration er = new AxisConfiguration();
            AxisService servicesDesc = new AxisService();
            servicesDesc.setName("STSRequestor");
            er.addService(servicesDesc);
            ConfigurationContext engineContext = new ConfigurationContext(er);
            this.msgCtx = new MessageContext();
            this.msgCtx.setConfigurationContext(engineContext);
            SOAPFactory omFac = OMAbstractFactory.getSOAP11Factory();
            SOAPEnvelope env = omFac.getDefaultEnvelope();
            this.msgCtx.setEnvelope(env);
            if (this.config.get("trust_level") != null) {
                this.msgCtx.setProperty("trust_level", this.config.get("trust_level"));
            }
            if (this.config.get("addressing_level") != null) {
                this.msgCtx.setProperty("addressing_level", this.config.get("addressing_level"));
            }
            if (this.config.get(STSConstantsImpl.LOG_LEVEL) != null) {
                this.msgCtx.setProperty(STSConstantsImpl.LOG_LEVEL, this.config.get(STSConstantsImpl.LOG_LEVEL));
            }
            this.rst = new RequestSecurityTokenImpl(template, this.msgCtx);
            if (this.config.get("CONTEXT_URI") != null) {
                this.rst.setContextURI((String)this.config.get("CONTEXT_URI"));
            }
            if (this.axisService == null) {
                String name = "TrustClientRequestor_Thread" + Thread.currentThread().getId() + "_Sequence" + ++sequence;
                this.axisService = new AxisService(name);
                log.logp(Level.FINER, CLASSNAME, "run", "AxisService: " + this.axisService.getName());
            }
            this.rstQn = new QName("SSI");
            if (this.config.get("STS_NAME") != null) {
                this.rstQn = new QName((String)this.config.get("STS_NAME"));
            }
            if ((soapLevelS = (String)this.config.get("soap_level")) == null) {
                soapLevelS = "http://schemas.xmlsoap.org/soap/envelope/";
            }
            log.logp(Level.FINER, CLASSNAME, "run", "Using SOAP Level:" + soapLevelS);
            String addrLevelS = (String)this.config.get("addressing_level");
            if (addrLevelS == null) {
                addrLevelS = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
            }
            log.logp(Level.FINER, CLASSNAME, "run", "Using WS-Addressing Level:" + addrLevelS);
            String trustLevelS = (String)this.config.get("trust_level");
            if (trustLevelS == null) {
                trustLevelS = "http://schemas.xmlsoap.org/ws/2005/02/trust";
            }
            log.logp(Level.FINER, CLASSNAME, "run", "Using WS-Trust Level:" + trustLevelS);
            OutInAxisOperation operation = new OutInAxisOperation(this.rstQn);
            this.axisService.addOperation(operation);
            StAXOMBuilder builder = new StAXOMBuilder(new StreamWrapper(this.rst.getParser(new QName(trustLevelS, "RequestSecurityToken", "wst"))));
            this.rstElem = builder.getDocumentElement();
            this.rstElem.build();
            this.rstElem = (OMElement)this.rstElem.detach();
            log.logp(Level.FINER, CLASSNAME, "run", "RST Element: " + ((Object)this.rstElem).toString());
            String axis2home = null;
            if (this.config.get("AXIS_HOME") != null) {
                axis2home = (String)this.config.get("AXIS_HOME");
            }
            ConfigurationContext configctx = null;
            if (this.etc == null || !this.etc.containsKey("CONFIG_CONTEXT")) {
                log.logp(Level.FINER, CLASSNAME, "run", "Using Supplied AXIS_HOME");
                configctx = ConfigurationContextFactory.createConfigurationContextFromFileSystem(axis2home, null);
            } else {
                log.logp(Level.FINER, CLASSNAME, "run", "Using Supplied Configuration Context");
                configctx = (ConfigurationContext)this.etc.get("CONFIG_CONTEXT");
            }
            try {
                log.logp(Level.FINER, CLASSNAME, "run", "About to construct new ServiceClient, with configctx = " + configctx + " and axisService = " + this.axisService);
                client = new ServiceClient(configctx, this.axisService);
                log.logp(Level.FINER, CLASSNAME, "run", "Survived ServiceClient construction");
            }
            catch (Exception exc) {
                log.logp(Level.FINER, CLASSNAME, "run", "Died in ServiceClient construction");
                throw new TrustException(exc);
            }
            Options options = new Options();
            if (this.overrideM != null) {
                options.setProperties(this.overrideM);
            } else {
                log.logp(Level.FINER, CLASSNAME, "run", "Overide options are null");
            }
            if (this.config.get("MESSAGE_ACTION") != null) {
                options.setAction((String)this.config.get("MESSAGE_ACTION"));
            }
            if (this.config.get("MESSAGE_TO") != null) {
                EndpointReference to = new EndpointReference((String)this.config.get("MESSAGE_TO"));
                options.setTo(to);
            }
            if (this.config.get("MESSAGE_ID") != null) {
                options.setMessageId((String)this.config.get("MESSAGE_ID"));
            }
            if (this.config.get("MESSAGE_REPLYTO") != null) {
                EndpointReference replyTo = new EndpointReference((String)this.config.get("MESSAGE_REPLYTO"));
                options.setReplyTo(replyTo);
            }
            options.setProperty("WSAddressingVersion", addrLevelS);
            options.setTransportInProtocol(TRANSPORT_HTTP);
            options.setSoapVersionURI(soapLevelS);
            options.setExceptionToBeThrownOnSOAPFault(true);
            if (configctx.getAxisConfiguration() != null) {
                if (!configctx.getAxisConfiguration().getEngagedModules().isEmpty()) {
                    Iterator ite = configctx.getAxisConfiguration().getEngagedModules().iterator();
                    while (ite.hasNext()) {
                        log.logp(Level.FINER, CLASSNAME, "run", ite.next().toString());
                    }
                }
                try {
                    if (!configctx.getAxisConfiguration().isEngaged(new QName("addressing"))) {
                        log.logp(Level.FINER, CLASSNAME, "run", "Engaging Addressing Module");
                        client.engageModule(new QName("addressing"));
                    }
                }
                catch (Exception exc) {
                    log.logp(Level.FINER, CLASSNAME, "run", "No Addressing Modules to Engage");
                    throw new TrustException("No Addressing Modules Available to engage");
                }
            }
            client.setOptions(options);
        }
        catch (Exception exc) {
            throw new TrustException(exc);
        }
        return client;
    }

    public byte[] getEntropyKey() throws TrustException {
        if (this.rst != null) {
            return this.rst.getNonce();
        }
        return null;
    }
}

