/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.trust10.client.om;

import com.ibm.security.trust10.TrustException;
import com.ibm.security.trust10.client.om.BinarySecret;
import com.ibm.security.trust10.client.om.ComputedKey;
import com.ibm.security.trust10.client.om.EncryptedKey;
import com.ibm.security.trust10.client.om.RequestedSecurityTokenImpl;
import com.ibm.security.trust10.client.om.STSConstantsImpl;
import com.ibm.security.trust10.types.IRequestSecurityTokenResponse;
import com.ibm.security.trust10.types.IRequestedSecurityToken;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.NamedStaxOMBuilder;
import org.apache.axis2.util.StreamWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestSecurityTokenResponseImpl
implements IRequestSecurityTokenResponse {
    protected URI localContext;
    protected OMElement[] localExtraElement;
    protected IRequestedSecurityToken localRequestedSecurityToken;
    private String RPTType = null;
    private String SecretURI = null;
    private String TrustLevel = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    private ArrayList<OMElement> extraElements = new ArrayList();
    private static String CLASSNAME = RequestSecurityTokenResponseImpl.class.getName();
    private static Logger log = Logger.getLogger(CLASSNAME);

    public RequestSecurityTokenResponseImpl(MessageContext msgCtx) {
        if (msgCtx.getProperty("trust_level") != null) {
            this.TrustLevel = (String)msgCtx.getProperty("trust_level");
        }
        String SYS_LOGGING_LEVEL = System.getProperty("Logging.Level");
        if (msgCtx.getProperty(STSConstantsImpl.LOG_LEVEL) != null) {
            SYS_LOGGING_LEVEL = (String)msgCtx.getProperty(STSConstantsImpl.LOG_LEVEL);
        }
        if (SYS_LOGGING_LEVEL != null) {
            SYS_LOGGING_LEVEL = SYS_LOGGING_LEVEL.trim();
            log.setLevel(Level.parse(SYS_LOGGING_LEVEL));
            Handler[] handlers = log.getParent().getHandlers();
            if (handlers != null) {
                for (int i = 0; i < handlers.length; ++i) {
                    handlers[i].setLevel(Level.parse(SYS_LOGGING_LEVEL));
                }
            }
        }
    }

    @Override
    public Object getAttachedReference() throws TrustException {
        log.entering(CLASSNAME, "getAttachedReference");
        OMElement reqAttachedRef = null;
        for (int i = 0; i < this.localExtraElement.length; ++i) {
            OMElement reqAttachedElement = null;
            reqAttachedElement = this.localExtraElement[i].getLocalName().equalsIgnoreCase("RequestedAttachedReference") ? this.localExtraElement[i] : this.localExtraElement[i].getFirstChildWithName(new QName(this.TrustLevel, "RequestedAttachedReference"));
            if (reqAttachedElement == null) continue;
            reqAttachedRef = reqAttachedElement == null ? null : reqAttachedElement.getFirstElement();
            break;
        }
        log.exiting(CLASSNAME, "getAttachedReference");
        return reqAttachedRef;
    }

    @Override
    public Object getUnattachedReference() throws TrustException {
        log.entering(CLASSNAME, "getUnattachedReference");
        OMElement reqUnAttachedRef = null;
        for (int i = 0; i < this.localExtraElement.length; ++i) {
            OMElement reqUnattachedElement = null;
            reqUnattachedElement = this.localExtraElement[i].getLocalName().equalsIgnoreCase("RequestedUnattachedReference") ? this.localExtraElement[i] : this.localExtraElement[i].getFirstChildWithName(new QName(this.TrustLevel, "RequestedUnattachedReference"));
            if (reqUnattachedElement == null) continue;
            reqUnAttachedRef = reqUnattachedElement == null ? null : reqUnattachedElement.getFirstElement();
            break;
        }
        log.exiting(CLASSNAME, "getUnattachedReference");
        return reqUnAttachedRef;
    }

    @Override
    public String getTokenType() throws TrustException {
        log.entering(CLASSNAME, "getTokenType");
        String tokType = null;
        for (int i = 0; i < this.localExtraElement.length; ++i) {
            OMElement tokenType = null;
            tokenType = this.localExtraElement[i].getLocalName().equalsIgnoreCase("TokenType") ? this.localExtraElement[i] : this.localExtraElement[i].getFirstChildWithName(new QName(this.TrustLevel, "TokenType"));
            if (tokenType == null) continue;
            tokType = tokenType.getLocalName();
            break;
        }
        log.exiting(CLASSNAME, "getTokenType");
        return tokType;
    }

    @Override
    public Object getSecretElement() throws TrustException {
        log.entering(CLASSNAME, "getSecretElement");
        for (int i = 0; i < this.localExtraElement.length; ++i) {
            OMElement rpt = null;
            rpt = this.localExtraElement[i].getLocalName().equalsIgnoreCase("RequestedProofToken") ? this.localExtraElement[i] : this.localExtraElement[i].getFirstChildWithName(new QName(this.TrustLevel, "RequestedProofToken"));
            if (rpt == null) continue;
            OMElement elem = rpt.getFirstElement();
            if ("EncryptedKey".equals(elem.getLocalName()) && this.TrustLevel.equals(elem.getNamespace().getName())) {
                log.logp(Level.FINER, CLASSNAME, "getSecretElement", "Found encrypted key");
                this.RPTType = elem.getLocalName();
                EncryptedKey Ikey = new EncryptedKey(elem);
                log.exiting(CLASSNAME, "getSecretElement");
                return Ikey;
            }
            if ("BinarySecret".equals(elem.getLocalName()) && this.TrustLevel.equals(elem.getNamespace().getName())) {
                log.logp(Level.FINER, CLASSNAME, "getSecretElement", "Found Binary Secret key");
                this.RPTType = elem.getLocalName();
                BinarySecret Ibs = new BinarySecret(elem);
                log.exiting(CLASSNAME, "getSecretElement");
                return Ibs;
            }
            if (!"ComputedKey".equals(elem.getLocalName()) || !this.TrustLevel.equals(elem.getNamespace().getName())) break;
            log.logp(Level.FINER, CLASSNAME, "getSecretElement", "Found Computed Key");
            this.RPTType = elem.getLocalName();
            String compSecret = null;
            ComputedKey Icc = new ComputedKey(elem);
            for (int j = 0; j < this.localExtraElement.length; ++j) {
                OMElement elemTest;
                if (!"Entropy".equals(this.localExtraElement[j].getLocalName()) || !this.TrustLevel.equals(this.localExtraElement[j].getNamespace().getName()) || !"BinarySecret".equals((elemTest = this.localExtraElement[j].getFirstElement()).getLocalName()) || !this.TrustLevel.equals(elemTest.getNamespace().getName())) continue;
                compSecret = elemTest.getText();
            }
            Icc.setKey(compSecret);
            log.exiting(CLASSNAME, "getSecretElement");
            return Icc;
        }
        log.exiting(CLASSNAME, "getSecretElement");
        return null;
    }

    @Override
    public byte[] getSecret() throws TrustException {
        int i;
        log.entering(CLASSNAME, "getSecret");
        byte[] secret = null;
        for (i = 0; i < this.localExtraElement.length; ++i) {
            OMElement rpt = null;
            rpt = this.localExtraElement[i].getLocalName().equalsIgnoreCase("RequestedProofToken") ? this.localExtraElement[i] : this.localExtraElement[i].getFirstChildWithName(new QName(this.TrustLevel, "RequestedProofToken"));
            if (rpt == null) continue;
            OMElement elem = rpt.getFirstElement();
            if ("EncryptedKey".equals(elem.getLocalName()) && this.TrustLevel.equals(elem.getNamespace().getName())) {
                log.logp(Level.FINER, CLASSNAME, "getSecret", "Found Encrypted Key, use getSecretElement instead");
                this.RPTType = elem.getLocalName();
                log.exiting(CLASSNAME, "getSecret");
                return null;
            }
            if ("BinarySecret".equals(elem.getLocalName()) && this.TrustLevel.equals(elem.getNamespace().getName())) {
                log.logp(Level.FINER, CLASSNAME, "getSecret", "Found Binary Secret Key");
                this.SecretURI = elem.getAttributeValue(new QName(null, "Type"));
                this.RPTType = elem.getLocalName();
                secret = Base64.decode(elem.getText());
                break;
            }
            if (!"ComputedKey".equals(elem.getLocalName()) || !this.TrustLevel.equals(elem.getNamespace().getName())) break;
            log.logp(Level.FINER, CLASSNAME, "getSecret", "Found Computed Key");
            this.RPTType = elem.getLocalName();
            this.SecretURI = elem.getText();
            break;
        }
        if (secret == null) {
            for (i = 0; i < this.localExtraElement.length; ++i) {
                OMElement elem;
                if (!"Entropy".equals(this.localExtraElement[i].getLocalName()) || !this.TrustLevel.equals(this.localExtraElement[i].getNamespace().getName()) || !"BinarySecret".equals((elem = this.localExtraElement[i].getFirstElement()).getLocalName()) || !this.TrustLevel.equals(elem.getNamespace().getName())) continue;
                secret = Base64.decode(elem.getText());
            }
        }
        log.exiting(CLASSNAME, "getSecret");
        return secret;
    }

    @Override
    public String getRequestedProofTokenType() {
        log.entering(CLASSNAME, "getRequestedProofTokenType");
        for (int i = 0; i < this.localExtraElement.length; ++i) {
            OMElement rpt = null;
            rpt = this.localExtraElement[i].getLocalName().equalsIgnoreCase("RequestedProofToken") ? this.localExtraElement[i] : this.localExtraElement[i].getFirstChildWithName(new QName(this.TrustLevel, "RequestedProofToken"));
            if (rpt != null) {
                log.logp(Level.FINER, CLASSNAME, "getRequestedProofTokenType", "Found Requested Proof Token");
                OMElement elem = rpt.getFirstElement();
                if ("EncryptedKey".equals(elem.getLocalName()) && this.TrustLevel.equals(elem.getNamespace().getName())) {
                    log.logp(Level.FINER, CLASSNAME, "getRequestedProofTokenType", "Type is Encrypted Key");
                    this.RPTType = elem.getLocalName();
                    break;
                }
                if ("BinarySecret".equals(elem.getLocalName()) && this.TrustLevel.equals(elem.getNamespace().getName())) {
                    log.logp(Level.FINER, CLASSNAME, "getRequestedProofTokenType", "Type is Binary Secret Key");
                    this.RPTType = elem.getLocalName();
                    break;
                }
                if (!"ComputedKey".equals(elem.getLocalName()) || !this.TrustLevel.equals(elem.getNamespace().getName())) break;
                log.logp(Level.FINER, CLASSNAME, "getRequestedProofTokenType", "Type is Computed Key");
                this.RPTType = elem.getLocalName();
                break;
            }
            this.RPTType = null;
        }
        log.exiting(CLASSNAME, "getRequestedProofTokenType");
        return this.RPTType;
    }

    @Override
    public String getSecretURI() {
        return this.SecretURI;
    }

    @Override
    public Object getTokenElement(String ofType) throws TrustException {
        log.entering(CLASSNAME, "getTokenElement");
        OMElement tokElement = null;
        for (int i = 0; i < this.localExtraElement.length; ++i) {
            tokElement = this.localExtraElement[i].getLocalName().equalsIgnoreCase(ofType) ? this.localExtraElement[i] : this.localExtraElement[i].getFirstChildWithName(new QName(null, ofType));
            if (tokElement == null) continue;
            log.logp(Level.FINER, CLASSNAME, "getTokenElement", "Found Element:" + ofType);
            break;
        }
        log.exiting(CLASSNAME, "getTokenElement");
        return tokElement;
    }

    @Override
    public IRequestedSecurityToken getRequestedSecurityToken() throws TrustException {
        return this.localRequestedSecurityToken;
    }

    @Override
    public String getTokenCreated() throws TrustException {
        log.entering(CLASSNAME, "getTokenCreated");
        OMElement elem = (OMElement)this.getTokenElement("Created");
        String created = null;
        if (elem != null) {
            log.logp(Level.FINER, CLASSNAME, "getTokenCreated", "Found Created Time");
            created = elem.getText();
        }
        log.exiting(CLASSNAME, "getTokenCreated");
        return created;
    }

    @Override
    public String getTokenExpires() throws TrustException {
        log.entering(CLASSNAME, "getTokenExpires");
        OMElement elem = (OMElement)this.getTokenElement("Expires");
        String expires = null;
        if (elem != null) {
            log.logp(Level.FINER, CLASSNAME, "getTokenExpires", "Found Expires Time");
            expires = elem.getText();
        }
        log.exiting(CLASSNAME, "getTokenExpires");
        return expires;
    }

    @Override
    public String getStatusCode() throws TrustException {
        log.entering(CLASSNAME, "getStatusCode");
        OMElement elem = (OMElement)this.getTokenElement("Code");
        String statusCode = null;
        if (elem != null) {
            log.logp(Level.FINER, CLASSNAME, "getStatusCode", "Found Status Code");
            statusCode = elem.getText();
        }
        log.exiting(CLASSNAME, "getStatusCode");
        return statusCode;
    }

    @Override
    public String getStatusReason() throws TrustException {
        log.entering(CLASSNAME, "getStatusReason");
        OMElement elem = (OMElement)this.getTokenElement("Reason");
        String statusReason = null;
        if (elem != null) {
            log.logp(Level.FINER, CLASSNAME, "getStatusReason", "Found Status Reason");
            statusReason = elem.getText();
        }
        log.exiting(CLASSNAME, "getStatusReason");
        return statusReason;
    }

    @Override
    public Boolean isTokenCancelled() throws TrustException {
        log.entering(CLASSNAME, "isTokenCancelled");
        OMElement elem = (OMElement)this.getTokenElement("RequestedTokenCancelled");
        Boolean cancelled = false;
        if (elem != null) {
            log.logp(Level.FINER, CLASSNAME, "isTokenCancelled", "Found Cancelled Element");
            cancelled = true;
        }
        log.exiting(CLASSNAME, "isTokenCancelled");
        return cancelled;
    }

    @Override
    public Iterator<Object> getExtraElements() throws TrustException {
        log.entering(CLASSNAME, "getExtraElements");
        log.exiting(CLASSNAME, "getExtraElements");
        return (Iterator)((Object)this.extraElements);
    }

    @Override
    public void consume(Object element) throws TrustException, Exception {
        if (element != null && element instanceof OMElement) {
            this.parse(((OMElement)element).getXMLStreamReader());
        }
    }

    public void setContext(URI param) throws TrustException {
        this.localContext = param;
    }

    public void setRequestedSecurityToken(IRequestedSecurityToken param) throws TrustException {
        this.localRequestedSecurityToken = param;
    }

    public void setExtraElement(OMElement[] param) throws TrustException {
        this.localExtraElement = param;
    }

    public void parse(XMLStreamReader reader) throws TrustException, Exception {
        log.entering(CLASSNAME, "parse");
        Object diedLookingFor = null;
        try {
            int event = reader.getEventType();
            while (event != 1) {
                event = reader.next();
            }
            String tempAttribContext = reader.getAttributeValue("http://schemas.xmlsoap.org/ws/2005/02/trust", "Context");
            if (tempAttribContext != null) {
                this.setContext(ConverterUtil.convertToanyURI((String)tempAttribContext));
            }
            reader.next();
            ArrayList<OMElement> extralist = new ArrayList<OMElement>();
            boolean loopDone = false;
            boolean loopDone_internal = false;
            while (!loopDone_internal) {
                if (reader.isStartElement()) {
                    loopDone_internal = true;
                    continue;
                }
                reader.next();
            }
            while (!loopDone) {
                event = reader.getEventType();
                if (1 == event) {
                    NamedStaxOMBuilder builder;
                    String localName = reader.getName().getLocalPart();
                    log.logp(Level.FINER, CLASSNAME, "parse", "local input element name:" + localName);
                    if (this.isValidEntryType(localName)) {
                        builder = new NamedStaxOMBuilder(new StreamWrapper(reader), reader.getName());
                        extralist.add(builder.getOMElement());
                        continue;
                    }
                    if (localName.equals("RequestedSecurityToken")) {
                        RequestedSecurityTokenImpl rdst = new RequestedSecurityTokenImpl();
                        rdst.parse(reader);
                        this.setRequestedSecurityToken(rdst);
                        continue;
                    }
                    builder = new NamedStaxOMBuilder(new StreamWrapper(reader), reader.getName());
                    this.extraElements.add(builder.getOMElement());
                    continue;
                }
                if (8 == event) {
                    loopDone = true;
                    continue;
                }
                reader.next();
            }
            this.setExtraElement((OMElement[])ConverterUtil.convertToArray(OMElement.class, extralist));
        }
        catch (XMLStreamException e) {
            if (diedLookingFor != null) {
                throw new TrustException("parser died looking for " + diedLookingFor, e);
            }
            throw new Exception(e);
        }
        log.exiting(CLASSNAME, "parse");
    }

    public boolean isValidEntryType(String type) throws TrustException {
        log.entering(CLASSNAME, "isValidEntryType");
        if (type != null) {
            log.logp(Level.FINER, CLASSNAME, "isValidEntryType", "Entry Type:" + type);
            log.exiting(CLASSNAME, "isValidEntryType");
            return type.equalsIgnoreCase("AppliesTo") || type.equalsIgnoreCase("TokenType") || type.equalsIgnoreCase("RequestType") || type.equalsIgnoreCase("RequestedAttachedReference") || type.equalsIgnoreCase("RequestedUnattachedReference") || type.equalsIgnoreCase("RequestedTokenCancelled") || type.equalsIgnoreCase("Status") || type.equalsIgnoreCase("RequestedProofToken") || type.equalsIgnoreCase("Issuer") || type.equalsIgnoreCase("Claims") || type.equalsIgnoreCase("Entropy") || type.equalsIgnoreCase("BinarySecret") || type.equalsIgnoreCase("EncryptedKey") || type.equalsIgnoreCase("ComputedKey") || type.equalsIgnoreCase("EntropyLength") || type.equalsIgnoreCase("Lifetime") || type.equalsIgnoreCase("AllowPostdating") || type.equalsIgnoreCase("Renewing") || type.equalsIgnoreCase("AuthenticationType") || type.equalsIgnoreCase("KeyType") || type.equalsIgnoreCase("KeySize") || type.equalsIgnoreCase("SignatureAlgorithm") || type.equalsIgnoreCase("Encryption") || type.equalsIgnoreCase("EncryptionAlgorithm") || type.equalsIgnoreCase("CanonicalizationAlgorithm") || type.equalsIgnoreCase("ProofEncryption") || type.equalsIgnoreCase("UseKey") || type.equalsIgnoreCase("SignWith") || type.equalsIgnoreCase("EncryptWith") || type.equalsIgnoreCase("Policy") || type.equalsIgnoreCase("PolicyReference") || type.equalsIgnoreCase("DelegateTo") || type.equalsIgnoreCase("Forwardable") || type.equalsIgnoreCase("Delegatable");
        }
        log.exiting(CLASSNAME, "isValidEntryType");
        return false;
    }
}

