/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.trust10.client.om;

import com.ibm.security.trust10.TrustException;
import com.ibm.security.trust10.client.om.STSConstantsImpl;
import com.ibm.security.trust10.types.IRSTTemplate;
import com.ibm.security.trust10.types.IRequestSecurityToken;
import com.ibm.security.trust10.util.NonceUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;

public class RequestSecurityTokenImpl
implements IRequestSecurityToken {
    private OMElement elemTokenType = null;
    private OMElement elemRequestType = null;
    private OMElement elemCancelType = null;
    private OMElement elemRenewType = null;
    private OMElement elemValidateType = null;
    private OMElement elemAppliesTo = null;
    private OMElement elemClaims = null;
    private OMElement elemEntropy = null;
    private OMElement elemBinarySecret = null;
    private OMElement elemLifetime = null;
    private OMElement elemLifetimeCreated = null;
    private OMElement elemLifetimeExpires = null;
    private OMElement elemAllowPostdating = null;
    private OMElement elemRenewing = null;
    private OMElement elemIssuer = null;
    private OMElement elemAuthenticationType = null;
    private OMElement elemKeyType = null;
    private OMElement elemKeySize = null;
    private OMElement elemSignatureAlgorithm = null;
    private OMElement elemEncryptionAlgorithm = null;
    private OMElement elemCanonicalizationAlgorithm = null;
    private OMElement elemUseKey = null;
    private OMElement elemSignWith = null;
    private OMElement elemEncryptWith = null;
    private OMElement elemPolicy = null;
    private OMElement elemPolicyReference = null;
    private String localContext = null;
    private String TrustLevel = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    private String AddressLevel = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private OMElement[] elements;
    private List list = ConverterUtil.toList(this.elements);
    private byte[] nonce = null;
    private SOAPFactory sfactory;
    private static String CLASSNAME = RequestSecurityTokenImpl.class.getName();
    private static Logger log = Logger.getLogger(CLASSNAME);

    public RequestSecurityTokenImpl(IRSTTemplate template, MessageContext msgContext) throws TrustException {
        String tempString;
        if (msgContext.getProperty("trust_level") != null) {
            this.TrustLevel = (String)msgContext.getProperty("trust_level");
        }
        if (msgContext.getProperty("addressing_level") != null) {
            this.AddressLevel = (String)msgContext.getProperty("addressing_level");
        }
        String SYS_LOGGING_LEVEL = System.getProperty("Logging.Level");
        if (msgContext.getProperty(STSConstantsImpl.LOG_LEVEL) != null) {
            SYS_LOGGING_LEVEL = (String)msgContext.getProperty(STSConstantsImpl.LOG_LEVEL);
        }
        if (SYS_LOGGING_LEVEL != null) {
            SYS_LOGGING_LEVEL = SYS_LOGGING_LEVEL.trim();
            log.setLevel(Level.parse(SYS_LOGGING_LEVEL));
            Handler[] handlers = log.getParent().getHandlers();
            if (handlers != null) {
                for (int i = 0; i < handlers.length; ++i) {
                    handlers[i].setLevel(Level.parse(SYS_LOGGING_LEVEL));
                }
            }
        }
        if (msgContext == null) {
            throw new TrustException("null Message Context not allowed");
        }
        this.sfactory = (SOAPFactory)msgContext.getEnvelope().getOMFactory();
        if (template.get("RequestType") != null) {
            tempString = template.get("RequestType");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "REQ_TYPE: " + tempString);
            this.elemRequestType = this.sfactory.createOMElement("RequestType", this.TrustLevel, "wst");
            this.elemRequestType.setText(tempString);
            this.list.add(this.elemRequestType);
        }
        if (template.getCancelTarget() != null) {
            this.elemCancelType = this.sfactory.createOMElement("CancelTarget", this.TrustLevel, "wst");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Cancel Target Set");
            OMElement cancelTarget = null;
            if (template.getCancelTarget() == null) {
                throw new TrustException("null Cancel Target");
            }
            cancelTarget = (OMElement)template.getCancelTarget();
            this.elemCancelType.setFirstChild(cancelTarget);
            this.list.add(this.elemCancelType);
        }
        if (template.getRenewTarget() != null) {
            this.elemRenewType = this.sfactory.createOMElement("RenewTarget", this.TrustLevel, "wst");
            OMElement renewTarget = null;
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Renew Target Set");
            if (template.getRenewTarget() == null) {
                throw new TrustException("null Renew Target");
            }
            renewTarget = (OMElement)template.getRenewTarget();
            this.elemRenewType.setFirstChild(renewTarget);
            this.list.add(this.elemRenewType);
        }
        if (template.getValidateTarget() != null) {
            this.elemValidateType = this.sfactory.createOMElement("ValidateTarget", this.TrustLevel, "wst");
            OMElement validateTarget = null;
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Validate Target Set");
            if (template.getValidateTarget() == null) {
                throw new TrustException("null Validate Target");
            }
            validateTarget = (OMElement)template.getValidateTarget();
            this.elemValidateType.setFirstChild(validateTarget);
            this.list.add(this.elemValidateType);
        }
        if (template.get("TokenType") != null) {
            String tokString = template.get("TokenType");
            this.elemTokenType = this.sfactory.createOMElement("TokenType", this.TrustLevel, "wst");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Token Type: " + tokString);
            this.elemTokenType.setText(tokString);
            this.list.add(this.elemTokenType);
        }
        if (template.get("AppliesTo") != null) {
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Applies To set");
            OMElement elemAddr = this.sfactory.createOMElement("Address", this.AddressLevel, "wsa");
            elemAddr.setText(template.get("AppliesTo"));
            OMElement elemEP = this.sfactory.createOMElement("EndpointReference", this.AddressLevel, "wsa");
            elemEP.addChild(elemAddr);
            this.elemAppliesTo = this.sfactory.createOMElement("AppliesTo", "http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
            this.elemAppliesTo.addChild(elemEP);
            this.list.add(this.elemAppliesTo);
        }
        if (template.get("Claims") != null) {
            tempString = template.get("Claims");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Claims: " + tempString);
            String tempString2 = template.get("Dialect");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Claims Dialect: " + tempString2);
            this.elemClaims = this.sfactory.createOMElement("Claims", this.TrustLevel, "wst");
            this.elemClaims.setText(tempString);
            this.elemClaims.addAttribute("Dialect", tempString2, null);
            this.list.add(this.elemClaims);
        }
        if (template.get("Entropy") != null) {
            this.elemEntropy = this.sfactory.createOMElement("Entropy", this.TrustLevel, "wst");
            if (template.get("Entropy").equalsIgnoreCase("EncryptedKey")) {
                tempString = template.get("EncryptedKey");
                log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Encrypted Key: " + tempString);
                this.elemBinarySecret = this.sfactory.createOMElement("EncryptedKey", this.TrustLevel, "wst");
                if (template.get("EncryptedKeyId") != null) {
                    String id = template.get("EncryptedKeyId");
                    this.elemBinarySecret.addAttribute("Id", id, null);
                }
                this.elemBinarySecret.setText(tempString);
            } else if (template.get("Entropy").equalsIgnoreCase("ComputedKey")) {
                tempString = template.get("ComputedKey");
                log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Computed Key: " + tempString);
                this.elemBinarySecret = this.sfactory.createOMElement("ComputedKey", this.TrustLevel, "wst");
                this.elemBinarySecret.setText(tempString);
            } else {
                this.elemBinarySecret = this.sfactory.createOMElement("BinarySecret", this.TrustLevel, "wst");
                log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Generating Binary Secret for entropy");
                if (template.get("BinarySecret") != null && template.get("BinarySecret").equalsIgnoreCase("/Nonce")) {
                    int nonceLength = 16;
                    if (template.get("EntropyLength") != null) {
                        nonceLength = new Integer(template.get("EntropyLength"));
                    }
                    log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Nonce Size: " + nonceLength);
                    this.elemBinarySecret.addAttribute("Type", this.TrustLevel + "/Nonce", null);
                    this.nonce = NonceUtil.generateNonce(nonceLength / 8);
                    this.elemBinarySecret.setText(Base64.encode(this.nonce));
                } else if (!(template.get("BinarySecret") != null && template.get("BinarySecret").equalsIgnoreCase("/AsymmetricKey") || template.get("BinarySecret") != null && template.get("BinarySecret").equalsIgnoreCase("/SymmetricKey"))) {
                    this.elemBinarySecret.addAttribute("Type", this.TrustLevel + "/Nonce", null);
                    int nonceLength = 16;
                    this.nonce = NonceUtil.generateNonce(nonceLength);
                    this.elemBinarySecret.setText(Base64.encode(this.nonce));
                }
            }
            this.elemEntropy.addChild(this.elemBinarySecret);
            this.list.add(this.elemEntropy);
        }
        if (template.get("Lifetime") != null && template.get("Created") != null && template.get("Expires") != null) {
            String tempString2 = template.get("Created");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Lifetime Create: " + tempString2);
            String tempString3 = template.get("Expires");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Lifetime Expires: " + tempString3);
            this.elemLifetime = this.sfactory.createOMElement("Lifetime", this.TrustLevel, "wst");
            this.elemLifetimeCreated = this.sfactory.createOMElement("Created", this.TrustLevel, "wsu");
            this.elemLifetimeCreated.setText(tempString2);
            this.elemLifetimeExpires = this.sfactory.createOMElement("Expires", this.TrustLevel, "wsu");
            this.elemLifetimeExpires.setText(tempString3);
            this.elemLifetime.addChild(this.elemLifetimeCreated);
            this.elemLifetime.addChild(this.elemLifetimeExpires);
            this.list.add(this.elemLifetime);
        }
        if (template.get("AllowPostdating") != null) {
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Allow Postdating Set");
            this.elemAllowPostdating = this.sfactory.createOMElement("AllowPostdating", this.TrustLevel, "wst");
            this.list.add(this.elemAllowPostdating);
        }
        if (template.get("Renewing") != null) {
            String tempString2 = template.get("RenewingAllow");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Renewing Allow: " + tempString2);
            String tempString3 = template.get("RenewingOK");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Renewing OK: " + tempString3);
            this.elemRenewing = this.sfactory.createOMElement("Renewing", null, "wst");
            if (tempString2 != null) {
                this.elemRenewing.addAttribute("Allow=", tempString2, null);
            }
            if (tempString3 != null) {
                this.elemRenewing.addAttribute("OK=", tempString3, null);
            }
            this.list.add(this.elemRenewing);
        }
        if (template.get("Issuer") != null) {
            OMElement elemAddr = this.sfactory.createOMElement("Address", this.AddressLevel, "wsa");
            elemAddr.setText(template.get("Issuer"));
            this.elemIssuer = this.sfactory.createOMElement("Issuer", this.TrustLevel, "wst");
            this.elemIssuer.addChild(elemAddr);
            this.list.add(this.elemIssuer);
        }
        if (template.get("AuthenticationType") != null) {
            String tempString2 = template.get("AuthenticationType");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Authentication Type: " + tempString2);
            this.elemAuthenticationType = this.sfactory.createOMElement("AuthenticationType", this.TrustLevel, "wst");
            this.elemAuthenticationType.setText(tempString2);
            this.list.add(this.elemAuthenticationType);
        }
        if (template.get("KeyType") != null) {
            String tempString3 = template.get("KeyType");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Key Type: " + tempString3);
            this.elemKeyType = this.sfactory.createOMElement("KeyType", this.TrustLevel, "wst");
            this.elemKeyType.setText(tempString3);
            this.list.add(this.elemKeyType);
        }
        if (template.get("KeySize") != null) {
            String tempString4 = template.get("KeySize");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Key Size: " + tempString4);
            this.elemKeySize = this.sfactory.createOMElement("KeySize", this.TrustLevel, "wst");
            this.elemKeySize.setText(tempString4);
            this.list.add(this.elemKeySize);
        }
        if (template.get("SignatureAlgorithm") != null) {
            String tempString5 = template.get("SignatureAlgorithm");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Signature Algorithm: " + tempString5);
            this.elemSignatureAlgorithm = this.sfactory.createOMElement("SignatureAlgorithm", this.TrustLevel, "wst");
            this.elemSignatureAlgorithm.setText(tempString5);
            this.list.add(this.elemSignatureAlgorithm);
        }
        if (template.get("Encryption") != null) {
            // empty if block
        }
        if (template.get("EncryptionAlgorithm") != null) {
            String tempString6 = template.get("EncryptionAlgorithm");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Encryption Algorithm: " + tempString6);
            this.elemEncryptionAlgorithm = this.sfactory.createOMElement("EncryptionAlgorithm", this.TrustLevel, "wst");
            this.elemEncryptionAlgorithm.setText(tempString6);
            this.list.add(this.elemEncryptionAlgorithm);
        }
        if (template.get("CanonicalizationAlgorithm") != null) {
            String tempString7 = template.get("CanonicalizationAlgorithm");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Canonicalization Algorithm: " + tempString7);
            this.elemCanonicalizationAlgorithm = this.sfactory.createOMElement("CanonicalizationAlgorithm", this.TrustLevel, "wst");
            this.elemCanonicalizationAlgorithm.setText(tempString7);
            this.list.add(this.elemCanonicalizationAlgorithm);
        }
        if (template.get("ProofEncryption") != null) {
            // empty if block
        }
        if (template.get("UseKey") != null) {
            String tempString8 = template.get("UseKey");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Use Key: " + tempString8);
            String tempString2 = template.get("Sig");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Use Key Signature: " + tempString2);
            this.elemUseKey = this.sfactory.createOMElement("UseKey", this.TrustLevel, "wst");
            this.elemClaims.addAttribute("Sig", tempString2, null);
            this.elemUseKey.setText(tempString8);
            this.list.add(this.elemUseKey);
        }
        if (template.get("SignWith") != null) {
            String tempString9 = template.get("SignWith");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Sign With: " + tempString9);
            this.elemSignWith = this.sfactory.createOMElement("SignWith", this.TrustLevel, "wst");
            this.elemSignWith.setText(tempString9);
            this.list.add(this.elemSignWith);
        }
        if (template.get("EncryptWith") != null) {
            String tempString10 = template.get("EncryptWith");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Encrypt With: " + tempString10);
            this.elemEncryptWith = this.sfactory.createOMElement("EncryptWith", this.TrustLevel, "wst");
            this.elemEncryptWith.setText(tempString10);
            this.list.add(this.elemEncryptWith);
        }
        if (template.get("Policy") != null) {
            String tempString11 = template.get("Policy");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Policy: " + tempString11);
            this.elemPolicy = this.sfactory.createOMElement("Policy", "http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
            this.elemPolicy.setText(tempString11);
            this.list.add(this.elemPolicy);
        }
        if (template.get("PolicyReference") != null) {
            String tempString12 = template.get("PolicyReference");
            log.logp(Level.FINER, CLASSNAME, "RequestSecurityTokenImpl", "Policy Reference: " + tempString12);
            this.elemPolicyReference = this.sfactory.createOMElement("PolicyReference", "http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
            this.elemPolicyReference.setText(tempString12);
            this.list.add(this.elemPolicyReference);
        }
    }

    public void set(String type, Object data) throws TrustException {
        log.entering(CLASSNAME, "set");
        if (type == null || data == null) {
            log.exiting(CLASSNAME, "set");
            return;
        }
        if (!this.isValidEntryType(type) && data instanceof OMElement) {
            log.exiting(CLASSNAME, "set");
            return;
        }
        this.list.add((OMElement)data);
        log.exiting(CLASSNAME, "set");
    }

    public void setLifetime(Date from, Date to) throws TrustException {
    }

    public void setTokenType(Object tokenType) throws TrustException {
        log.entering(CLASSNAME, "setTokenType");
        if (tokenType != null && tokenType instanceof OMElement) {
            this.elemTokenType = (OMElement)tokenType;
        }
        log.exiting(CLASSNAME, "setTokenType");
    }

    public void setRequestType(Object reqType) throws TrustException {
        log.entering(CLASSNAME, "setRequestType");
        if (reqType != null && reqType instanceof OMElement) {
            this.elemRequestType = (OMElement)reqType;
        }
        log.exiting(CLASSNAME, "setRequestType");
    }

    public void setPolicy(Object policy) throws TrustException {
        log.entering(CLASSNAME, "setPolicy");
        if (policy != null && policy instanceof OMElement) {
            this.elemPolicy = (OMElement)policy;
        }
        log.exiting(CLASSNAME, "setPolicy");
    }

    public void setsAppliesTo(Object appliesTo) throws TrustException {
        log.entering(CLASSNAME, "setsAppliesTo");
        if (appliesTo != null && appliesTo instanceof OMElement) {
            this.elemAppliesTo = (OMElement)appliesTo;
        }
        log.exiting(CLASSNAME, "setsAppliesTo");
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public boolean isValidEntryType(String type) throws TrustException {
        log.entering(CLASSNAME, "isValidEntryType");
        if (type != null) {
            log.exiting(CLASSNAME, "isValidEntryType");
            return type.equalsIgnoreCase("AppliesTo") || type.equalsIgnoreCase("TokenType") || type.equalsIgnoreCase("RequestType") || type.equalsIgnoreCase("Issuer") || type.equalsIgnoreCase("Claims") || type.equalsIgnoreCase("Entropy") || type.equalsIgnoreCase("BinarySecret") || type.equalsIgnoreCase("EncryptedKey") || type.equalsIgnoreCase("ComputedKey") || type.equalsIgnoreCase("EntropyLength") || type.equalsIgnoreCase("Lifetime") || type.equalsIgnoreCase("AllowPostdating") || type.equalsIgnoreCase("Renewing") || type.equalsIgnoreCase("AuthenticationType") || type.equalsIgnoreCase("KeyType") || type.equalsIgnoreCase("KeySize") || type.equalsIgnoreCase("SignatureAlgorithm") || type.equalsIgnoreCase("Encryption") || type.equalsIgnoreCase("EncryptionAlgorithm") || type.equalsIgnoreCase("CanonicalizationAlgorithm") || type.equalsIgnoreCase("ProofEncryption") || type.equalsIgnoreCase("UseKey") || type.equalsIgnoreCase("SignWith") || type.equalsIgnoreCase("EncryptWith") || type.equalsIgnoreCase("Policy") || type.equalsIgnoreCase("PolicyReference") || type.equalsIgnoreCase("DelegateTo") || type.equalsIgnoreCase("Forwardable") || type.equalsIgnoreCase("Delegatable");
        }
        log.exiting(CLASSNAME, "isValidEntryType");
        return false;
    }

    public void setContextURI(String context) throws TrustException {
        this.localContext = context;
    }

    public XMLStreamReader getParser(QName qName) throws TrustException {
        log.entering(CLASSNAME, "getParser");
        ArrayList<Object> elementList = new ArrayList<Object>();
        ArrayList<Object> attribList = new ArrayList<Object>();
        this.elements = this.list.toArray(new OMElement[this.list.size()]);
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                elementList.add(new QName(this.elements[i].getLocalName()));
                elementList.add(this.elements[i]);
            }
        }
        if (this.localContext != null) {
            attribList.add(new QName(null, "Context"));
            attribList.add(this.localContext);
        }
        log.exiting(CLASSNAME, "getParser");
        return new ADBXMLStreamReaderImpl(qName, elementList.toArray(), attribList.toArray());
    }
}

