/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.trust10.client;

import com.ibm.security.trust10.TrustException;
import com.ibm.security.trust10.types.IRequestSecurityToken;
import com.ibm.security.trust10.types.IRequestSecurityTokenResponseCollection;
import com.ibm.security.trust10.types.ISTSConfiguration;
import com.ibm.security.trust10.types.ISTSRequestor;
import java.util.Map;

public class STSRequestorFactory
implements ISTSRequestor {
    private ISTSRequestor req = null;

    public Object init(Map parms) throws TrustException {
        Object o = parms.get("STS_Conf");
        if (o == null) {
            throw new TrustException("must have ISTSConstants.ISTSCONFIGURATION in parms");
        }
        if (!(o instanceof ISTSConfiguration)) {
            throw new TrustException("unsupported object type for value of ISTSConstants.ISTSCONFIGURATION");
        }
        ISTSConfiguration conf = (ISTSConfiguration)o;
        String STSProvClass = (String)conf.get("STSREQ_PROV");
        if (STSProvClass == null) {
            STSProvClass = "com.ibm.security.trust10.client.om.STSRequestorImpl";
        }
        this.req = this.loadSTSProvClass(STSProvClass);
        return this.req.init(parms);
    }

    public IRequestSecurityTokenResponseCollection issue(Object service) throws TrustException {
        return this.req.issue(service);
    }

    public IRequestSecurityTokenResponseCollection validate(Object service) throws TrustException {
        return this.req.validate(service);
    }

    public IRequestSecurityTokenResponseCollection renew(Object service) throws TrustException {
        return this.req.renew(service);
    }

    public IRequestSecurityTokenResponseCollection cancel(Object service) throws TrustException {
        return this.req.cancel(service);
    }

    private ISTSRequestor loadSTSProvClass(String className) throws TrustException {
        try {
            return this.loadClass(className);
        }
        catch (Exception exc) {
            return null;
        }
    }

    private ISTSRequestor loadClass(String className) throws Exception {
        Class<?> implementation = null;
        ClassLoader loader = null;
        implementation = loader == null ? Class.forName(className) : loader.loadClass(className);
        return (ISTSRequestor)implementation.newInstance();
    }

    public byte[] getEntropyKey() throws TrustException {
        return this.req.getEntropyKey();
    }

    public IRequestSecurityToken getRST() throws TrustException {
        return this.req.getRST();
    }
}

