/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.Bucket;
import com.ibm.ejs.util.Element;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastHashtable<K, V>
extends Dictionary<K, V> {
    private static final boolean isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    protected Bucket<K, V>[] buckets;
    protected int size = 0;

    public FastHashtable(int n) {
        this.buckets = new Bucket[n];
        if (!isZOS) {
            for (int i = 0; i < n; ++i) {
                this.buckets[i] = new Bucket();
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object getLock(K k) {
        return this.getBucketForKey(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(K k) {
        Bucket<K, V> bucket;
        Bucket<K, V> bucket2 = bucket = this.getBucketForKey(k);
        synchronized (bucket2) {
            Element element = bucket.findByKey(k);
            return element != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object object) {
        Bucket<Object, V> bucket;
        Object object2 = object;
        Bucket<Object, V> bucket2 = bucket = this.getBucketForKey(object2);
        synchronized (bucket2) {
            Element element = bucket.findByKey(object2);
            return element != null ? (V)element.ivObject : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) {
        Object object2 = object;
        Bucket<Object, V> bucket = this.getBucketForKey(object2);
        Element element = null;
        Object object3 = bucket;
        synchronized (object3) {
            element = bucket.removeByKey(object2);
        }
        if (element != null) {
            object3 = this;
            synchronized (object3) {
                --this.size;
            }
            return element.ivObject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        Object object = this;
        synchronized (object) {
            ++this.size;
        }
        Object object2 = object = this.getBucketForKey(k);
        synchronized (object2) {
            Element element = ((Bucket)object).replaceByKey(k, v);
            return element != null ? (V)element.ivObject : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(K k, V v) {
        Object object = this;
        synchronized (object) {
            ++this.size;
        }
        Object object2 = object = this.getBucketForKey(k);
        synchronized (object2) {
            ((Bucket)object).addByKey(k, v);
        }
    }

    @Override
    public final Enumeration elements() {
        return new ObjectEnumerator();
    }

    @Override
    public final Enumeration keys() {
        return new KeyEnumerator();
    }

    public synchronized void clear() {
        this.size = 0;
        this.buckets = new Bucket[this.buckets.length];
        if (!isZOS) {
            for (int i = 0; i < this.buckets.length; ++i) {
                this.buckets[i] = new Bucket();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Bucket<K, V> getBucketForKey(K k) {
        if (isZOS) {
            int n = (k.hashCode() & Integer.MAX_VALUE) % this.buckets.length;
            Bucket<K, V> bucket = this.buckets[n];
            if (bucket == null) {
                FastHashtable fastHashtable = this;
                synchronized (fastHashtable) {
                    bucket = this.buckets[n];
                    if (bucket == null) {
                        this.buckets[n] = bucket = new Bucket();
                    }
                }
            }
            return bucket;
        }
        return this.buckets[(k.hashCode() & Integer.MAX_VALUE) % this.buckets.length];
    }

    public Object get(Object object, Object object2) {
        Element element = ((Bucket)object).findByKey(object2);
        return element != null ? element.ivObject : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2, Object object3) {
        Object object4 = this;
        synchronized (object4) {
            ++this.size;
        }
        object4 = ((Bucket)object).replaceByKey(object2, object3);
        return object4 != null ? ((Element)object4).ivObject : null;
    }

    class KeyEnumerator
    extends ElementEnumerator {
        KeyEnumerator() {
        }

        public Object nextElement() {
            return ((Element)super.nextElement()).ivKey;
        }
    }

    class ObjectEnumerator
    extends ElementEnumerator {
        ObjectEnumerator() {
        }

        public Object nextElement() {
            return ((Element)super.nextElement()).ivObject;
        }
    }

    class ElementEnumerator
    implements Enumeration {
        private int bucketIndex = 0;
        private Element ivCurrentBucketElement;

        ElementEnumerator() {
        }

        public boolean hasMoreElements() {
            if (this.ivCurrentBucketElement != null) {
                return true;
            }
            return this.findNextBucket();
        }

        public Object nextElement() {
            if (this.ivCurrentBucketElement == null && !this.findNextBucket()) {
                throw new NoSuchElementException();
            }
            while (true) {
                try {
                    Element element = this.ivCurrentBucketElement;
                    this.ivCurrentBucketElement = this.ivCurrentBucketElement.ivNext;
                    return element;
                }
                catch (NoSuchElementException noSuchElementException) {
                    FFDCFilter.processException((Throwable)noSuchElementException, "com.ibm.ejs.util.FastHashtable.nextElement", "267", this);
                    if (this.findNextBucket()) continue;
                    throw new NoSuchElementException();
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean findNextBucket() {
            this.ivCurrentBucketElement = null;
            while (this.bucketIndex < FastHashtable.this.buckets.length) {
                Bucket bucket;
                if ((bucket = FastHashtable.this.buckets[this.bucketIndex++]) == null) continue;
                Bucket bucket2 = bucket;
                synchronized (bucket2) {
                    if (bucket.size() > 0) {
                        this.ivCurrentBucketElement = bucket.ivHead;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

