/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.CBETraceLogger;
import com.ibm.ejs.ras.ExtendedTraceLogger;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.SharedLogReader;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.ras.ZOSSharedLogReader;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.logging.cbe.CBEHelper;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class ShowLog {
    private static String svBundle = "com.ibm.ejs.resources.RasMessages";
    private static final int STATE_ERR_UNRECOGNIZED_SWITCH = 1000;
    private static final int STATE_ERR_EXIT = 1001;
    private static long svMinStartDate = new Date(0L).getTime();
    private static final String[] sDateTimeFormats = new String[]{"yyyy-MM-dd HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mm:ss"};

    public static void main(String[] stringArray) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        boolean bl4 = false;
        String string2 = null;
        boolean bl5 = false;
        String string3 = null;
        boolean bl6 = false;
        String string4 = null;
        String string5 = null;
        Date date = null;
        boolean bl7 = false;
        Date date2 = null;
        boolean bl8 = false;
        String string6 = null;
        boolean bl9 = false;
        long l = 0L;
        boolean bl10 = false;
        boolean bl11 = false;
        if (WSLauncher.isZOS()) {
            bl11 = true;
        }
        if (stringArray.length < 1) {
            ShowLog.usage(bl11);
            return;
        }
        boolean bl12 = false;
        int n = 0;
        int n2 = 0;
        int n3 = stringArray.length;
        String string7 = null;
        if (stringArray[n2].equalsIgnoreCase("-help")) {
            ShowLog.usage(bl11);
            return;
        }
        while (!bl12) {
            switch (n) {
                case 0: {
                    if (n2 >= n3) {
                        ShowLog.printMissingRequiredArgumentsDetected();
                        n = 1001;
                        break;
                    }
                    if ((string7 = stringArray[n2++]).equalsIgnoreCase("-xml")) {
                        n = 1;
                        break;
                    }
                    if (string7.equalsIgnoreCase("-language")) {
                        n = 2;
                        break;
                    }
                    if (string7.equalsIgnoreCase("-country")) {
                        n = 3;
                        break;
                    }
                    if (string7.equalsIgnoreCase("-format")) {
                        n = 4;
                        break;
                    }
                    if (string7.equalsIgnoreCase("-debug")) {
                        n = 100;
                        break;
                    }
                    if (!bl11 && string7.startsWith("-")) {
                        n = 1000;
                        break;
                    }
                    if (string7.equalsIgnoreCase("-start")) {
                        n = 5;
                        break;
                    }
                    if (string7.equalsIgnoreCase("-end")) {
                        n = 6;
                        break;
                    }
                    if (string7.equalsIgnoreCase("-encoding")) {
                        n = 7;
                        break;
                    }
                    if (string7.equalsIgnoreCase("-interval")) {
                        n = 8;
                        break;
                    }
                    if (string7.startsWith("-")) {
                        n = 1000;
                        break;
                    }
                    n = 99;
                    break;
                }
                case 1: {
                    if (bl2) {
                        ShowLog.printDuplicateSwitchDetected("-xml");
                        n = 1001;
                        break;
                    }
                    bl2 = true;
                    n = 0;
                    break;
                }
                case 2: {
                    string = ShowLog.consumeSpecifier(stringArray, n2, bl3, "language", "-language");
                    if (string == null) {
                        n = 1001;
                        break;
                    }
                    ++n2;
                    bl3 = true;
                    n = 0;
                    break;
                }
                case 3: {
                    string2 = ShowLog.consumeSpecifier(stringArray, n2, bl4, "country", "-country");
                    if (string2 == null) {
                        n = 1001;
                        break;
                    }
                    ++n2;
                    bl4 = true;
                    n = 0;
                    break;
                }
                case 4: {
                    string3 = ShowLog.consumeSpecifier(stringArray, n2, bl5, "format", "-format");
                    if (string3 == null) {
                        n = 1001;
                        break;
                    }
                    ++n2;
                    bl5 = true;
                    if (!string3.equalsIgnoreCase("CBE-XML-1.0.1")) {
                        System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG111", "Invalid format specifier.  Valid values include CBE-XML-1.0.1"));
                        n = 1001;
                        break;
                    }
                    n = 0;
                    bl6 = true;
                    break;
                }
                case 5: {
                    date = ShowLog.consumeDateSpecifier(stringArray, n2, bl7, "start", "-start");
                    if (date == null) {
                        n = 1001;
                        break;
                    }
                    ++n2;
                    bl7 = true;
                    n = 0;
                    break;
                }
                case 6: {
                    date2 = ShowLog.consumeDateSpecifier(stringArray, n2, bl8, "end", "-end");
                    if (date2 == null) {
                        n = 1001;
                        break;
                    }
                    ++n2;
                    bl8 = true;
                    n = 0;
                    break;
                }
                case 7: {
                    string6 = ShowLog.consumeSpecifier(stringArray, n2, bl9, "encoding", "-encoding");
                    if (string6 == null) {
                        n = 1001;
                        break;
                    }
                    ++n2;
                    bl9 = true;
                    n = 0;
                    break;
                }
                case 8: {
                    l = ShowLog.consumePositiveIntSpecifier(stringArray, n2, bl10, "interval", "-interval");
                    if (l < 0L) {
                        n = 1001;
                        break;
                    }
                    ++n2;
                    bl10 = true;
                    n = 0;
                    break;
                }
                case 99: {
                    string4 = string7;
                    if (bl11) {
                        string4 = string4.toUpperCase();
                    }
                    if (n2 < n3) {
                        if ((string5 = stringArray[n2++]).startsWith("-")) {
                            System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG114", new Object[]{string5}, "Switch " + string5 + " is not allowed at the present position."));
                            n = 1001;
                            break;
                        }
                        if (n2 < n3) {
                            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG115", "Invalid parameters.  Output filename must be the last parameter specified."));
                            n = 1001;
                            break;
                        }
                        bl12 = true;
                        break;
                    }
                    bl12 = true;
                    break;
                }
                case 100: {
                    if (bl) {
                        ShowLog.printDuplicateSwitchDetected("-debug");
                        n = 1001;
                        break;
                    }
                    bl = true;
                    n = 0;
                    break;
                }
                case 1000: {
                    System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG113", new Object[]{string7}, "Unrecognized switch " + string7 + " specified."));
                    n = 1001;
                    break;
                }
                case 1001: {
                    ShowLog.usage(bl11);
                    System.exit(-1);
                }
            }
        }
        if (bl11) {
            boolean bl13 = true;
            if (bl10) {
                if (bl7 || bl8) {
                    System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG118", "Invalid parameters.  Neither start nor end can be specified when an interval is specified."));
                    bl13 = false;
                } else {
                    long l2 = System.currentTimeMillis();
                    date = new Date(l2 - l);
                    date2 = new Date(l2);
                }
            } else if (!bl7) {
                System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG119", "Invalid parameters.  Valid sets include either interval or start."));
                bl13 = false;
            } else {
                if (!bl8) {
                    date2 = new Date();
                }
                if (date.getTime() > date2.getTime()) {
                    System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG121", "Invalid parameters.  Date and time of end must be later than date and time of start."));
                    bl13 = false;
                }
            }
            if (date.getTime() < svMinStartDate) {
                System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG122", "Invalid parameters.  Start date must not be earlier than 1970-01-01T00:00:00GMT."));
                bl13 = false;
            }
            if (!bl13) {
                ShowLog.usage(bl11);
                System.exit(-1);
            }
        }
        if (string6 == null) {
            string6 = System.getProperty("file.encoding");
        }
        if (bl) {
            System.err.println("outputXML\t\t\t\t: " + bl2);
            System.err.println("languageSpecified\t\t: " + bl3);
            System.err.println("languageArg\t\t\t\t: " + string);
            System.err.println("countrySpecified\t\t: " + bl4);
            System.err.println("countryArg\t\t\t\t: " + string2);
            System.err.println("formatSpecified\t\t\t: " + bl5);
            System.err.println("formatArg\t\t\t\t: " + string3);
            System.err.println("outputCBE101\t\t\t: " + bl6);
            System.err.println("inputFilename\t\t\t: " + string4);
            System.err.println("outputFilename\t\t\t: " + string5);
            System.err.println("startDate\t\t\t\t: " + date);
            System.err.println("startParamSpecified\t\t: " + bl7);
            System.err.println("endDate\t\t\t\t\t: " + date2);
            System.err.println("endParamSpecified\t\t: " + bl8);
            System.err.println("fileEncoding\t\t\t: " + string6);
            System.err.println("fileEncodingSpecified\t: " + bl9);
            System.err.println("interval\t\t\t\t: " + l);
            System.err.println("intervalSpecified\t\t: " + bl10);
        }
        PrintStream printStream = null;
        int n4 = 0;
        if (bl11 && string5 == null) {
            string5 = "showlog.out";
        }
        if (string5 == null) {
            printStream = (PrintStream)Tr.getSystemOut();
        } else {
            try {
                RasHelper.validateFileName(string5.trim());
                object = RasHelper.createFileOutputStream(string5, false);
                printStream = new PrintStream((OutputStream)object);
            }
            catch (Throwable throwable) {
                System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG116", new Object[]{string5}, "Unable to open output file " + string5 + "."));
                System.exit(-1);
            }
        }
        object = Locale.getDefault();
        if (string2 == null) {
            string2 = "";
        }
        if (string != null) {
            try {
                object = new Locale(string, string2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        TraceLogger traceLogger = null;
        try {
            traceLogger = bl6 ? new CBETraceLogger((OutputStream)printStream, (Locale)object, string6) : new ExtendedTraceLogger(printStream, bl2, (Locale)object, string6);
            traceLogger.printHeader();
            if (bl11) {
                ZOSSharedLogReader zOSSharedLogReader = new ZOSSharedLogReader(string4, date, date2);
                WsLogRecord wsLogRecord = zOSSharedLogReader.getNextMessage();
                while (wsLogRecord != null) {
                    if (bl) {
                        ShowLog.checkPreviousMessageLocale(traceLogger, wsLogRecord.getImpl(), (Locale)object, "zOS");
                    }
                    traceLogger.doLog(wsLogRecord.getImpl());
                    wsLogRecord = zOSSharedLogReader.getNextMessage();
                    ++n4;
                }
            } else {
                SharedLogReader sharedLogReader = new SharedLogReader(string4, false);
                WsLogRecord wsLogRecord = sharedLogReader.getNextMessage();
                while (wsLogRecord != null) {
                    if (bl) {
                        ShowLog.checkPreviousMessageLocale(traceLogger, wsLogRecord.getImpl(), (Locale)object, "distributed");
                    }
                    traceLogger.doLog(wsLogRecord.getImpl());
                    wsLogRecord = sharedLogReader.getNextMessage();
                    ++n4;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ShowLog.supportedEncodings();
            ShowLog.usage(bl11);
            System.exit(-1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (!bl2 && !bl6) {
            printStream.println();
        }
        traceLogger.printFooter(n4);
        printStream.close();
    }

    private static long consumePositiveIntSpecifier(String[] stringArray, int n, boolean bl, String string, String string2) {
        String string3 = ShowLog.consumeSpecifier(stringArray, n, bl, string, string2);
        if (string3 == null) {
            return -1L;
        }
        boolean bl2 = true;
        long l = -1L;
        try {
            l = Long.parseLong(string3);
            if (l < 1L) {
                bl2 = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = false;
        }
        if (!bl2) {
            System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG112", new Object[]{string2}, "Invalid value specified after " + string2 + " switch.  Valid values are integers greater than 0."));
            return -1L;
        }
        return l;
    }

    private static Date consumeDateSpecifier(String[] stringArray, int n, boolean bl, String string, String string2) {
        String string3 = ShowLog.consumeSpecifier(stringArray, n, bl, string, string2);
        if (string3 == null) {
            return null;
        }
        Date date = ShowLog.parseDateTime(string3);
        if (date == null) {
            System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG120", new Object[]{string2}, "Invalid date or time specified after " + string2 + " switch.  Date and time must be specified in yyyy-MM-ddTHH:mm:ss.SSSZ format.  Milliseconds and time zone are optional."));
            return null;
        }
        return date;
    }

    private static String consumeSpecifier(String[] stringArray, int n, boolean bl, String string, String string2) {
        String string3 = null;
        if (bl) {
            ShowLog.printDuplicateSwitchDetected(string2);
            return null;
        }
        if (n >= stringArray.length) {
            ShowLog.printMissingSpecifierDetected(string, string2);
            return null;
        }
        string3 = stringArray[n];
        if (string3.startsWith("-")) {
            ShowLog.printMissingSpecifierDetected(string, string2);
            return null;
        }
        return string3;
    }

    private static void printMissingRequiredArgumentsDetected() {
        System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG108", "Missing required arguments."));
    }

    private static void printDuplicateSwitchDetected(String string) {
        System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG109", new Object[]{string}, string + " switch specified more than once."));
    }

    private static void printMissingSpecifierDetected(String string, String string2) {
        System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG110", new Object[]{string, string2}, "Missing " + string + " specifier after " + string2 + " switch."));
    }

    private static void usage(boolean bl) {
        if (!bl) {
            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG001", "This program dumps a Websphere binary log file to standard out or a file."));
            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG002", "Usage: showlog [-format CBE-XML-1.0.1] binaryFilename [outputFilename]"));
            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG003", "where:"));
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG007", "-format specifies the output format.  Currently only CBE-XML-1.0.1 format is supported (this complies with the Common Base Event specification version 1.0.1).  If no format is given, showlog outputs in a tabular format."));
            System.err.println();
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG004", "binaryFilename should be a binary log filename in the WASHOME/logs directory or a fully-qualified binary log filename.  showlog will not look in the current directory."));
            System.err.println();
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG005", "outputFilename is optional.  If no filename is given, showlog dumps binaryFilename to standard out.  Otherwise, outputFilename will be created in the current directory unless it is a fully-qualified filename."));
            System.err.println();
        } else {
            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG020", "This program dumps a Websphere binary log file to an output file."));
            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG021", "Usage: showlog {-start startDateTime [-end endDateTime] | -interval interval} [-format CBE-XML-1.0.1] [-encoding encoding] logStreamName [outputFilename]"));
            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG003", "where:"));
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG024", "-start specifies the start date and time, in yyyy-MM-ddTHH:mm:ss.SSSZ format.  Milliseconds and time zone are optional."));
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG026", "-end specifies the end date and time, in yyyy-MM-ddTHH:mm:ss.SSSZ format.  Milliseconds and time zone are optional."));
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG028", "-interval specifies the start date as the system date and time minus interval milliseconds, and end date as the system date and time.  Valid values are integers greater than 0."));
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG029", "-format specifies the output format.  Currently only CBE-XML-1.0.1 format is supported (this complies with the Common Base Event specification version 1.0.1).  If no format is given, showlog outputs in a tabular format."));
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG030", "-encoding specifies the output file encoding, a character encoding supported by the local Java Virtual Machine ."));
            System.err.println();
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG022", "logStream a log filename."));
            System.err.println();
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG023", "outputFilename is optional.  If no filename is given, showlog creates a default showlog.out filename, outputFilename will be created in the current directory unless it is a fully-qualified filename."));
            System.err.println();
        }
    }

    private static void supportedEncodings() {
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        Set<String> set = sortedMap.keySet();
        Iterator iterator = set.iterator();
        System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG117", "Unsupported encoding specified.  The supported encodings are:"));
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.length() < 8) {
                System.err.print(string + "\t\t");
            } else {
                System.err.print(string + "\t");
            }
            if (n++ % 8 != 0) continue;
            System.err.println();
        }
    }

    private static Date parseDateTime(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("T");
        if (n < 0 || n + 1 >= string.length()) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        String string4 = string2 + " " + string3;
        for (int i = 0; i < sDateTimeFormats.length; ++i) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sDateTimeFormats[i]);
                return simpleDateFormat.parse(string4);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    private static void checkPreviousMessageLocale(TraceLogger traceLogger, LogRecord logRecord, Locale locale, String string) {
        if (traceLogger instanceof CBETraceLogger) {
            CommonBaseEventLogRecord commonBaseEventLogRecord = WsLogRecordFactory.convertToCBELogRecord(logRecord);
            CommonBaseEvent commonBaseEvent = commonBaseEventLogRecord.getCommonBaseEvent();
            String string2 = CBEHelper.getMessageLocale(commonBaseEvent);
            if (string2 != null) {
                String string3;
                String string4 = locale.toString();
                String string5 = string2.substring(0, 2);
                String string6 = locale.getLanguage();
                if ((string2.equals(string4) || string5.equals(string6)) && (string3 = CBEHelper.getFormattedMessage(commonBaseEvent)) != null) {
                    System.err.println("CBETraceLogger on " + string + " using CBEHelper.getAlreadyFormattedMessage(): Using previous message locale " + string2 + " instead of current message locale " + string4);
                }
            }
        } else if (traceLogger instanceof ExtendedTraceLogger) {
            CommonBaseEvent commonBaseEvent;
            Locale locale2 = locale;
            if (locale2 == null) {
                locale2 = Locale.getDefault();
            }
            CommonBaseEventLogRecord commonBaseEventLogRecord = logRecord instanceof CommonBaseEventLogRecord ? (CommonBaseEventLogRecord)logRecord : null;
            CommonBaseEvent commonBaseEvent2 = commonBaseEvent = commonBaseEventLogRecord != null ? commonBaseEventLogRecord.getCommonBaseEvent() : null;
            if (commonBaseEvent != null) {
                String string7 = CBEHelper.getMessageLocale(commonBaseEvent);
                if (string7 != null) {
                    String string8;
                    String string9 = locale2.toString();
                    String string10 = string7.substring(0, 2);
                    String string11 = locale.getLanguage();
                    if ((string7.equals(string9) || string10.equals(string11)) && (string8 = CBEHelper.getFormattedMessage(commonBaseEvent)) != null) {
                        System.err.println("ExtendedTraceLogger on " + string + " using CBEHelper.getAlreadyFormattedMessage(): Using previous message locale " + string7 + " instead of current message locale " + string9);
                    }
                }
            } else {
                String string12;
                WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
                if (wsLogRecord != null && wsLogRecord.getLocalizable() != 2 && (string12 = wsLogRecord.getMessageLocale()) != null) {
                    String string13;
                    String string14 = locale2.toString();
                    String string15 = string12.substring(0, 2);
                    String string16 = locale.getLanguage();
                    if ((string12.equals(string14) || string15.equals(string16)) && (string13 = wsLogRecord.getFormattedMessage()) != null) {
                        System.err.println("ExtendedTraceLogger on " + string + " using TraceLogFormatter.formatMessageWSLR(): Using previous message locale " + string12 + " instead of current message locale " + string14);
                    }
                }
            }
        }
    }
}

