/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.oa;

import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.csi.J2EENameImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.ws.security.util.AccessController;

public class EJBOAKeyImpl {
    public static final byte HOME_BEAN = 0;
    public static final byte STATELESS_BEAN = 1;
    public static final byte STATEFUL_BEAN = 2;
    public static final byte ENTITY_BEAN = 3;
    public static final byte MESSAGEDRIVEN_BEAN = 4;
    public static final byte USES_BEAN_MANAGED_TX = 16;
    private static final byte[] BEAN_ID_HEADER = new byte[]{-84, -84, 0, 2, 0, 1};
    private static final byte[] WRAPPER_ID_HEADER = new byte[]{-83, -84, 0, 2, 0, 1};
    private static final int BEAN_TYPE_LEN = 1;
    private static final int J2EE_NAME_LEN = 4;
    private static final int PKEY_TYPE_LEN = 1;
    private static final int BEAN_ID_HEADER_LEN = BEAN_ID_HEADER.length;
    private static final int WRAPPER_ID_HEADER_LEN = WRAPPER_ID_HEADER.length;
    private byte[] ivServantKey;
    private boolean ivIsHome = false;
    private byte[] ivJ2eeNameBytes;
    private boolean ivIsJ2eeNameSet = false;
    private boolean ivIsBeanManaged = false;
    private byte ivBeanType;
    private boolean ivIsBeanTypeSet = false;
    private byte[] ivPrimaryKeyBytes;
    private boolean ivIsPrimaryKeySet = false;
    private int ivBeanIdIndex = 0;
    private static final TraceComponent tc = Tr.register(EJBOAKeyImpl.class, "ObjectAdapter", "com.ibm.ws.runtime.runtime");

    public EJBOAKeyImpl(byte[] byArray) {
        this.ivServantKey = byArray;
        if (this.ivServantKey[0] == WRAPPER_ID_HEADER[0]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting start of BeanId in serialized WrapperId bytes.");
            }
            this.ivBeanIdIndex = this.getBeanIdIndexFromWrapperId(byArray);
        }
        int n = this.ivBeanIdIndex;
        for (int i = 0; i < BEAN_ID_HEADER_LEN; ++i) {
            if (this.ivServantKey[n++] == BEAN_ID_HEADER[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header mismatch, servant key is not a BeanId.");
            }
            throw new IllegalArgumentException("Invalid Servant Key, not a BeanId object");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "EJB type in BeanId: " + this.ivServantKey[n]);
        }
        switch (this.ivServantKey[n]) {
            case 0: {
                this.ivIsHome = true;
                this.ivIsPrimaryKeySet = true;
                break;
            }
            case 17: 
            case 20: {
                this.ivIsPrimaryKeySet = true;
            }
            case 18: {
                this.ivIsBeanManaged = true;
                break;
            }
            case 1: 
            case 4: {
                this.ivIsPrimaryKeySet = true;
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to parse bean id: unsupported EJB type: " + this.ivServantKey[n]);
                }
                throw new IllegalArgumentException("Unsupported EJB Type: " + this.ivServantKey[n]);
            }
        }
    }

    private int getBeanIdIndexFromWrapperId(byte[] byArray) {
        int n;
        for (n = 0; n < WRAPPER_ID_HEADER_LEN; ++n) {
            if (byArray[n] == WRAPPER_ID_HEADER[n]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header mismatch, invalid WrapperId.");
            }
            throw new IllegalArgumentException("Invalid Servant Key, not a WrapperId object");
        }
        n = WRAPPER_ID_HEADER_LEN + 4;
        int n2 = 0;
        n2 = EJSPlatformHelper.isZOS() ? (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF : byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        return n + n2;
    }

    public byte[] getJ2EENameBytes() {
        if (!this.ivIsJ2eeNameSet) {
            this.ivJ2eeNameBytes = this.readJ2EENameBytes();
            if (this.ivIsHome) {
                this.ivJ2eeNameBytes = this.readPrimaryKeyBytes();
            }
            this.ivIsJ2eeNameSet = true;
        }
        return this.ivJ2eeNameBytes;
    }

    public boolean isBeanManagedTransaction() {
        if (this.ivIsHome) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Indication of transaction demarcation is not available for home beans. ");
            }
            throw new IllegalStateException("Indication of transaction demarcation is not available for home beans.");
        }
        return this.ivIsBeanManaged;
    }

    public byte getBeanType() {
        if (!this.ivIsBeanTypeSet) {
            if (this.ivIsHome) {
                this.ivBeanType = 0;
            } else {
                switch (this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]) {
                    case 1: 
                    case 17: {
                        this.ivBeanType = 1;
                        break;
                    }
                    case 2: 
                    case 18: {
                        this.ivBeanType = (byte)2;
                        break;
                    }
                    case 4: 
                    case 20: {
                        this.ivBeanType = (byte)4;
                        break;
                    }
                    case 3: {
                        this.ivBeanType = (byte)3;
                        break;
                    }
                    default: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Unsupported EJB type: " + this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]);
                        }
                        throw new IllegalArgumentException("Unsupported EJB Type: " + this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]);
                    }
                }
            }
            this.ivIsBeanTypeSet = true;
        }
        return this.ivBeanType;
    }

    public boolean isHome() {
        return this.ivIsHome;
    }

    public byte[] getPrimaryKeyBytes() {
        if (!this.ivIsPrimaryKeySet) {
            if (!this.ivIsJ2eeNameSet) {
                this.getJ2EENameBytes();
            }
            this.ivPrimaryKeyBytes = this.readPrimaryKeyBytes();
            this.ivIsPrimaryKeySet = true;
        }
        return this.ivPrimaryKeyBytes;
    }

    private byte[] readJ2EENameBytes() {
        int n;
        int n2 = 0;
        int n3 = BEAN_ID_HEADER_LEN + 1 + this.ivBeanIdIndex;
        if (EJSPlatformHelper.isZOS()) {
            n = n3;
            n2 = (this.ivServantKey[n] & 0xFF) << 24 | (this.ivServantKey[n + 1] & 0xFF) << 16 | (this.ivServantKey[n + 2] & 0xFF) << 8 | this.ivServantKey[n + 3] & 0xFF;
        } else {
            for (n = 3; n >= 0; --n) {
                n2 ^= this.ivServantKey[n3 + n] & 0xFF;
                if (n <= 0) continue;
                n2 <<= 8;
            }
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.ivServantKey, n3 += 4, byArray, 0, n2);
        return byArray;
    }

    private byte[] readPrimaryKeyBytes() {
        byte[] byArray = null;
        try {
            int n = this.ivBeanIdIndex + BEAN_ID_HEADER_LEN + 1 + 4 + this.ivJ2eeNameBytes.length + 1;
            int n2 = this.ivServantKey.length - n;
            byArray = new byte[n2];
            System.arraycopy(this.ivServantKey, n, byArray, 0, n2);
        }
        catch (Throwable throwable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to parse bean id: primary key: " + throwable);
            }
            throw new IllegalArgumentException("Unable to read primary key bytes.", throwable);
        }
        return byArray;
    }

    public String toString() {
        String string = (String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("line.separator", "\n"));
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "                                 ";
        String string3 = "                                     ";
        stringBuffer.append(string + string2 + "**************    EJBOAKeyImpl Dump    **************");
        stringBuffer.append(string + string3 + "J2EEName = ");
        J2EENameImpl j2EENameImpl = new J2EENameImpl(this.getJ2EENameBytes());
        stringBuffer.append(j2EENameImpl);
        stringBuffer.append(string + string3 + "Bean Type = ");
        stringBuffer.append(this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]);
        stringBuffer.append(":  ");
        stringBuffer.append(this.getBeanTypeString());
        return stringBuffer.toString();
    }

    private String getBeanTypeString() {
        String string = null;
        switch (this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]) {
            case 0: {
                string = "Home Bean";
                break;
            }
            case 17: {
                string = "Bean Managed Transaction: Stateless Session Bean";
                break;
            }
            case 1: {
                string = "Container Managed Transaction: Stateless Session Bean";
                break;
            }
            case 18: {
                string = "Bean Managed Transaction: Stateful Session Bean";
                break;
            }
            case 2: {
                string = "Container Managed Transaction: Stateful Session Bean";
                break;
            }
            case 20: {
                string = "Bean Managed Transaction: Message Driven Bean";
                break;
            }
            case 4: {
                string = "Container Managed Transaction: Message Driven Bean";
                break;
            }
            case 3: {
                string = "Entity Bean";
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unsupported EJB type: " + this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]);
                }
                throw new IllegalArgumentException("Unsupported EJB Type: " + this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]);
            }
        }
        return string;
    }
}

