/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.models.base.extensions.commonext.localtran.LocalTransaction;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.ejbext.LocalTran;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.websphere.csi.LocalTranConfigData;
import com.ibm.ws.security.util.AccessController;

public class LocalTranConfigDataImpl
implements LocalTranConfigData {
    private static final TraceComponent tc = Tr.register(LocalTranConfigDataImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private int boundary = 0;
    private int resolver = 0;
    private int unresolvedAction = 0;

    public LocalTranConfigDataImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Default CTOR was called, using default values for config data");
        }
    }

    public LocalTranConfigDataImpl(EnterpriseBeanExtension enterpriseBeanExtension) {
        if (enterpriseBeanExtension != null) {
            LocalTransaction localTransaction;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "CTOR was passed non-null EnterpriseBeanExtension object for config data");
            }
            if (enterpriseBeanExtension.getEnterpriseBean().isContainerManagedEntity()) {
                this.resolver = 1;
            }
            if ((localTransaction = enterpriseBeanExtension.getLocalTransaction()) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "We have a LocalTransaction object, so use the 5.0 or later config data");
                }
                this.init(localTransaction);
            } else {
                LocalTran localTran;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No LocalTransaction object, checking for a LocalTran object");
                }
                if ((localTran = enterpriseBeanExtension.getLocalTran()) != null && localTran.isSetUnresolvedAction() && localTran.getUnresolvedAction().getValue() == 1) {
                    this.unresolvedAction = 1;
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "CTOR was passed a null EnterpriseBeanExtension object, using default values for config data");
        }
    }

    public LocalTranConfigDataImpl(LocalTransaction localTransaction) {
        this.init(localTransaction);
    }

    private void init(LocalTransaction localTransaction) {
        if (localTransaction != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "init was passed non-null LocalTransaction object for config data");
            }
            if (localTransaction.isSetBoundary()) {
                this.boundary = localTransaction.getBoundary().getValue();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "LocalTransaction boundary is NOT set, using default value of BeanMethod");
            }
            if (localTransaction.isSetResolver()) {
                this.resolver = localTransaction.getResolver().getValue();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "LocalTransaction resolver is NOT set, using default value of Application");
            }
            if (localTransaction.isSetUnresolvedAction()) {
                this.unresolvedAction = localTransaction.getUnresolvedAction().getValue();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "LocalTransaction unresolved action is NOT set, using default value of Rollback");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "init was passed a null LocalTransaction object, using default values for config data");
        }
    }

    public int getValueBoundary() {
        return this.boundary;
    }

    public int getValueResolver() {
        return this.resolver;
    }

    public int getValueUnresolvedAction() {
        return this.unresolvedAction;
    }

    public String toString() {
        String string = (String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("line.separator", "\n"));
        String string2 = "                                 ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + string2 + "      ****** LOCAL-TRANSACTION *******");
        if (this.boundary == 1) {
            stringBuffer.append(string + string2 + "Boundary=ACTIVITY");
        } else if (this.boundary == 0) {
            stringBuffer.append(string + string2 + "Boundary=BEAN_METHOD");
        } else {
            stringBuffer.append(string + string2 + "Boundary=UNKNOWN");
        }
        if (this.resolver == 0) {
            stringBuffer.append(string + string2 + "Resolver=APPLICATION");
        } else if (this.resolver == 1) {
            stringBuffer.append(string + string2 + "Resolver=CONTAINER_AT_BOUNDARY");
        } else {
            stringBuffer.append(string + string2 + "Resolver=UNKNOWN");
        }
        if (this.unresolvedAction == 0) {
            stringBuffer.append(string + string2 + "UnResolvedAction=ROLLBACK");
        } else if (this.unresolvedAction == 1) {
            stringBuffer.append(string + string2 + "UnResolvedAction=COMMIT");
        } else {
            stringBuffer.append(string + string2 + "UnResolvedAction=UNKNOWN");
        }
        return stringBuffer.toString();
    }
}

